/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.capability;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.util.WitherStormModNBTUtil;

public class WitherStormChunkHolder {
    private final ServerLevel world;
    private Map<UUID, BlockPos> stormPositions = new ConcurrentHashMap<UUID, BlockPos>();
    private Map<UUID, BlockPos> prevStormPositions = new ConcurrentHashMap<UUID, BlockPos>();
    private Map<UUID, Queue<ChunkPos>> chunksToLoad = new ConcurrentHashMap<UUID, Queue<ChunkPos>>();
    private Map<UUID, List<ChunkPos>> chunksToUnload = new ConcurrentHashMap<UUID, List<ChunkPos>>();
    private Map<UUID, List<ChunkPos>> chunksLoaded = new ConcurrentHashMap<UUID, List<ChunkPos>>();
    private List<ChunkPos> allLoadedChunks = new ArrayList<ChunkPos>();
    private final int total = 576;
    private boolean firstTick = true;

    public WitherStormChunkHolder(ServerLevel world) {
        this.world = world;
    }

    public WitherStormChunkHolder() {
        this.world = null;
    }

    public void unloadAll() {
        for (Map.Entry<UUID, BlockPos> entry : this.stormPositions.entrySet()) {
            this.chunksToLoad.get(entry.getKey()).clear();
            this.chunksToUnload.get(entry.getKey()).addAll((Collection<ChunkPos>)this.chunksLoaded.get(entry.getKey()));
        }
    }

    public void refresh() {
        for (Map.Entry<UUID, BlockPos> entry : this.stormPositions.entrySet()) {
            this.refresh(entry.getKey());
        }
    }

    public void refresh(UUID uuid) {
        ArrayList chunksToUnload = new ArrayList();
        chunksToUnload.addAll(this.chunksLoaded.get(uuid));
        int size = chunksToUnload.size();
        for (int i = 0; i < size; ++i) {
            ChunkPos pos = (ChunkPos)chunksToUnload.get(i);
            boolean flag = true;
            for (Map.Entry<UUID, List<ChunkPos>> entry2 : this.chunksLoaded.entrySet()) {
                List<ChunkPos> loadedChunks;
                if (entry2.getKey().equals(uuid) || !(loadedChunks = entry2.getValue()).contains(pos)) continue;
                flag = false;
            }
            if (flag) {
                this.allLoadedChunks.remove(pos);
                this.world.m_8602_(pos.f_45578_, pos.f_45579_, false);
                this.setForcedChunksDirty();
            }
            if (!this.chunksLoaded.containsKey(uuid)) continue;
            this.chunksLoaded.get(uuid).remove(pos);
        }
        this.createChunkQueue(uuid, new ChunkPos(this.stormPositions.get(uuid)), true);
    }

    public void refresh(WitherStormEntity storm) {
        this.refresh(storm.m_20148_());
    }

    public void createChunkQueue(WitherStormEntity storm, ChunkPos start, boolean stopCurrentProcess) {
        this.createChunkQueue(storm.m_20148_(), start, stopCurrentProcess);
    }

    public void createChunkQueue(UUID uuid, ChunkPos start, boolean stopCurrentProcess) {
        if (this.chunksToLoad.containsKey(uuid) && this.chunksToUnload.containsKey(uuid)) {
            Queue<ChunkPos> chunksToLoad = this.chunksToLoad.get(uuid);
            if (stopCurrentProcess) {
                this.chunksToLoad.get(uuid).clear();
            }
            int currentSize = 0;
            ArrayList<ChunkPos> allChunksInRadius = new ArrayList<ChunkPos>();
            if (!this.allLoadedChunks.contains(start) && !this.world.m_8902_().contains(start.m_45588_())) {
                chunksToLoad.add(start);
            }
            allChunksInRadius.add(start);
            ++currentSize;
            int radius = 1;
            while (currentSize < this.total) {
                int q;
                for (q = -radius + 1; q <= radius && currentSize < this.total; ++currentSize, ++q) {
                    if (!this.allLoadedChunks.contains(new ChunkPos(start.f_45578_ + radius, start.f_45579_ + q)) && !this.world.m_8902_().contains(new ChunkPos(start.f_45578_ + radius, start.f_45579_ + q).m_45588_())) {
                        chunksToLoad.add(new ChunkPos(start.f_45578_ + radius, start.f_45579_ + q));
                    }
                    allChunksInRadius.add(new ChunkPos(start.f_45578_ + radius, start.f_45579_ + q));
                }
                for (q = radius - 1; q >= -radius && currentSize < this.total; ++currentSize, --q) {
                    if (!this.allLoadedChunks.contains(new ChunkPos(start.f_45578_ + q, start.f_45579_ + radius)) && !this.world.m_8902_().contains(new ChunkPos(start.f_45578_ + q, start.f_45579_ + radius).m_45588_())) {
                        chunksToLoad.add(new ChunkPos(start.f_45578_ + q, start.f_45579_ + radius));
                    }
                    allChunksInRadius.add(new ChunkPos(start.f_45578_ + q, start.f_45579_ + radius));
                }
                for (q = radius - 1; q >= -radius && currentSize < this.total; ++currentSize, --q) {
                    if (!this.allLoadedChunks.contains(new ChunkPos(start.f_45578_ - radius, start.f_45579_ + q)) && !this.world.m_8902_().contains(new ChunkPos(start.f_45578_ - radius, start.f_45579_ + q).m_45588_())) {
                        chunksToLoad.add(new ChunkPos(start.f_45578_ - radius, start.f_45579_ + q));
                    }
                    allChunksInRadius.add(new ChunkPos(start.f_45578_ - radius, start.f_45579_ + q));
                }
                for (q = -radius + 1; q <= radius && currentSize < this.total; ++currentSize, ++q) {
                    if (!this.allLoadedChunks.contains(new ChunkPos(start.f_45578_ + q, start.f_45579_ - radius)) && !this.world.m_8902_().contains(new ChunkPos(start.f_45578_ + q, start.f_45579_ - radius).m_45588_())) {
                        chunksToLoad.add(new ChunkPos(start.f_45578_ + q, start.f_45579_ - radius));
                    }
                    allChunksInRadius.add(new ChunkPos(start.f_45578_ + q, start.f_45579_ - radius));
                }
                ++radius;
            }
            for (int i = 0; i < this.chunksLoaded.get(uuid).size(); ++i) {
                ChunkPos pos = this.chunksLoaded.get(uuid).get(i);
                if (allChunksInRadius.contains(pos)) continue;
                this.chunksToUnload.get(uuid).add(pos);
            }
            this.chunksToLoad.put(uuid, chunksToLoad);
        }
    }

    public void clear(WitherStormEntity entity) {
        this.clear(entity.m_20148_());
    }

    public void clear(UUID uuid) {
        this.chunksToLoad.get(uuid).clear();
        this.chunksToUnload.get(uuid).addAll((Collection<ChunkPos>)this.chunksLoaded.get(uuid));
    }

    public void tick() {
        boolean bl;
        ServerChunkCache provider = this.world.m_7726_();
        for (Map.Entry<UUID, Queue<ChunkPos>> entry : this.chunksToLoad.entrySet()) {
            ChunkPos next;
            Queue<ChunkPos> queue = entry.getValue();
            if (queue.size() > 0 && (next = queue.poll()) != null) {
                boolean flag2 = true;
                for (Map.Entry<UUID, List<ChunkPos>> entry2 : this.chunksToUnload.entrySet()) {
                    List<ChunkPos> list = entry2.getValue();
                    if (!list.contains(next)) continue;
                    flag2 = false;
                }
                if (flag2 && !this.allLoadedChunks.contains(next)) {
                    this.allLoadedChunks.add(next);
                    this.world.m_8602_(next.f_45578_, next.f_45579_, true);
                    this.setForcedChunksDirty();
                }
                this.chunksLoaded.get(entry.getKey()).add(next);
            }
            if (this.stormPositions.containsKey(entry.getKey()) || queue.size() > 0) continue;
            this.chunksToLoad.remove(entry.getKey());
        }
        for (Map.Entry<UUID, Collection<ChunkPos>> entry : this.chunksToUnload.entrySet()) {
            List list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                ChunkPos next = (ChunkPos)list.get(i);
                this.chunksToUnload.get(entry.getKey()).remove(next);
                if (next != null) {
                    boolean flag3 = true;
                    for (Map.Entry entry2 : this.chunksLoaded.entrySet()) {
                        List loadedChunks;
                        if (((UUID)entry2.getKey()).equals(entry.getKey()) || !(loadedChunks = (List)entry2.getValue()).contains(next)) continue;
                        flag3 = false;
                    }
                    if (flag3) {
                        this.allLoadedChunks.remove(next);
                        this.world.m_8602_(next.f_45578_, next.f_45579_, false);
                        this.setForcedChunksDirty();
                    }
                    if (this.chunksLoaded.containsKey(entry.getKey())) {
                        this.chunksLoaded.get(entry.getKey()).remove(next);
                    }
                }
                if (this.stormPositions.containsKey(entry.getKey())) continue;
                if (list.size() <= 0) {
                    this.chunksToUnload.remove(entry.getKey());
                }
                if (!this.stormPositions.isEmpty() || this.allLoadedChunks.isEmpty()) continue;
                for (int y = 0; y < this.allLoadedChunks.size(); ++y) {
                    ChunkPos pos = this.allLoadedChunks.get(y);
                    this.world.m_8602_(pos.f_45578_, pos.f_45579_, false);
                    this.setForcedChunksDirty();
                }
            }
        }
        int tickSpeed = this.world.m_46469_().m_46215_(GameRules.f_46143_);
        if (tickSpeed > 0) {
            for (Map.Entry<UUID, List<ChunkPos>> entry : this.chunksLoaded.entrySet()) {
                List<ChunkPos> loadedChunks = entry.getValue();
                for (ChunkPos pos : loadedChunks) {
                    if (provider.f_8325_.m_183262_(pos, false).size() != 0) continue;
                    this.world.m_8714_(this.world.m_6325_(pos.f_45578_, pos.f_45579_), tickSpeed);
                }
                if (this.stormPositions.containsKey(entry.getKey()) || loadedChunks.size() > 0) continue;
                this.chunksLoaded.remove(entry.getKey());
            }
        }
        if (this.firstTick && !this.world.m_7654_().m_129792_() && !(bl = WitherStormModConfig.SERVER.shouldChunkLoadWhenNoPlayers.get().booleanValue())) {
            this.unloadAll();
        }
        this.firstTick = false;
    }

    public void addStorm(WitherStormEntity storm) {
        if (!this.stormPositions.containsKey(storm.m_20148_())) {
            if (!this.prevStormPositions.containsKey(storm.m_20148_())) {
                this.prevStormPositions.put(storm.m_20148_(), storm.m_20183_());
            }
            this.stormPositions.put(storm.m_20148_(), storm.m_20183_());
            this.chunksToLoad.put(storm.m_20148_(), new ArrayDeque());
            this.chunksToUnload.put(storm.m_20148_(), new ArrayList());
            this.chunksLoaded.put(storm.m_20148_(), new ArrayList());
            ChunkPos chunk = new ChunkPos(storm.m_20183_());
            this.createChunkQueue(storm, chunk, false);
        }
    }

    public void updateStormPosition(WitherStormEntity storm) {
        if (this.stormPositions.containsKey(storm.m_20148_())) {
            if (this.prevStormPositions.containsKey(storm.m_20148_())) {
                this.prevStormPositions.replace(storm.m_20148_(), this.stormPositions.get(storm.m_20148_()));
            }
            this.stormPositions.replace(storm.m_20148_(), storm.m_20183_());
        }
    }

    public void removeStorm(WitherStormEntity storm) {
        this.removeStorm(storm.m_20148_());
    }

    public void removeStorm(UUID uuid) {
        if (this.stormPositions.containsKey(uuid)) {
            this.clear(uuid);
            this.stormPositions.remove(uuid);
            this.prevStormPositions.remove(uuid);
        }
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        if (!this.allLoadedChunks.isEmpty()) {
            compound.m_128365_("AllChunksLoaded", (Tag)WitherStormModNBTUtil.writeChunkPosList(this.allLoadedChunks));
        }
        ArrayList stormPositionsKeys = new ArrayList();
        this.stormPositions.keySet().iterator().forEachRemaining(stormPositionsKeys::add);
        for (int i = 0; i < stormPositionsKeys.size(); ++i) {
            CompoundTag uuidCompound = new CompoundTag();
            uuidCompound.m_128362_("uuid", (UUID)stormPositionsKeys.get(i));
            uuidCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.stormPositions.get(stormPositionsKeys.get(i))));
            if (!this.chunksLoaded.get(stormPositionsKeys.get(i)).isEmpty()) {
                uuidCompound.m_128365_("ChunksLoaded", (Tag)WitherStormModNBTUtil.writeChunkPosList(this.chunksLoaded.get(stormPositionsKeys.get(i))));
            }
            compound.m_128365_("Storm" + i, (Tag)uuidCompound);
        }
        ArrayList chunksToUnloadKeys = new ArrayList();
        this.chunksToUnload.keySet().iterator().forEachRemaining(chunksToUnloadKeys::add);
        for (int i = 0; i < chunksToUnloadKeys.size(); ++i) {
            CompoundTag unloadCompound = new CompoundTag();
            if (this.chunksToUnload.get(chunksToUnloadKeys.get(i)).isEmpty()) continue;
            unloadCompound.m_128362_("uuid", (UUID)chunksToUnloadKeys.get(i));
            unloadCompound.m_128365_("chunks", (Tag)WitherStormModNBTUtil.writeChunkPosList(this.chunksToUnload.get(chunksToUnloadKeys.get(i))));
            compound.m_128365_("ChunksToUnload" + i, (Tag)unloadCompound);
        }
        return compound;
    }

    public void read(CompoundTag compound) {
        if (compound.m_128441_("AllChunksLoaded")) {
            this.allLoadedChunks = WitherStormModNBTUtil.readChunkPosList(compound.m_128469_("AllChunksLoaded"));
        }
        for (int i = 0; i < compound.m_128431_().size(); ++i) {
            CompoundTag unloadCompound;
            CompoundTag uuidCompound = compound.m_128469_("Storm" + i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)uuidCompound.m_128469_("pos"));
            if (uuidCompound.m_128403_("uuid")) {
                UUID uuid = uuidCompound.m_128342_("uuid");
                if (uuidCompound.m_128441_("ChunksLoaded")) {
                    this.chunksLoaded.put(uuid, WitherStormModNBTUtil.readChunkPosList(uuidCompound.m_128469_("ChunksLoaded")));
                } else {
                    this.chunksLoaded.put(uuid, new ArrayList());
                }
                this.stormPositions.put(uuid, pos);
                this.prevStormPositions.put(uuid, pos);
                this.chunksToLoad.put(uuid, new ArrayDeque());
                this.chunksToUnload.put(uuid, new ArrayList());
                ChunkPos chunk = new ChunkPos(pos);
                if (!this.world.m_7654_().m_129792_()) {
                    if (WitherStormModConfig.SERVER.shouldChunkLoadWhenNoPlayers.get().booleanValue()) {
                        this.createChunkQueue(uuid, chunk, false);
                    }
                } else {
                    this.createChunkQueue(uuid, chunk, false);
                }
            }
            if (!(unloadCompound = compound.m_128469_("ChunksToUnload" + i)).m_128403_("uuid")) continue;
            UUID uuid = unloadCompound.m_128342_("uuid");
            this.chunksToUnload.put(uuid, WitherStormModNBTUtil.readChunkPosList(unloadCompound.m_128469_("chunks")));
        }
    }

    public Map<UUID, BlockPos> getStormPositions() {
        return this.stormPositions;
    }

    public Map<UUID, BlockPos> getPrevStormPositions() {
        return this.prevStormPositions;
    }

    public Map<UUID, List<ChunkPos>> getLoadedChunks() {
        return this.chunksLoaded;
    }

    public Map<UUID, Queue<ChunkPos>> getChunksToLoad() {
        return this.chunksToLoad;
    }

    public List<ChunkPos> getAllLoadedChunks() {
        return this.allLoadedChunks;
    }

    public void setForcedChunksDirty() {
        ForcedChunksSavedData chunks = (ForcedChunksSavedData)this.world.m_8895_().m_164861_(ForcedChunksSavedData::m_151483_, ForcedChunksSavedData::new, "chunks");
        chunks.m_77762_();
    }
}

