/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.capability.EntityCapability;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEffects;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.UpdateEffectInstanceMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateWitherSicknessTrackerMessage;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModEntityTags;

public class WitherSicknessTracker
extends EntityCapability<WitherSicknessTracker, LivingEntity> {
    private int requiredProximityTicks;
    private int applicationDelay;
    private int cureDelay;
    private int requiredContacts;
    private int multiplierDecreaseTime;
    private int contactsDecreaseTime;
    private int proximityTicksModifier;
    private int applicationDelayModifier;
    private int cureDelayModifier;
    private int proximityTicks;
    private int prevProximityTicks;
    private int delayTicks;
    private int prevDelayTicks;
    private int contacts;
    private int totalInfections;
    private int totalCures;
    private int amplifierDecreaseTicks;
    private int amplifier;
    private int contactsDecreaseTicks;
    private int cureDelayTicks;
    private int prevCureDelayTicks;
    private boolean isInfected;
    private boolean isBeingCured;
    private boolean isNearStorm;
    private boolean shouldUpdate;
    private boolean isActuallyImmune;

    public WitherSicknessTracker(LivingEntity entity) {
        super(entity);
        this.requiredProximityTicks = Math.max(240, WitherStormModConfig.SERVER.requiredProximitySeconds.get() * 20);
        this.applicationDelay = Math.max(240, WitherStormModConfig.SERVER.applicationDelay.get() * 20);
        this.cureDelay = Math.max(240, WitherStormModConfig.SERVER.cureDelay.get() * 20);
        this.requiredContacts = Math.max(1, WitherStormModConfig.SERVER.requiredContacts.get());
        this.multiplierDecreaseTime = 7200;
        this.contactsDecreaseTime = 9600;
        this.isActuallyImmune = true;
        if (!entity.f_19853_.f_46443_) {
            this.randomizeModifiers();
        }
    }

    public void randomizeModifiers() {
        if (this.isLowImmunity()) {
            this.requiredProximityTicks = Math.max(240, WitherStormModConfig.SERVER.lowImmuneRequiredProximitySeconds.get() * 20);
            this.applicationDelay = Math.max(240, WitherStormModConfig.SERVER.lowImmuneApplicationDelay.get() * 20);
            this.cureDelay = Math.max(240, WitherStormModConfig.SERVER.lowImmuneCureDelay.get() * 20);
            this.proximityTicksModifier = -((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.lowImmuneProximityModifierMax.get() * 20));
            this.applicationDelayModifier = -((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.lowImmuneApplicationModifierMax.get() * 20));
            this.cureDelayModifier = -((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.lowImmuneCureDelayModifierMax.get() * 20));
        } else {
            this.proximityTicksModifier = ((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.proximitySecondsModifierMax.get() * 20));
            this.applicationDelayModifier = ((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.applicationDelayModifierMax.get() * 20));
            this.cureDelayModifier = ((LivingEntity)this.entity).m_217043_().m_188503_(Math.max(240, WitherStormModConfig.SERVER.cureDelayModifierMax.get() * 20));
        }
    }

    public WitherSicknessTracker() {
        this.requiredProximityTicks = Math.max(240, WitherStormModConfig.SERVER.requiredProximitySeconds.get() * 20);
        this.applicationDelay = Math.max(240, WitherStormModConfig.SERVER.applicationDelay.get() * 20);
        this.cureDelay = Math.max(240, WitherStormModConfig.SERVER.cureDelay.get() * 20);
        this.requiredContacts = Math.max(1, WitherStormModConfig.SERVER.requiredContacts.get());
        this.multiplierDecreaseTime = 7200;
        this.contactsDecreaseTime = 9600;
        this.isActuallyImmune = true;
    }

    @Override
    public void copyFrom(WitherSicknessTracker tracker) {
        this.requiredProximityTicks = tracker.requiredProximityTicks;
        this.applicationDelay = tracker.applicationDelay;
        this.requiredContacts = tracker.requiredContacts;
        this.multiplierDecreaseTime = tracker.multiplierDecreaseTime;
        this.contactsDecreaseTime = tracker.contactsDecreaseTime;
        this.proximityTicksModifier = tracker.proximityTicksModifier;
        this.applicationDelayModifier = tracker.applicationDelayModifier;
        this.proximityTicks = tracker.proximityTicks;
        this.prevProximityTicks = tracker.prevProximityTicks;
        this.delayTicks = tracker.delayTicks;
        this.prevDelayTicks = tracker.prevDelayTicks;
        this.contacts = tracker.contacts;
        this.totalInfections = tracker.totalInfections;
        this.amplifierDecreaseTicks = tracker.amplifierDecreaseTicks;
        this.amplifier = tracker.amplifier;
        this.contactsDecreaseTicks = tracker.contactsDecreaseTicks;
        this.isInfected = tracker.isInfected;
        this.isNearStorm = tracker.isNearStorm;
        this.shouldUpdate = tracker.shouldUpdate;
        this.cureDelay = tracker.cureDelay;
        this.cureDelayModifier = tracker.cureDelayModifier;
        this.cureDelayTicks = tracker.cureDelayTicks;
        this.isBeingCured = tracker.isBeingCured;
        this.prevCureDelayTicks = tracker.prevCureDelayTicks;
        this.totalCures = tracker.totalCures;
        this.isActuallyImmune = tracker.isActuallyImmune;
    }

    public void copyFromMessage(UpdateWitherSicknessTrackerMessage message) {
        this.requiredProximityTicks = message.getRequiredProximityTicks();
        this.applicationDelay = message.getApplicationDelay();
        this.cureDelay = message.getCureDelay();
        this.proximityTicksModifier = message.getProximityTicksModifier();
        this.applicationDelayModifier = message.getApplicationDelayModifier();
        this.proximityTicks = message.getProximityTicks();
        this.delayTicks = message.getDelayTicks();
        this.contacts = message.getContacts();
        this.totalInfections = message.getTotalInfections();
        this.amplifierDecreaseTicks = message.getMultiplierDecreaseTicks();
        this.amplifier = message.getMultiplier();
        this.contactsDecreaseTicks = message.getContactsDecreaseTicks();
        this.isInfected = message.isInfected();
        this.isNearStorm = message.isNearStorm();
        this.cureDelayModifier = message.getCureDelayModifier();
        this.cureDelayTicks = message.getCureDelayTicks();
        this.isBeingCured = message.isBeingCured();
        this.totalCures = message.getTotalCures();
        this.isActuallyImmune = message.isActuallyImmune();
    }

    @Override
    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("ProximityTicks", this.getProximityTicks());
        compound.m_128405_("DelayTicks", this.getDelayTicks());
        compound.m_128405_("Contacts", this.getContacts());
        compound.m_128405_("MultiplierDecreaseTicks", this.getAmplifierDecreaseTicks());
        compound.m_128405_("Multiplier", this.getBaseMultiplier());
        compound.m_128405_("TotalInfections", this.getTotalInfections());
        compound.m_128379_("IsInfected", this.isInfected());
        compound.m_128405_("ProximityTicksModifier", this.getRequiredProximityTicksModifier());
        compound.m_128405_("ApplicationDelayModifier", this.getApplicationDelayModifier());
        compound.m_128405_("CureDelayModifier", this.getCureDelayModifier());
        compound.m_128405_("ContactsDecreaseTicks", this.getContactsDecreaseTicks());
        compound.m_128405_("CureDelayTicks", this.getCureDelayTicks());
        compound.m_128379_("IsBeingCured", this.isBeingCured());
        compound.m_128405_("TotalCures", this.getTotalCures());
        return compound;
    }

    @Override
    public void read(CompoundTag compound) {
        this.proximityTicks = compound.m_128451_("ProximityTicks");
        this.delayTicks = compound.m_128451_("DelayTicks");
        this.contacts = compound.m_128451_("Contacts");
        this.amplifierDecreaseTicks = compound.m_128451_("AmplifierDecreaseTicks");
        this.amplifier = compound.m_128451_("Amplifier");
        this.totalInfections = compound.m_128451_("TotalInfections");
        this.isInfected = compound.m_128471_("IsInfected");
        this.proximityTicksModifier = compound.m_128451_("ProximityTicksModifier");
        this.applicationDelayModifier = compound.m_128451_("ApplicationDelayModifier");
        this.cureDelayModifier = compound.m_128451_("CureDelayModifier");
        this.contactsDecreaseTicks = compound.m_128451_("ContactsDecreaseTicks");
        this.cureDelayTicks = compound.m_128451_("CureDelayTicks");
        this.isBeingCured = compound.m_128471_("IsBeingCured");
        this.totalCures = compound.m_128451_("TotalCures");
    }

    @Override
    public void tick() {
        if (!((LivingEntity)this.entity).f_19853_.f_46443_) {
            boolean flag = ((LivingEntity)this.entity).m_6095_().m_204039_(WitherStormModEntityTags.WITHER_SICKNESS_IMMUNE);
            if (this.isActuallyImmune != flag) {
                this.shouldUpdate = true;
                this.isActuallyImmune = flag;
            }
            if (((LivingEntity)this.entity).f_19797_ % 120 == 0) {
                this.shouldUpdate = true;
            }
            if (this.shouldUpdate) {
                UpdateWitherSicknessTrackerMessage message = new UpdateWitherSicknessTrackerMessage(this.entity);
                WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)message);
                this.shouldUpdate = false;
            }
        }
        if (!this.isActuallyImmune()) {
            this.prevProximityTicks = this.proximityTicks;
            this.prevDelayTicks = this.delayTicks;
            this.prevCureDelayTicks = this.cureDelayTicks;
            if (this.isNearStorm()) {
                if (this.proximityTicks < this.getRequiredProximityTicks()) {
                    ++this.proximityTicks;
                }
            } else {
                if (this.proximityTicks > 0) {
                    --this.proximityTicks;
                }
                if (this.amplifierDecreaseTicks < this.getAmplifierDecreaseTime() && !this.isInfected) {
                    ++this.amplifierDecreaseTicks;
                } else {
                    this.amplifierDecreaseTicks = 0;
                    if (this.amplifier > 0) {
                        --this.amplifier;
                    }
                }
                if (this.contactsDecreaseTicks < this.getContactsDecreaseTime()) {
                    ++this.contactsDecreaseTicks;
                } else {
                    this.contactsDecreaseTicks = 0;
                    if (this.contacts > 0) {
                        --this.contacts;
                    }
                }
            }
            if (this.prevProximityTicks != this.proximityTicks && this.proximityTicks >= this.getRequiredProximityTicks()) {
                this.beginInfection();
            }
            if (this.isInfected()) {
                if (this.delayTicks < this.getApplicationDelay() && !this.isBeingCured()) {
                    ++this.delayTicks;
                }
                if (this.delayTicks >= this.getApplicationDelay()) {
                    MobEffectInstance effect;
                    if (this.delayTicks != this.prevDelayTicks) {
                        this.infect();
                    }
                    if (!((LivingEntity)this.entity).f_19853_.f_46443_ && (effect = ((LivingEntity)this.entity).m_21124_((MobEffect)WitherStormModEffects.WITHER_SICKNESS.get())) != null && effect.m_19557_() < 7200) {
                        MobEffectInstance newEffect = new MobEffectInstance((MobEffect)WitherStormModEffects.WITHER_SICKNESS.get(), 12000, effect.m_19564_(), false, false, true);
                        effect.m_19558_(newEffect);
                        UpdateEffectInstanceMessage message = new UpdateEffectInstanceMessage(((LivingEntity)this.entity).m_19879_(), newEffect, true);
                        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)message);
                    }
                }
                if (!((LivingEntity)this.entity).f_19853_.f_46443_ && !((LivingEntity)this.entity).m_21023_((MobEffect)WitherStormModEffects.WITHER_SICKNESS.get()) && this.delayTicks >= this.getApplicationDelay()) {
                    this.setInfected(false);
                    this.setProximityTicks(0);
                }
                if (this.isBeingCured()) {
                    if (this.cureDelayTicks < this.getCureDelay()) {
                        ++this.cureDelayTicks;
                    }
                    if (this.cureDelayTicks >= this.getCureDelay() && this.cureDelayTicks != this.prevCureDelayTicks) {
                        this.cure();
                    }
                } else if (this.cureDelayTicks >= this.getCureDelay()) {
                    this.cureDelayTicks = 0;
                }
            } else {
                this.delayTicks = 0;
            }
        }
    }

    public int getRequiredProximityTicks() {
        return Math.max(1200, this.requiredProximityTicks + this.proximityTicksModifier);
    }

    public int getRequiredContacts() {
        return this.requiredContacts;
    }

    public int getApplicationDelay() {
        return Math.max(1200, this.applicationDelay + this.applicationDelayModifier);
    }

    public int getProximityTicks() {
        return this.proximityTicks;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public int getContacts() {
        return this.contacts;
    }

    public int getTotalInfections() {
        return this.totalInfections;
    }

    public void beginInfection() {
        if (!this.isActuallyImmune()) {
            this.shouldUpdate = true;
            this.isInfected = true;
            this.isBeingCured = false;
        }
    }

    public void setInfected(boolean infected) {
        if (!this.isActuallyImmune()) {
            if (infected != this.isInfected) {
                this.shouldUpdate = true;
            }
            this.isInfected = infected;
            if (infected) {
                this.isBeingCured = false;
            }
        }
    }

    public void infect() {
        if (!this.isBeingCured() && !this.isActuallyImmune()) {
            this.shouldUpdate = true;
            ++this.totalInfections;
            MobEffectInstance effect = new MobEffectInstance((MobEffect)WitherStormModEffects.WITHER_SICKNESS.get(), 12000, this.getAmplifier(), false, false, true);
            ((LivingEntity)this.entity).m_7292_(effect);
            if (WitherStormModConfig.SERVER.increaseAmplifier.get().booleanValue()) {
                ++this.amplifier;
            }
        }
    }

    public int getAmplifierDecreaseTime() {
        return this.multiplierDecreaseTime;
    }

    public int getAmplifierDecreaseTicks() {
        return this.amplifierDecreaseTicks;
    }

    public int getAmplifier() {
        return this.isConvertable() ? this.amplifier + 5 : this.amplifier;
    }

    public int getBaseMultiplier() {
        return this.amplifier;
    }

    public boolean isInfected() {
        return this.isInfected;
    }

    public void setProximityTicks(int amount) {
        if (!this.isActuallyImmune()) {
            if (amount != this.proximityTicks) {
                this.shouldUpdate = true;
            }
            this.proximityTicks = amount;
        }
    }

    public void setDelayTicks(int amount) {
        if (!this.isActuallyImmune()) {
            if (amount != this.delayTicks) {
                this.shouldUpdate = true;
            }
            this.delayTicks = amount;
        }
    }

    public int getRequiredProximityTicksModifier() {
        return this.proximityTicksModifier;
    }

    public int getApplicationDelayModifier() {
        return this.applicationDelayModifier;
    }

    public int getContactsDecreaseTime() {
        return this.contactsDecreaseTime;
    }

    public int getContactsDecreaseTicks() {
        return this.contactsDecreaseTicks;
    }

    public void countContact() {
        if (!this.isActuallyImmune()) {
            this.shouldUpdate = true;
            ++this.contacts;
            if (this.contacts > this.requiredContacts) {
                this.beginInfection();
            }
        }
    }

    public void setContacts(int amount) {
        if (!this.isActuallyImmune()) {
            if (amount != this.contacts) {
                this.shouldUpdate = true;
            }
            this.contacts = amount;
        }
    }

    public void setContactDecreaseTicks(int amount) {
        if (!this.isActuallyImmune()) {
            if (amount != this.contactsDecreaseTicks) {
                this.shouldUpdate = true;
            }
            this.contactsDecreaseTicks = amount;
        }
    }

    public boolean isNearStorm() {
        return this.isNearStorm;
    }

    public void setNearStorm(boolean near) {
        if (!this.isActuallyImmune()) {
            if (near != this.isNearStorm) {
                this.shouldUpdate = true;
            }
            this.isNearStorm = near;
        }
    }

    public int getCureDelay() {
        return Math.max(1200, this.cureDelay + this.cureDelayModifier);
    }

    public int getCureDelayModifier() {
        return this.cureDelayModifier;
    }

    public int getCureDelayTicks() {
        return this.cureDelayTicks;
    }

    public boolean isBeingCured() {
        return this.isBeingCured;
    }

    public void cure() {
        if (this.isInfected() && !this.isActuallyImmune()) {
            this.shouldUpdate = true;
            ((LivingEntity)this.entity).m_21195_((MobEffect)WitherStormModEffects.WITHER_SICKNESS.get());
            this.setInfected(false);
            this.setProximityTicks(0);
            this.setCureTicks(0);
            this.countCure();
            this.setBeingCured(false);
        }
    }

    public void beginCure() {
        if (!this.isActuallyImmune()) {
            this.shouldUpdate = true;
            this.isBeingCured = true;
        }
    }

    public int getTotalCures() {
        return this.totalCures;
    }

    public void countCure() {
        if (!this.isActuallyImmune()) {
            this.shouldUpdate = true;
            ++this.totalCures;
        }
    }

    public void setBeingCured(boolean cured) {
        if (!this.isActuallyImmune()) {
            if (cured != this.isBeingCured) {
                this.shouldUpdate = true;
            }
            this.isBeingCured = cured;
        }
    }

    public void setCureTicks(int amount) {
        if (!this.isActuallyImmune()) {
            if (amount != this.cureDelayTicks) {
                this.shouldUpdate = true;
            }
            this.cureDelayTicks = amount;
        }
    }

    public boolean isLowImmunity() {
        return !((LivingEntity)this.entity).m_6095_().m_204039_(WitherStormModEntityTags.HIGH_IMMUNITY);
    }

    public boolean isConvertable() {
        return AbstractSickenedEntity.getConversion(((LivingEntity)this.entity).m_6095_()) != null;
    }

    public boolean isActuallyImmune() {
        return this.isActuallyImmune;
    }

    public int getRawRequiredProximityTicks() {
        return this.requiredProximityTicks;
    }

    public int getRawApplicationDelay() {
        return this.applicationDelay;
    }

    public int getRawCureDelay() {
        return this.cureDelay;
    }
}

