/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import nonamecrackers2.witherstormmod.mixin.IMixinBlockModelRenderer;
import org.lwjgl.system.MemoryStack;

public class BlockRenderingUtil {
    public static boolean renderModelNoOcclusion(BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack stack, VertexConsumer builder, float r, float g, float b, float a, boolean checkSides, RandomSource RandomSource2, long seed, int overlayTexture, ModelData data, RenderType type) {
        Vec3 vector3d = state.m_60824_((BlockGetter)world, pos);
        stack.m_85837_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        data = model.getModelData(world, pos, state, data);
        try {
            return BlockRenderingUtil.renderModelFlat(world, model, state, pos, stack, builder, r, g, b, a, checkSides, RandomSource2, seed, overlayTexture, data, type);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block model with rgba");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block model being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)world, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
    }

    public static boolean renderModelFlat(BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack stack, VertexConsumer builder, float r, float g, float b, float a, boolean checkSides, RandomSource RandomSource2, long seed, int overlayTexture, ModelData data, RenderType type) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            RandomSource2.m_188584_(seed);
            List list = model.getQuads(state, direction, RandomSource2, data, type);
            if (list.isEmpty()) continue;
            mutable.m_122159_((Vec3i)pos, direction);
            if (checkSides && !Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)direction, (BlockPos)mutable)) continue;
            int i = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)mutable);
            BlockRenderingUtil.renderModelFaceFlat(world, state, pos, i, overlayTexture, false, stack, builder, r, g, b, a, list, bitset);
            flag = true;
        }
        RandomSource2.m_188584_(seed);
        List list1 = model.getQuads(state, (Direction)null, RandomSource2, data, type);
        if (!list1.isEmpty()) {
            BlockRenderingUtil.renderModelFaceFlat(world, state, pos, -1, overlayTexture, true, stack, builder, r, g, b, a, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private static void renderModelFaceFlat(BlockAndTintGetter p_228798_1_, BlockState p_228798_2_, BlockPos p_228798_3_, int p_228798_4_, int p_228798_5_, boolean p_228798_6_, PoseStack p_228798_7_, VertexConsumer p_228798_8_, float r, float g, float b, float a, List<BakedQuad> p_228798_9_, BitSet p_228798_10_) {
        Minecraft mc = Minecraft.m_91087_();
        IMixinBlockModelRenderer renderer = (IMixinBlockModelRenderer)mc.m_91289_().m_110937_();
        for (BakedQuad bakedquad : p_228798_9_) {
            if (p_228798_6_) {
                renderer.callCalculateShape(p_228798_1_, p_228798_2_, p_228798_3_, bakedquad.m_111303_(), bakedquad.m_111306_(), null, p_228798_10_);
                BlockPos blockpos = p_228798_10_.get(0) ? p_228798_3_.m_121945_(bakedquad.m_111306_()) : p_228798_3_;
                p_228798_4_ = LevelRenderer.m_109537_((BlockAndTintGetter)p_228798_1_, (BlockState)p_228798_2_, (BlockPos)blockpos);
            }
            float f = p_228798_1_.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            BlockRenderingUtil.putQuadData(mc.m_91298_(), p_228798_1_, p_228798_2_, p_228798_3_, p_228798_8_, p_228798_7_.m_85850_(), bakedquad, f * r, f * g, f * b, a, p_228798_4_, p_228798_4_, p_228798_4_, p_228798_4_, p_228798_5_);
        }
    }

    private static void putQuadData(BlockColors colors, BlockAndTintGetter p_228800_1_, BlockState p_228800_2_, BlockPos p_228800_3_, VertexConsumer p_228800_4_, PoseStack.Pose p_228800_5_, BakedQuad p_228800_6_, float r, float g, float b, float a, int p_228800_11_, int p_228800_12_, int p_228800_13_, int p_228800_14_, int p_228800_15_) {
        float f2;
        float f1;
        float f;
        if (p_228800_6_.m_111304_()) {
            int i = colors.m_92577_(p_228800_2_, p_228800_1_, p_228800_3_, p_228800_6_.m_111305_());
            f = (float)(i >> 16 & 0xFF) / 255.0f * r;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f * g;
            f2 = (float)(i & 0xFF) / 255.0f * b;
        } else {
            f = r;
            f1 = g;
            f2 = b;
        }
        BlockRenderingUtil.putBulkDataWithAlpha(p_228800_4_, p_228800_5_, p_228800_6_, f, f1, f2, a, new int[]{p_228800_11_, p_228800_12_, p_228800_13_, p_228800_14_}, p_228800_15_);
    }

    private static void putBulkDataWithAlpha(VertexConsumer builder, PoseStack.Pose entry, BakedQuad quad, float r, float g, float b, float a, int[] p, int overlayTexture) {
        int[] aint = quad.m_111303_();
        Vec3i vector3i = quad.m_111306_().m_122436_();
        Vector3f vector3f = new Vector3f((float)vector3i.m_123341_(), (float)vector3i.m_123342_(), (float)vector3i.m_123343_());
        Matrix4f matrix4f = entry.m_85861_();
        vector3f.m_122249_(entry.m_85864_());
        int j = aint.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, k * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                float f3 = r;
                float f4 = g;
                float f5 = b;
                float f6 = a;
                int l = builder.applyBakedLighting(p[k], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                vector4f.m_123607_(matrix4f);
                builder.applyBakedNormals(vector3f, bytebuffer, entry.m_85864_());
                builder.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), f3, f4, f5, f6, f9, f10, overlayTexture, l, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            }
        }
    }
}

