/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import nonamecrackers2.witherstormmod.client.init.WitherStormModRenderers;
import nonamecrackers2.witherstormmod.client.renderer.entity.AbstractWitherStormRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormEnergyLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.AbstractWitherStormModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormCommandBlockModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDestroyerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDevourerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDismantledModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormEvolvedDestroyerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormEvolvedDevourerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormGrowingHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormPregnantHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormTornEvolvedDevourerModel;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;

public class WitherStormRenderer
extends AbstractWitherStormRenderer<WitherStormEntity, AbstractWitherStormModel<WitherStormEntity>> {
    private final WitherStormCommandBlockModel<WitherStormEntity> commandBlockModel;
    private final WitherStormHunchbackModel<WitherStormEntity> hunchbackModel;
    private final WitherStormGrowingHunchbackModel<WitherStormEntity> growingHunchbackModel;
    private final WitherStormPregnantHunchbackModel<WitherStormEntity> pregnantHunchbackModel;
    private final WitherStormDestroyerModel<WitherStormEntity> destroyerModel;
    private final WitherStormEvolvedDestroyerModel<WitherStormEntity> evolvedDestroyerModel;
    private final WitherStormDevourerModel<WitherStormEntity> devourerModel;
    private final WitherStormEvolvedDevourerModel<WitherStormEntity> evolvedDevourerModel;
    private final WitherStormDismantledModel<WitherStormEntity> dismantledModel;
    private final WitherStormTornEvolvedDevourerModel<WitherStormEntity> tornModel;

    public WitherStormRenderer(EntityRendererProvider.Context context) {
        this(context, new WitherStormCommandBlockModel<WitherStormEntity>(context.m_174023_(WitherStormModRenderers.WITHER_STORM_0)));
    }

    private WitherStormRenderer(EntityRendererProvider.Context context, WitherStormCommandBlockModel<WitherStormEntity> base) {
        super(context, base);
        this.m_115326_((RenderLayer)new WitherStormEnergyLayer((RenderLayerParent<WitherStormEntity, AbstractWitherStormModel<WitherStormEntity>>)this, context.m_174027_()));
        this.commandBlockModel = base;
        this.hunchbackModel = new WitherStormHunchbackModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_1));
        this.growingHunchbackModel = new WitherStormGrowingHunchbackModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_2));
        this.pregnantHunchbackModel = new WitherStormPregnantHunchbackModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_3));
        this.destroyerModel = new WitherStormDestroyerModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_4));
        this.evolvedDestroyerModel = new WitherStormEvolvedDestroyerModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_5));
        this.devourerModel = new WitherStormDevourerModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_6));
        this.evolvedDevourerModel = new WitherStormEvolvedDevourerModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_7));
        this.dismantledModel = new WitherStormDismantledModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_DISMANTLED));
        this.tornModel = new WitherStormTornEvolvedDevourerModel(context.m_174023_(WitherStormModRenderers.WITHER_STORM_TORN));
    }

    @Override
    public void render(WitherStormEntity entity, float p_225623_2_, float partialTicks, PoseStack stack, MultiBufferSource buffer, int p_225623_6_) {
        super.render(entity, p_225623_2_, partialTicks, stack, buffer, p_225623_6_);
        if (entity.getDeathTime() > 0) {
            float f1 = ((float)entity.getDeathTime() + partialTicks) / 200.0f;
            float f2 = Math.min(f1 > 1.6f ? (f1 - 1.6f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(382L);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_85837_(0.0, (double)entity.getUnmodifiedHeight() / 2.0, 0.0);
            int i = 0;
            while ((float)i < (f1 + f1 * f1) / 2.0f * 60.0f) {
                stack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + f1 * 90.0f));
                float f3 = random.nextFloat() * (entity.getUnmodifiedSize() / 1.5f) * 2.5f + 5.0f + f2 * 10.0f;
                float f4 = random.nextFloat() * 10.0f + 1.0f + f2 * 2.0f;
                Matrix4f matrix4f = stack.m_85850_().m_85861_();
                int k = (int)(255.0f * (1.0f - f2));
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, -((float)(Math.sqrt(3.0) / 2.0)) * f4, f3, -0.5f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                builder.m_85982_(matrix4f, (float)(Math.sqrt(3.0) / 2.0) * f4, f3, -0.5f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, (float)(Math.sqrt(3.0) / 2.0) * f4, f3, -0.5f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, f3, 1.0f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, k).m_5752_();
                builder.m_85982_(matrix4f, 0.0f, f3, 1.0f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                builder.m_85982_(matrix4f, -((float)(Math.sqrt(3.0) / 2.0)) * f4, f3, -0.5f * f4).m_6122_(255, 0, 255, 0).m_5752_();
                ++i;
            }
            stack.m_85849_();
        }
    }

    @Override
    public AbstractWitherStormModel<WitherStormEntity> getModel(WitherStormEntity entity) {
        int phase = entity.getPhase();
        if (phase == 1) {
            return this.hunchbackModel;
        }
        if (phase == 2) {
            return this.growingHunchbackModel;
        }
        if (phase == 3) {
            return this.pregnantHunchbackModel;
        }
        if (phase == 4) {
            return this.destroyerModel;
        }
        if (phase == 5) {
            if (entity.getConsumptionAmountForPhase(phase) >= entity.getConsumedEntities()) {
                return this.evolvedDestroyerModel;
            }
            return this.devourerModel;
        }
        if (phase == 6) {
            if (entity.getConsumedEntities() <= entity.getSubPhaseRequirement(phase)) {
                return this.dismantledModel;
            }
            return this.devourerModel;
        }
        if (phase == 7) {
            if (!entity.isBeingTornApart()) {
                return this.evolvedDevourerModel;
            }
            return this.tornModel;
        }
        return this.commandBlockModel;
    }
}

