/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.client.flywheel.FlywheelCompatHandler;
import nonamecrackers2.witherstormmod.client.util.BlockRenderingUtil;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.BlockClusterEntity;

public class BlockClusterRenderer
extends EntityRenderer<BlockClusterEntity> {
    public BlockClusterRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(BlockClusterEntity entity, float p_225623_2_, float partialTicks, PoseStack stack, MultiBufferSource buffer, int p_225623_6_) {
        stack.m_85836_();
        stack.m_85837_(0.0, 0.5, 0.0);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        stack.m_85837_(0.0, -0.5, 0.0);
        double xOffset = -0.5 + (Math.round(entity.m_20191_().m_82362_()) % 2L == 0L ? -0.5 : 0.0);
        double yOffset = -0.5 + (Math.round(entity.m_20191_().m_82376_()) % 2L == 0L ? -0.5 : 0.0);
        double zOffset = -0.5 + (Math.round(entity.m_20191_().m_82385_()) % 2L == 0L ? -0.5 : 0.0);
        stack.m_85837_(xOffset, yOffset, zOffset);
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = minecraft.m_91289_();
        Level world = entity.f_19853_;
        BlockAndTintGetter getter = entity.getBlockGetter();
        ImmutableMap renderTypes = Maps.toMap((Iterable)RenderType.m_110506_(), arg_0 -> ((MultiBufferSource)buffer).m_6299_(arg_0));
        float fade = entity.lerpFadeAmount(partialTicks);
        float scale = Math.max(0.8f, fade * 0.5f + 0.5f);
        stack.m_85841_(scale, scale, scale);
        float x = Mth.m_14179_((float)partialTicks, (float)entity.shakeO.f_82470_, (float)entity.shake.f_82470_);
        float z = Mth.m_14179_((float)partialTicks, (float)entity.shakeO.f_82471_, (float)entity.shake.f_82471_);
        stack.m_85837_((double)x, 0.0, (double)z);
        for (Map.Entry<BlockPos, BlockState> entry : entity.toRender().entrySet()) {
            BlockState state = entry.getValue();
            BlockPos relativePos = entry.getKey();
            BlockPos pos = new BlockPos(entity.m_20185_() + (double)relativePos.m_123341_(), entity.m_20186_() + (double)relativePos.m_123342_() + entity.m_20191_().m_82376_() / 2.0 - 0.5, entity.m_20189_() + (double)relativePos.m_123343_());
            if (!WitherStormMod.getIf(WitherStormMod.flywheelLoaded(), (Supplier<Supplier<Boolean>>)((Supplier)() -> () -> FlywheelCompatHandler.isOverridingCluster(entity))) && state.m_60799_() == RenderShape.MODEL) {
                if (state == world.m_8055_(entity.m_20183_()) || state.m_60799_() == RenderShape.INVISIBLE) continue;
                stack.m_85836_();
                stack.m_85837_((double)relativePos.m_123341_(), (double)relativePos.m_123342_() + entity.m_20191_().m_82376_() / 2.0, (double)relativePos.m_123343_());
                for (Map.Entry renderTypeEntry : renderTypes.entrySet()) {
                    RenderType type = (RenderType)renderTypeEntry.getKey();
                    VertexConsumer builder = (VertexConsumer)renderTypeEntry.getValue();
                    BakedModel model = minecraft.m_91289_().m_110910_(state);
                    ChunkRenderTypeSet blockRenderTypes = model.getRenderTypes(state, RandomSource.m_216335_((long)state.m_60726_(entity.getStartPos())), ModelData.EMPTY);
                    if (!blockRenderTypes.contains(type)) continue;
                    float r = Math.min(1.0f, fade + 0.1f);
                    float g = fade;
                    float b = Math.min(1.0f, fade + 0.2f);
                    if (WitherStormModConfig.CLIENT.blockClusterColouring.get().booleanValue()) {
                        BlockRenderingUtil.renderModelNoOcclusion(getter, dispatcher.m_110910_(state), state, pos, stack, builder, r, g, b, 1.0f, false, RandomSource.m_216335_((long)relativePos.m_121878_()), state.m_60726_(entity.getStartPos()), OverlayTexture.f_118083_, ModelData.EMPTY, type);
                        continue;
                    }
                    dispatcher.renderBatched(state, pos, getter, stack, builder, false, RandomSource.m_216335_((long)relativePos.m_121878_()), ModelData.EMPTY, type);
                }
                stack.m_85849_();
                continue;
            }
            if (state.m_60799_() != RenderShape.ENTITYBLOCK_ANIMATED || state == world.m_8055_(entity.m_20183_()) || state.m_60799_() == RenderShape.INVISIBLE) continue;
            stack.m_85836_();
            stack.m_85837_((double)relativePos.m_123341_(), (double)relativePos.m_123342_() + entity.m_20191_().m_82376_() / 2.0, (double)relativePos.m_123343_());
            CompoundTag data = entity.getTileDataFromOffsetPos(relativePos);
            if (data != null) {
                String id = data.m_128461_("id");
                BlockEntity tile = ((BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(new ResourceLocation(id))).m_155264_(pos, state);
                BlockEntityRenderer tileRenderer = minecraft.m_167982_().m_112265_(tile);
                tile.m_142339_(world);
                tile.m_142466_(data);
                if (tileRenderer != null) {
                    tileRenderer.m_6922_(tile, partialTicks, stack, buffer, LevelRenderer.m_109541_((BlockAndTintGetter)getter, (BlockPos)pos), OverlayTexture.f_118083_);
                }
            }
            stack.m_85849_();
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, p_225623_2_, partialTicks, stack, buffer, p_225623_6_);
    }

    public boolean shouldRender(BlockClusterEntity entity, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (WitherStormModConfig.CLIENT.blockClusterRendering.get().booleanValue() || entity.forceRender()) {
            return super.m_5523_((Entity)entity, p_225626_2_, p_225626_3_, p_225626_5_, p_225626_7_);
        }
        return false;
    }

    public ResourceLocation getTextureLocation(BlockClusterEntity entity) {
        return null;
    }
}

