/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormEmissiveDecalLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormExplodingLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormPulseLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.AbstractWitherStormModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.HeadModel;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.util.DebrisChunks;
import nonamecrackers2.witherstormmod.common.util.DebrisRingSettings;

public abstract class AbstractWitherStormRenderer<T extends WitherStormEntity, M extends AbstractWitherStormModel<T>>
extends LivingEntityRenderer<T, M> {
    public static final ResourceLocation WITHER_STORM_INVULNERABLE_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_invulnerable.png");
    public static final ResourceLocation WITHER_STORM_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm.png");
    public static final ResourceLocation WITHER_STORM_EXPLODING_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_exploding.png");
    public static final ResourceLocation EMISSIVE_DECAL = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_emissive_decal.png");
    public static final ResourceLocation EMISSIVE_DECAL_HURT = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_emissive_decal_hurt.png");
    public static final ResourceLocation PULSE = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_pulse.png");
    public static final ResourceLocation DEBRIS_RING = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/debris.png");
    public static final LocalDate DATE = LocalDate.now();

    public AbstractWitherStormRenderer(EntityRendererProvider.Context context, M model) {
        super(context, model, 1.0f);
        this.m_115326_(new WitherStormExplodingLayer(this));
        this.m_115326_(new WitherStormEmissiveDecalLayer(this));
        this.m_115326_(new WitherStormPulseLayer(this));
    }

    public void updateModel(T entity) {
        this.f_115290_ = this.getModel(entity);
        ((AbstractWitherStormModel)this.f_115290_).setMirrored(((WitherStormEntity)entity).isMirrored());
    }

    public abstract M getModel(T var1);

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return Math.max(0, (int)((100.0f - ((WitherStormEntity)entity).getFadeAnimation()) / 4.0f - 10.0f));
    }

    public void render(T entity, float p_225623_2_, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        this.updateModel(entity);
        ((AbstractWitherStormModel)this.f_115290_).buffer = buffer;
        ((AbstractWitherStormModel)this.f_115290_).shouldRenderAdditional = !entity.m_21224_();
        ((AbstractWitherStormModel)this.f_115290_).entity = entity;
        ((AbstractWitherStormModel)this.f_115290_).otherHeadsDisabled = ((WitherStormEntity)entity).areOtherHeadsDisabled();
        if (WitherStormModConfig.CLIENT.renderDebrisCloud.get().booleanValue() && (!WitherStormModConfig.CLIENT.renderDistantDebris.get().booleanValue() && !((WitherStormEntity)entity).isOnDistantRenderer() || WitherStormModConfig.CLIENT.renderDistantDebris.get().booleanValue())) {
            this.renderDebris(entity, stack, buffer, partialTicks, packedLight);
        }
        super.m_7392_(entity, p_225623_2_, partialTicks, stack, buffer, packedLight);
    }

    public void renderTractorBeams(T entity, PoseStack stack, MultiBufferSource buffer, float partialTicks, int packedLight) {
        if (!(!WitherStormModConfig.CLIENT.renderTractorBeams.get().booleanValue() || entity.m_20096_() && ((WitherStormEntity)entity).isPlayingDead())) {
            for (Int2ObjectMap.Entry entry : ((AbstractWitherStormModel)this.m_7200_()).heads.int2ObjectEntrySet()) {
                HeadModel head = (HeadModel)entry.getValue();
                stack.m_85836_();
                if (head.shouldRenderTractorBeam(entity, entry.getIntKey())) {
                    float b;
                    Minecraft mc = Minecraft.m_91087_();
                    Vec3 pos = mc.f_91063_.m_109153_().m_90583_();
                    double distance = pos.m_82554_(entity.m_20182_());
                    float renderDistance = (float)((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue() / 16.0f;
                    float alpha = Mth.m_14036_((float)((float)(distance - (double)(200.0f * renderDistance)) * 0.005f), (float)0.0f, (float)1.0f);
                    int month = DATE.get(ChronoField.MONTH_OF_YEAR);
                    int day = DATE.get(ChronoField.DAY_OF_MONTH);
                    boolean flag = month == 10 && day == 31;
                    float r = flag ? 0.5294118f : 0.5f;
                    float g = flag ? 0.32156864f : 0.3f;
                    float f = b = flag ? 0.10980392f : 0.8f;
                    if (WitherStormModConfig.CLIENT.distantFog.get().booleanValue()) {
                        float rDelta = 0.3f - r;
                        float gDelta = 0.3f - g;
                        float bDelta = 0.3f - b;
                        r += rDelta * alpha;
                        g += gDelta * alpha;
                        b += bDelta * alpha;
                    }
                    head.renderTractorBeam(entity, stack, buffer, packedLight, r, g, b, 0.5f, partialTicks);
                }
                stack.m_85849_();
            }
        }
    }

    public void prepareHeadAnimsForTractorBeams(T entity, float partialTicks) {
        if (!(!WitherStormModConfig.CLIENT.renderTractorBeams.get().booleanValue() || entity.m_20096_() && ((WitherStormEntity)entity).isPlayingDead())) {
            for (Int2ObjectMap.Entry entry : ((AbstractWitherStormModel)this.m_7200_()).heads.int2ObjectEntrySet()) {
                boolean shouldSit;
                HeadModel head = (HeadModel)entry.getValue();
                float f8 = 0.0f;
                float f5 = 0.0f;
                boolean bl = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
                if (!shouldSit && entity.m_6084_()) {
                    f8 = Mth.m_14179_((float)partialTicks, (float)((WitherStormEntity)entity).f_20923_, (float)((WitherStormEntity)entity).f_20924_);
                    f5 = ((WitherStormEntity)entity).f_20925_ - ((WitherStormEntity)entity).f_20924_ * (1.0f - partialTicks);
                }
                float f7 = this.m_6930_((LivingEntity)entity, partialTicks);
                float f = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).f_20884_, (float)((WitherStormEntity)entity).f_20883_);
                float f1 = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).f_20886_, (float)((WitherStormEntity)entity).f_20885_);
                float f2 = f1 - f;
                if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity.m_20202_();
                    f = Mth.m_14189_((float)partialTicks, (float)living.f_20884_, (float)living.f_20883_);
                    f2 = f1 - f;
                    float f3 = Mth.m_14177_((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f6 = Mth.m_14179_((float)partialTicks, (float)((WitherStormEntity)entity).f_19860_, (float)entity.m_146909_());
                head.prepareMobModel(entity, f5, f8, partialTicks, entry.getIntKey());
                head.setupAnim(entity, f5, f8, f7, f2, f6, entry.getIntKey());
            }
        }
    }

    public boolean shouldRender(T entity, Frustum clipping, double x, double y, double z) {
        if (!entity.m_6000_(x, y, z)) {
            return false;
        }
        if (!((WitherStormEntity)entity).isOnDistantRenderer() && ((WitherStormEntity)entity).f_19811_) {
            return true;
        }
        AABB box = ((WitherStormEntity)entity).m_6921_().m_82400_(0.5);
        if (box.m_82392_() || box.m_82309_() == 0.0) {
            box = new AABB(entity.m_20185_() - 2.0, entity.m_20186_() - 2.0, entity.m_20189_() - 2.0, entity.m_20185_() + 2.0, entity.m_20186_() + 2.0, entity.m_20189_() + 2.0);
        }
        return clipping.m_113029_(box);
    }

    protected boolean shouldShowName(T entity) {
        return super.m_6512_(entity) && (entity.m_6052_() || entity.m_8077_() && entity == this.f_114476_.f_114359_);
    }

    public void renderDebrisRings(T entity, PoseStack stack, MultiBufferSource buffer, float partialTicks, int packedLightIn) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 pos = mc.f_91063_.m_109153_().m_90583_();
        double distance = pos.m_82554_(entity.m_20182_());
        float baseAlpha = Mth.m_14036_((float)((float)(400.0 - distance) * 0.005f), (float)0.2f, (float)0.5f);
        VertexConsumer debrisBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)DEBRIS_RING));
        for (DebrisRingSettings settings : ((WitherStormEntity)entity).getDebrisRings()) {
            if (!(settings.alpha() > 0.0f) || ((WitherStormEntity)entity).getPhase() < settings.getPhaseRequirement()) continue;
            stack.m_85836_();
            int segments = settings.getSegments();
            float bottomRadius = settings.getBottomRadius();
            float topRadius = settings.getTopRadius();
            float y = settings.getY();
            float height = settings.getHeight();
            float alpha = settings.alpha() * baseAlpha;
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f matrix4f = entry.m_85861_();
            Matrix3f matrix3f = entry.m_85864_();
            float u = 0.0f;
            float v = 0.0f;
            float uMax = 1.0f;
            float vMax = 1.0f;
            float tickCount = ((float)((WitherStormEntity)entity).f_19797_ + partialTicks) * (settings.getSpeedModifier() * (settings.clockwise() ? 1.0f : -1.0f));
            for (int i = 0; i < segments; ++i) {
                float theta = (float)(Math.PI * 2 / (double)segments);
                float angle = theta * (float)i + tickCount;
                float x = Mth.m_14089_((float)angle);
                float z = Mth.m_14031_((float)angle);
                float angle2 = theta * (float)(i + 1) + tickCount;
                float x2 = Mth.m_14089_((float)angle2);
                float z2 = Mth.m_14031_((float)angle2);
                debrisBuilder.m_85982_(matrix4f, x * bottomRadius, y, z * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x * topRadius, height, z * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x2 * topRadius, height, z2 * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x2 * bottomRadius, y, z2 * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x2 * bottomRadius, y, z2 * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x2 * topRadius, height, z2 * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x * topRadius, height, z * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                debrisBuilder.m_85982_(matrix4f, x * bottomRadius, y, z * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            }
            stack.m_85849_();
        }
    }

    public void renderDebris(T entity, PoseStack stack, MultiBufferSource buffer, float partialTicks, int packedLightIn) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)WITHER_STORM_LOCATION));
        for (int i = 0; i < ((WitherStormEntity)entity).getChunks().size(); ++i) {
            boolean flag = ((WitherStormEntity)entity).getPhase() > 5 && WitherStormModConfig.CLIENT.lowerDebrisResWithPhase.get() != false || WitherStormModConfig.CLIENT.renderDebrisTwoDimensional.get() != false;
            DebrisChunks chunks = ((WitherStormEntity)entity).getChunks().get(i);
            if (((WitherStormEntity)entity).getPhase() < chunks.getRequiredPhase()) continue;
            this.renderDebrisFog(stack, builder, partialTicks, packedLightIn, chunks, flag);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        int i = ((WitherStormEntity)entity).getInvulnerableTicks();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_STORM_INVULNERABLE_LOCATION : WITHER_STORM_LOCATION;
    }

    public ResourceLocation getExplodingTextureLocation(T entity) {
        return WITHER_STORM_EXPLODING_LOCATION;
    }

    public ResourceLocation getPulseTextureLocation(T entity) {
        return PULSE;
    }

    public ResourceLocation getEmissiveDecalLocation(T entity) {
        return EMISSIVE_DECAL;
    }

    public ResourceLocation getHurtEmissiveDecalLocation(T entity) {
        return EMISSIVE_DECAL_HURT;
    }

    protected void scale(T entity, PoseStack stack, float p_225620_3_) {
        float f = 2.0f;
        int i = ((WitherStormEntity)entity).getInvulnerableTicks();
        int j = Math.max(0, i - 750);
        if (j > 0) {
            f -= ((float)j - p_225620_3_) / (float)Math.max(0, ((WitherStormEntity)entity).getStartingInvulnerableTicks() - 750) * 0.5f;
        }
        stack.m_85841_(f, f, f);
    }

    protected void setupRotations(T entity, PoseStack stack, float p_225621_3_, float yBodyRot, float partialTicks) {
        super.m_7523_(entity, stack, p_225621_3_, yBodyRot, partialTicks);
        Pose pose = entity.m_20089_();
        if (pose != Pose.SLEEPING) {
            float xBodyRot = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).xBodyRotO, (float)((WitherStormEntity)entity).xBodyRot);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(xBodyRot));
        }
    }

    protected void renderDebrisFog(PoseStack stack, VertexConsumer builder, float partialTicks, int packedLightIn, DebrisChunks chunks, boolean twoDimensionalRendering) {
        List<DebrisChunks.DebrisChunk> chunkList = chunks.getChunks();
        for (DebrisChunks.DebrisChunk chunk : chunkList) {
            if (chunk.disabled) continue;
            float orbitalAngleWithOffset = chunk.orbitalAngle + chunk.getOrbitOffset();
            float orbitalAngleWithOffsetO = chunk.orbitalAngleO + chunk.getOrbitOffset();
            float lerp = (float)Math.toRadians(Mth.m_14189_((float)partialTicks, (float)orbitalAngleWithOffsetO, (float)orbitalAngleWithOffset));
            float orbitalPositionX = Mth.m_14089_((float)lerp) * chunk.distanceFromCenter() * chunks.getRadius();
            float orbitalPositionZ = Mth.m_14031_((float)lerp) * chunk.distanceFromCenter() * chunks.getRadius();
            stack.m_85836_();
            stack.m_85837_((double)orbitalPositionX, (double)(chunk.verticalOffset() + chunks.getYOffset()), (double)orbitalPositionZ);
            if (!twoDimensionalRendering) {
                stack.m_85845_(Vector3f.f_122223_.m_122240_(-Mth.m_14189_((float)partialTicks, (float)chunk.xRotO, (float)chunk.xRot)));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(-Mth.m_14189_((float)partialTicks, (float)chunk.yRotO, (float)chunk.yRot)));
            } else {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(-this.f_114476_.f_114358_.m_90590_()));
                stack.m_85845_(Vector3f.f_122223_.m_122240_(this.f_114476_.f_114358_.m_90589_()));
            }
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f matrix4f = entry.m_85861_();
            Matrix3f matrix3f = entry.m_85864_();
            float u = 0.9f;
            float v = 0.8f;
            float uMax = 1.0f;
            float vMax = 0.9f;
            float startSize = chunk.getRadius();
            float endSize = -chunk.getRadius();
            builder.m_85982_(matrix4f, startSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, startSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, endSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, endSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            if (!twoDimensionalRendering) {
                builder.m_85982_(matrix4f, endSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, startSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, startSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, endSize, startSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, endSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix4f, startSize, endSize, endSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            }
            stack.m_85849_();
        }
    }

    public int getPulseAmount(T entity) {
        return (int)((float)((WitherStormEntity)entity).getPhase() * 15.0f / 2.0f * (WitherStormModConfig.CLIENT.lowResModels.get() != false ? 3.0f : 1.0f));
    }

    protected RenderType getRenderType(T entity, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (((WitherStormEntity)entity).getDeathTime() > 0) {
            return null;
        }
        return super.m_7225_(entity, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public static void renderExtra(WitherStormEntity storm, EntityRenderDispatcher manager, PoseStack stack, MultiBufferSource buffer, float partialTicks) {
        AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)manager.m_114382_((Entity)storm);
        renderer.updateModel(storm);
        int packedLight = manager.m_114394_((Entity)storm, partialTicks);
        if (WitherStormModConfig.CLIENT.renderDebrisRings.get().booleanValue()) {
            renderer.renderDebrisRings(storm, stack, buffer, partialTicks, packedLight);
        }
    }

    public static void renderTractorBeams(WitherStormEntity storm, EntityRenderDispatcher manager, PoseStack stack, MultiBufferSource buffer, float partialTicks) {
        AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)manager.m_114382_((Entity)storm);
        renderer.updateModel(storm);
        int packedLight = manager.m_114394_((Entity)storm, partialTicks);
        renderer.prepareHeadAnimsForTractorBeams(storm, partialTicks);
        renderer.renderTractorBeams(storm, stack, buffer, partialTicks, packedLight);
    }

    public static void orientAndScale(WitherStormEntity storm, PoseStack stack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)mc.m_91290_().m_114382_((Entity)storm);
        float bob = renderer.m_6930_((LivingEntity)storm, partialTicks);
        float yBodyRot = Mth.m_14189_((float)partialTicks, (float)storm.f_20884_, (float)storm.f_20883_);
        renderer.setupRotations(storm, stack, bob, yBodyRot, partialTicks);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        renderer.scale(storm, stack, partialTicks);
    }
}

