/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.client.renderer.entity.BlockClusterRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.CommandBlockRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.FlamingWitherSkullRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.FormidibombRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.SickenedCreeperRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.SickenedSkeletonRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.SickenedSpiderRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.SickenedZombieRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.SuperTNTRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.TentacleRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.WitherStormHeadRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.WitherStormRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.WitherStormSegmentRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.WitheredSymbiontRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherSicknessLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.FlamingWitherSkullModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.TentacleModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.WitherStormHeadModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.WitheredSymbiontModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.commandblock.RibcageModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormCommandBlockModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDestroyerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDevourerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormDismantledModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormEvolvedDestroyerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormEvolvedDevourerModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormGrowingHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormPregnantHunchbackModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormSegmentModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.WitherStormTornEvolvedDevourerModel;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;

public class WitherStormModRenderers {
    public static final ModelLayerLocation WITHER_STORM_0 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase0");
    public static final ModelLayerLocation WITHER_STORM_1 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase1");
    public static final ModelLayerLocation WITHER_STORM_2 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase2");
    public static final ModelLayerLocation WITHER_STORM_3 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase3");
    public static final ModelLayerLocation WITHER_STORM_4 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase4");
    public static final ModelLayerLocation WITHER_STORM_5 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase5");
    public static final ModelLayerLocation WITHER_STORM_6 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase6");
    public static final ModelLayerLocation WITHER_STORM_7 = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "phase7");
    public static final ModelLayerLocation WITHER_STORM_DISMANTLED = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "dismantled");
    public static final ModelLayerLocation WITHER_STORM_TORN = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "torn");
    public static final ModelLayerLocation WITHER_STORM_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm"), "armor");
    public static final ModelLayerLocation WITHER_STORM_SEGMENT = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm_segment"), "main");
    public static final ModelLayerLocation FLAMING_WITHER_SKULL = new ModelLayerLocation(new ResourceLocation("witherstormmod", "flaming_wither_skull"), "main");
    public static final ModelLayerLocation SICKENED_ZOMBIE = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_zombie"), "main");
    public static final ModelLayerLocation SICKENED_ZOMBIE_INNER_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_zombie"), "inner_armor");
    public static final ModelLayerLocation SICKENED_ZOMBIE_OUTER_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_zombie"), "outer_armor");
    public static final ModelLayerLocation SICKENED_SKELETON = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_skeleton"), "main");
    public static final ModelLayerLocation SICKENED_SKELETON_INNER_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_skeleton"), "inner_armor");
    public static final ModelLayerLocation SICKENED_SKELETON_OUTER_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_skeleton"), "outer_armor");
    public static final ModelLayerLocation SICKENED_SPIDER = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_spider"), "main");
    public static final ModelLayerLocation SICKENED_CREEPER = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_creeper"), "main");
    public static final ModelLayerLocation SICKENED_CREEPER_ARMOR = new ModelLayerLocation(new ResourceLocation("witherstormmod", "sickened_creeper"), "armor");
    public static final ModelLayerLocation WITHERED_SYMBIONT = new ModelLayerLocation(new ResourceLocation("witherstormmod", "withered_symbiont"), "main");
    public static final ModelLayerLocation WITHER_STORM_HEAD = new ModelLayerLocation(new ResourceLocation("witherstormmod", "wither_storm_head"), "main");
    public static final ModelLayerLocation TENTACLE = new ModelLayerLocation(new ResourceLocation("witherstormmod", "tentacle"), "main");
    public static final ModelLayerLocation RIBCAGE = new ModelLayerLocation(new ResourceLocation("witherstormmod", "ribcage"), "main");

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.WITHER_STORM.get(), m -> new WitherStormRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get(), m -> new BlockClusterRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.WITHER_STORM_SEGMENT.get(), m -> new WitherStormSegmentRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.FLAMING_WITHER_SKULL.get(), m -> new FlamingWitherSkullRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get(), m -> new SickenedZombieRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get(), m -> new SickenedSkeletonRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.SICKENED_SPIDER.get(), m -> new SickenedSpiderRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.SICKENED_CREEPER.get(), m -> new SickenedCreeperRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.SUPER_TNT.get(), m -> new SuperTNTRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.FORMIDIBOMB.get(), m -> new FormidibombRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.COMMAND_BLOCK.get(), m -> new CommandBlockRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.WITHERED_SYMBIONT.get(), m -> new WitheredSymbiontRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.WITHER_STORM_HEAD.get(), m -> new WitherStormHeadRenderer(m));
        event.registerEntityRenderer((EntityType)WitherStormModEntityTypes.TENTACLE.get(), m -> new TentacleRenderer(m));
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition humanoid = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f), (int)64, (int)64);
        LayerDefinition humanoid_inner = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171107_, (float)0.0f), (int)64, (int)32);
        LayerDefinition humanoid_outer = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171106_, (float)0.0f), (int)64, (int)32);
        event.registerLayerDefinition(WITHER_STORM_0, () -> WitherStormCommandBlockModel.createLayerDefinition(CubeDeformation.f_171458_));
        event.registerLayerDefinition(WITHER_STORM_1, () -> WitherStormHunchbackModel.createLayerDefinition(CubeDeformation.f_171458_));
        event.registerLayerDefinition(WITHER_STORM_2, () -> WitherStormGrowingHunchbackModel.createLayerDefinition(CubeDeformation.f_171458_));
        event.registerLayerDefinition(WITHER_STORM_3, () -> WitherStormPregnantHunchbackModel.createLayerDefinition(CubeDeformation.f_171458_));
        event.registerLayerDefinition(WITHER_STORM_4, () -> WitherStormDestroyerModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_5, () -> WitherStormEvolvedDestroyerModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_6, () -> WitherStormDevourerModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_7, () -> WitherStormEvolvedDevourerModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_DISMANTLED, () -> WitherStormDismantledModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_TORN, () -> WitherStormTornEvolvedDevourerModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_ARMOR, () -> WitherStormCommandBlockModel.createLayerDefinition(LayerDefinitions.f_171107_));
        event.registerLayerDefinition(WITHER_STORM_SEGMENT, () -> WitherStormSegmentModel.createLayerDefinition());
        event.registerLayerDefinition(FLAMING_WITHER_SKULL, () -> FlamingWitherSkullModel.createLayerDefinition());
        event.registerLayerDefinition(SICKENED_ZOMBIE, () -> humanoid);
        event.registerLayerDefinition(SICKENED_ZOMBIE_INNER_ARMOR, () -> humanoid_inner);
        event.registerLayerDefinition(SICKENED_ZOMBIE_OUTER_ARMOR, () -> humanoid_outer);
        event.registerLayerDefinition(SICKENED_SKELETON, () -> SkeletonModel.m_170942_());
        event.registerLayerDefinition(SICKENED_SKELETON_INNER_ARMOR, () -> humanoid_inner);
        event.registerLayerDefinition(SICKENED_SKELETON_OUTER_ARMOR, () -> humanoid_outer);
        event.registerLayerDefinition(SICKENED_CREEPER, () -> CreeperModel.m_170525_((CubeDeformation)CubeDeformation.f_171458_));
        event.registerLayerDefinition(SICKENED_CREEPER_ARMOR, () -> CreeperModel.m_170525_((CubeDeformation)new CubeDeformation(2.0f)));
        event.registerLayerDefinition(SICKENED_SPIDER, () -> SpiderModel.m_170985_());
        event.registerLayerDefinition(WITHERED_SYMBIONT, () -> WitheredSymbiontModel.createLayerDefinition());
        event.registerLayerDefinition(WITHER_STORM_HEAD, () -> WitherStormHeadModel.createLayerDefinition());
        event.registerLayerDefinition(TENTACLE, () -> TentacleModel.createLayerDefinition());
        event.registerLayerDefinition(RIBCAGE, () -> RibcageModel.createLayerDefinition());
    }

    @SubscribeEvent
    public static void addRendererLayers(EntityRenderersEvent.AddLayers event) {
        if (WitherStormModConfig.CLIENT.witherSicknessLayer.get().booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            EntityRenderDispatcher manager = mc.m_91290_();
            manager.getSkinMap().forEach((type, renderer) -> {
                if (renderer instanceof LivingEntityRenderer) {
                    LivingEntityRenderer living = (LivingEntityRenderer)renderer;
                    living.m_115326_(new WitherSicknessLayer(living));
                }
            });
            for (Map.Entry entry : manager.f_114362_.entrySet()) {
                EntityRenderer renderer2 = (EntityRenderer)entry.getValue();
                if (!(renderer2 instanceof LivingEntityRenderer)) continue;
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer2;
                livingRenderer.m_115326_(new WitherSicknessLayer(livingRenderer));
            }
        }
    }

    public static ModelLayerLocation getLayer(WitherStormEntity storm) {
        if (storm instanceof WitherStormSegmentEntity) {
            return WITHER_STORM_SEGMENT;
        }
        int phase = storm.getPhase();
        switch (phase) {
            case 0: {
                return WITHER_STORM_0;
            }
            case 1: {
                return WITHER_STORM_1;
            }
            case 2: {
                return WITHER_STORM_2;
            }
            case 3: {
                return WITHER_STORM_3;
            }
            case 4: {
                return WITHER_STORM_4;
            }
            case 5: {
                if (storm.getConsumptionAmountForPhase(phase) >= storm.getConsumedEntities()) {
                    return WITHER_STORM_5;
                }
                return WITHER_STORM_6;
            }
            case 6: {
                if (storm.getConsumedEntities() <= storm.getSubPhaseRequirement(phase)) {
                    return WITHER_STORM_DISMANTLED;
                }
                return WITHER_STORM_6;
            }
            case 7: {
                if (!storm.isBeingTornApart()) {
                    return WITHER_STORM_7;
                }
                return WITHER_STORM_TORN;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + phase);
    }
}

