/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import nonamecrackers2.witherstormmod.client.audio.SoundManagersRefresher;
import nonamecrackers2.witherstormmod.client.gui.AbstractConfigScreen;
import nonamecrackers2.witherstormmod.client.gui.MoreWorldOptionsScreen;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.util.UltimateTargetManager;

public class WitherStormModConfigScreen
extends Screen {
    private static int BUTTON_WIDTH = 200;
    private static int BUTTON_HEIGHT = 20;
    private static int EXIT_BUTTON_OFFSET = 26;
    private static int TITLE_HEIGHT = 40;
    private static int INFO_HEIGHT = 65;
    private Button clientButton;
    private Button commonButton;
    private Button worldButton;
    private Button exit;
    private final Optional<Level> world;

    public WitherStormModConfigScreen(Optional<Level> world) {
        super((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.title"));
        this.world = world;
    }

    protected void m_7856_() {
        this.clientButton = new Button((this.f_96543_ - 200) / 2, (this.f_96544_ - 50) / 2, 200, 20, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.clientOptions.title"), button -> this.openClientMenu(), (button, stack, mouseX, mouseY) -> this.m_96602_(stack, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.clientOptions.info"), mouseX, mouseY));
        this.commonButton = new Button((this.f_96543_ - 200) / 2, (this.f_96544_ - 0) / 2, 200, 20, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.commonOptions.title"), button -> this.openCommonMenu(), (button, stack, mouseX, mouseY) -> this.m_96602_(stack, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.commonOptions.info"), mouseX, mouseY));
        this.worldButton = new Button((this.f_96543_ - 200) / 2, (this.f_96544_ + 50) / 2, 200, 20, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.worldOptions.title"), button -> this.openWorldOptionsMenu(), (button, stack, mouseX, mouseY) -> {
            MutableComponent worldDesc = Component.m_237115_((String)"gui.witherstormmod.screen.worldOptions.notInWorld.info");
            if (this.world.isPresent()) {
                worldDesc = Component.m_237115_((String)"gui.witherstormmod.screen.worldOptions.inWorld.info");
            }
            this.m_96602_(stack, (Component)worldDesc, mouseX, mouseY);
        });
        this.exit = new Button((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - EXIT_BUTTON_OFFSET, BUTTON_WIDTH, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.witherstormmod.button.exit.title"), button -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.clientButton);
        this.commonButton.f_93623_ = this.world.isPresent() && this.f_96541_.m_91091_() || !this.world.isPresent();
        this.m_142416_((GuiEventListener)this.commonButton);
        this.worldButton.f_93623_ = this.world.isPresent() && this.f_96541_.m_91091_();
        this.m_142416_((GuiEventListener)this.worldButton);
        this.m_142416_((GuiEventListener)this.exit);
    }

    public void openClientMenu() {
        this.f_96541_.m_91152_((Screen)new Client());
    }

    public void openCommonMenu() {
        this.f_96541_.m_91152_((Screen)new Common());
    }

    public void openWorldOptionsMenu() {
        this.f_96541_.m_91152_((Screen)new Server());
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        WitherStormModConfigScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)TITLE_HEIGHT, (int)0xFFFFFF);
        WitherStormModConfigScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.info"), (int)(this.f_96543_ / 2), (int)INFO_HEIGHT, (int)6768271);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public static class Client
    extends AbstractConfigScreen {
        private static final ResourceLocation SOUND_REFRESHER = new ResourceLocation("witherstormmod", "textures/gui/sound_refresher.png");
        private OptionInstance<Boolean> renderDebrisCloud;
        private OptionInstance<Boolean> renderDebrisRings;
        private OptionInstance<Boolean> renderDebrisTwoDimensional;
        private OptionInstance<Boolean> renderDistantDebris;
        private OptionInstance<Boolean> renderSegmentDebris;
        private OptionInstance<Boolean> lowerDebrisResWithPhase;
        private OptionInstance<Boolean> witherStormLOD;
        private OptionInstance<Boolean> lowResModels;
        private OptionInstance<Boolean> renderTractorBeams;
        private OptionInstance<Boolean> renderPulse;
        private OptionInstance<Boolean> distantRenderer;
        private OptionInstance<Boolean> blockClusterRendering;
        private OptionInstance<Boolean> witherSicknessLayer;
        private OptionInstance<Boolean> playBossThemes;
        private OptionInstance<Boolean> chromaticAberration;
        private OptionInstance<Boolean> blindingEffects;
        private OptionInstance<Boolean> cameraShakeEffects;
        private OptionInstance<Boolean> distantFog;
        private OptionInstance<Boolean> blockClusterColouring;
        private OptionInstance<Boolean> earRingingEffects;
        private OptionInstance<Boolean> tractorBeamOverlay;
        private OptionInstance<Boolean> renderSkyAmbienceEffects;
        private OptionInstance<Boolean> tractorBeamParticles;
        private Button refreshSoundsButton;

        public Client() {
            super((Component)Component.m_237115_((String)"gui.witherstormmod.screen.clientOptions.title"), WitherStormModConfig.CLIENT);
        }

        @Override
        protected void addOptions() {
            this.renderDebrisCloud = this.createBooleanOption("gui.witherstormmod.config.renderDebrisCloud.title", WitherStormModConfig.CLIENT.renderDebrisCloud);
            this.renderDebrisRings = this.createBooleanOption("gui.witherstormmod.config.renderDebrisRings.title", WitherStormModConfig.CLIENT.renderDebrisRings);
            this.renderDebrisTwoDimensional = this.createBooleanOption("gui.witherstormmod.config.renderDebrisTwoDimensional.title", WitherStormModConfig.CLIENT.renderDebrisTwoDimensional);
            this.renderDistantDebris = this.createBooleanOption("gui.witherstormmod.config.renderDistantDebris.title", WitherStormModConfig.CLIENT.renderDistantDebris);
            this.renderSegmentDebris = this.createBooleanOption("gui.witherstormmod.config.renderSegmentDebris.title", WitherStormModConfig.CLIENT.renderSegmentDebris);
            this.lowerDebrisResWithPhase = this.createBooleanOption("gui.witherstormmod.config.lowerDebrisResWithPhase.title", WitherStormModConfig.CLIENT.lowerDebrisResWithPhase);
            this.witherStormLOD = this.createBooleanOption("gui.witherstormmod.config.witherStormLOD.title", WitherStormModConfig.CLIENT.witherStormLOD);
            this.lowResModels = this.createBooleanOption("gui.witherstormmod.config.lowResModels.title", WitherStormModConfig.CLIENT.lowResModels);
            this.renderTractorBeams = this.createBooleanOption("gui.witherstormmod.config.renderTractorBeams.title", WitherStormModConfig.CLIENT.renderTractorBeams);
            this.renderPulse = this.createBooleanOption("gui.witherstormmod.config.renderPulse.title", WitherStormModConfig.CLIENT.renderPulse);
            this.distantRenderer = this.createBooleanOption("gui.witherstormmod.config.distantRenderer.title", WitherStormModConfig.CLIENT.distantRenderer);
            this.blockClusterRendering = this.createBooleanOption("gui.witherstormmod.config.blockClusterRendering.title", WitherStormModConfig.CLIENT.blockClusterRendering);
            this.witherSicknessLayer = this.createBooleanOption("gui.witherstormmod.config.witherSicknessLayer.title", WitherStormModConfig.CLIENT.witherSicknessLayer);
            this.playBossThemes = this.createBooleanOption("gui.witherstormmod.config.playBossThemes.title", WitherStormModConfig.CLIENT.playBossThemes);
            this.chromaticAberration = this.createBooleanOption("gui.witherstormmod.config.chromaticAberration.title", WitherStormModConfig.CLIENT.chromaticAberration);
            this.blindingEffects = this.createBooleanOption("gui.witherstormmod.config.blindingEffects.title", WitherStormModConfig.CLIENT.blindingEffects);
            this.cameraShakeEffects = this.createBooleanOption("gui.witherstormmod.config.cameraShakeEffects.title", WitherStormModConfig.CLIENT.cameraShakeEffects);
            this.distantFog = this.createBooleanOption("gui.witherstormmod.config.distantFog.title", WitherStormModConfig.CLIENT.distantFog);
            this.blockClusterColouring = this.createBooleanOption("gui.witherstormmod.config.blockClusterColouring.title", WitherStormModConfig.CLIENT.blockClusterColouring);
            this.earRingingEffects = this.createBooleanOption("gui.witherstormmod.config.earRingingEffects.title", WitherStormModConfig.CLIENT.earRingingEffects);
            this.tractorBeamOverlay = this.createBooleanOption("gui.witherstormmod.config.tractorBeamOverlay.title", WitherStormModConfig.CLIENT.renderTractorBeamOverlay);
            this.renderSkyAmbienceEffects = this.createBooleanOption("gui.witherstormmod.config.renderSkyAmbienceEffects.title", WitherStormModConfig.CLIENT.renderSkyAmbienceEffects);
            this.tractorBeamParticles = this.createBooleanOption("gui.witherstormmod.config.tractorBeamParticles.title", WitherStormModConfig.CLIENT.tractorBeamParticles);
            this.options.m_232528_(this.renderDebrisCloud);
            this.options.m_232528_(this.renderDebrisRings);
            this.options.m_232528_(this.renderDebrisTwoDimensional);
            this.options.m_232528_(this.renderDistantDebris);
            this.options.m_232528_(this.renderSegmentDebris);
            this.options.m_232528_(this.lowerDebrisResWithPhase);
            this.options.m_232528_(this.witherStormLOD);
            this.options.m_232528_(this.lowResModels);
            this.options.m_232528_(this.renderTractorBeams);
            this.options.m_232528_(this.renderPulse);
            this.options.m_232528_(this.distantRenderer);
            this.options.m_232528_(this.blockClusterRendering);
            this.options.m_232528_(this.witherSicknessLayer);
            this.options.m_232528_(this.playBossThemes);
            this.options.m_232528_(this.chromaticAberration);
            this.options.m_232528_(this.blindingEffects);
            this.options.m_232528_(this.cameraShakeEffects);
            this.options.m_232528_(this.distantFog);
            this.options.m_232528_(this.blockClusterColouring);
            this.options.m_232528_(this.earRingingEffects);
            this.options.m_232528_(this.tractorBeamOverlay);
            this.options.m_232528_(this.renderSkyAmbienceEffects);
            this.options.m_232528_(this.tractorBeamParticles);
        }

        @Override
        protected void m_7856_() {
            this.refreshSoundsButton = new Button(5, 5, 20, 20, (Component)Component.m_237115_((String)"gui.witherstormmod.button.refreshSounds.title"), button -> this.refreshSoundSystem(), (button, stack, mouseX, mouseY) -> this.m_96602_(stack, (Component)Component.m_237115_((String)"gui.witherstormmod.button.refreshSounds.title"), mouseX, mouseY)){

                public void m_6303_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)SOUND_REFRESHER);
                    int x = 0;
                    int y = 0;
                    if (!this.f_93623_) {
                        x = 20;
                    }
                    if (this.m_198029_()) {
                        y = 20;
                    }
                    RenderSystem.m_69482_();
                    1.m_93133_((PoseStack)p_230431_1_, (int)this.f_93620_, (int)this.f_93621_, (float)x, (float)y, (int)this.f_93618_, (int)this.f_93619_, (int)256, (int)256);
                    if (this.m_198029_()) {
                        this.f_93718_.m_93752_((Button)this, p_230431_1_, p_230431_2_, p_230431_3_);
                    }
                }
            };
            super.m_7856_();
            this.m_142416_((GuiEventListener)this.refreshSoundsButton);
            this.refreshSoundsButton.f_93623_ = this.f_96541_.f_91073_ != null;
        }

        private void refreshSoundSystem() {
            SoundManagersRefresher.INSTANCE.refresh();
        }
    }

    public static class Common
    extends AbstractConfigScreen {
        private OptionInstance<Boolean> playerFavorability;
        private OptionInstance<Boolean> blockClustersDropItems;
        private OptionInstance<Boolean> shouldPickUpVehicles;
        private OptionInstance<Boolean> phantomsOrbitWitherStorm;
        private OptionInstance<Boolean> crossbowsSupportEnderPearls;
        private OptionInstance<Boolean> playerCannotDismountTentacles;
        private OptionInstance<Boolean> injectCustomAiBehavior;

        public Common() {
            super((Component)Component.m_237115_((String)"gui.witherstormmod.screen.commonOptions.title"), WitherStormModConfig.COMMON);
        }

        @Override
        protected void addOptions() {
            this.playerFavorability = this.createBooleanOption("gui.witherstormmod.config.playerFavorability.title", WitherStormModConfig.COMMON.playerFavorability);
            this.blockClustersDropItems = this.createBooleanOption("gui.witherstormmod.config.blockClustersDropItems.title", WitherStormModConfig.COMMON.blockClustersDropItems);
            this.shouldPickUpVehicles = this.createBooleanOption("gui.witherstormmod.config.shouldPickUpVehicles.title", WitherStormModConfig.COMMON.shouldPickUpVehicles);
            this.phantomsOrbitWitherStorm = this.createBooleanOption("gui.witherstormmod.config.phantomsOrbitWitherStorm.title", WitherStormModConfig.COMMON.phantomsOrbitWitherStorm);
            this.crossbowsSupportEnderPearls = this.createBooleanOption("gui.witherstormmod.config.crossbowsSupportEnderPearls.title", WitherStormModConfig.COMMON.crossbowsSupportEnderPearls);
            this.playerCannotDismountTentacles = this.createBooleanOption("gui.witherstormmod.config.playerCannotDismountTentacles.title", WitherStormModConfig.COMMON.playerCannotDismountTentacles);
            this.injectCustomAiBehavior = this.createBooleanOption("gui.witherstormmod.config.injectCustomAiBehavior.title", WitherStormModConfig.COMMON.injectCustomAiBehavior);
            this.options.m_232528_(this.playerFavorability);
            this.options.m_232528_(this.blockClustersDropItems);
            this.options.m_232528_(this.shouldPickUpVehicles);
            this.options.m_232528_(this.phantomsOrbitWitherStorm);
            this.options.m_232528_(this.crossbowsSupportEnderPearls);
            this.options.m_232528_(this.playerCannotDismountTentacles);
            this.options.m_232528_(this.injectCustomAiBehavior);
        }
    }

    public static class Server
    extends AbstractConfigScreen {
        private OptionInstance<Boolean> shouldAccelerateWhenTargetStationary;
        private OptionInstance<Integer> targetStationaryChunkRadius;
        private OptionInstance<Integer> playerPickupChance;
        private OptionInstance<Double> evolutionAttributeModifier;
        private OptionInstance<Integer> targetStationaryMinutes;
        private OptionInstance<Integer> targetRunawayMinutes;
        private OptionInstance<Integer> invulnerabilityTime;
        private OptionInstance<Double> targetStationaryFlyingSpeed;
        private OptionInstance<Double> slowFlyingSpeed;
        private OptionInstance<Boolean> usePhaseAsDistanceMultiplier;
        private OptionInstance<Double> distanceMultiplier;
        private OptionInstance<Boolean> accelerateOnPhaseChange;
        private OptionInstance<Boolean> targetRunawayAttempts;
        private OptionInstance<Integer> targetRunawayAttemptMinutes;
        private OptionInstance<Integer> targetRunawayAttemptsRequired;
        private OptionInstance<Integer> minutesTillRunawayAttemptDiminish;
        private OptionInstance<Boolean> targettingDistractionsEnabled;
        private OptionInstance<Integer> distractionTimeMinutes;
        private OptionInstance<Integer> maximumDistractionDistance;
        private OptionInstance<Integer> minimumDistractionDistance;
        private OptionInstance<Boolean> randomDistractionChances;
        private OptionInstance<Integer> searchRangeMultiplier;
        private OptionInstance<Integer> distractionWaitTime;
        private OptionInstance<Boolean> clustersRemoveItems;
        private OptionInstance<Boolean> squashHitbox;
        private OptionInstance<Integer> hunchbackClusterPickupInterval;
        private OptionInstance<Integer> clusterPickupInterval;
        private OptionInstance<Integer> devourerClusterPickupInterval;
        private OptionInstance<Integer> flyingHeight;
        private OptionInstance<Integer> tillShouldShowHole;
        private OptionInstance<Double> rotationSpeed;
        private OptionInstance<Boolean> canPickupMobClusters;
        private OptionInstance<Boolean> witherStormInvulnerability;
        private OptionInstance<UltimateTargetManager.TargetingType> ultimateTargetingType;
        private Button moreOptions;

        public Server() {
            super((Component)Component.m_237115_((String)"gui.witherstormmod.screen.worldOptions.title"), WitherStormModConfig.SERVER);
        }

        @Override
        protected void addOptions() {
            this.shouldAccelerateWhenTargetStationary = this.createBooleanOption("gui.witherstormmod.config.shouldAccelerateWhenTargetStationary.title", WitherStormModConfig.SERVER.shouldAccelerateWhenTargetStopped);
            this.targetStationaryChunkRadius = this.createIntSliderOption("gui.witherstormmod.config.targetStationaryChunkRadius.title", 0, 16, 1, WitherStormModConfig.SERVER.targetStationaryChunkRadius);
            this.playerPickupChance = this.createIntSliderOption("gui.witherstormmod.config.playerPickupChance.title", 0, 10, 1, WitherStormModConfig.SERVER.playerPickupChance);
            this.evolutionAttributeModifier = this.createDoubleSliderOption("gui.witherstormmod.config.evolutionAttributeModifier.title", 0.01, 32.0, 0.01f, 10, WitherStormModConfig.SERVER.evolutionAttributeModifier);
            this.targetStationaryMinutes = this.createIntSliderOption("gui.witherstormmod.config.targetStationaryMinutes.title", 1, 120, 1, WitherStormModConfig.SERVER.targetStationaryMinutes);
            this.targetRunawayMinutes = this.createIntSliderOption("gui.witherstormmod.config.targetRunawayMinutes.title", 1, 90, 1, WitherStormModConfig.SERVER.targetRunawayMinutes);
            this.invulnerabilityTime = this.createIntSliderOption("gui.witherstormmod.config.invulnerabilityTime.title", 1, 320, 1, WitherStormModConfig.SERVER.invulnerabilityTime);
            this.targetStationaryFlyingSpeed = this.createDoubleSliderOption("gui.witherstormmod.config.targetStationaryFlyingSpeed.title", 0.01, 1.0, 0.01f, 100, WitherStormModConfig.SERVER.targetStationaryFlyingSpeed);
            this.slowFlyingSpeed = this.createDoubleSliderOption("gui.witherstormmod.config.slowFlyingSpeed.title", 0.01, 1.0, 0.01f, 100, WitherStormModConfig.SERVER.slowFlyingSpeed);
            this.usePhaseAsDistanceMultiplier = this.createBooleanOption("gui.witherstormmod.config.usePhaseAsDistanceMultiplier.title", WitherStormModConfig.SERVER.usePhaseAsDistanceMultiplier);
            this.distanceMultiplier = this.createDoubleSliderOption("gui.witherstormmod.config.distanceMultiplier.title", 0.1, 24.0, 0.1f, 10, WitherStormModConfig.SERVER.distanceMultiplier);
            this.accelerateOnPhaseChange = this.createBooleanOption("gui.witherstormmod.config.accelerateOnPhaseChange.title", WitherStormModConfig.SERVER.accelerateOnPhaseChange);
            this.targetRunawayAttempts = this.createBooleanOption("gui.witherstormmod.config.targetRunawayAttempts.title", WitherStormModConfig.SERVER.targetRunawayAttempts);
            this.targetRunawayAttemptMinutes = this.createIntSliderOption("gui.witherstormmod.config.targetRunawayAttemptMinutes.title", 1, 20, 1, WitherStormModConfig.SERVER.targetRunawayAttemptMinutes);
            this.targetRunawayAttemptsRequired = this.createIntSliderOption("gui.witherstormmod.config.targetRunawayAttemptsRequired.title", 1, 32, 1, WitherStormModConfig.SERVER.targetRunawayAttemptsRequired);
            this.minutesTillRunawayAttemptDiminish = this.createIntSliderOption("gui.witherstormmod.config.minutesTillRunawayAttemptDiminish.title", 1, 48, 1, WitherStormModConfig.SERVER.minutesTillRunawayAttemptDiminish);
            this.targettingDistractionsEnabled = this.createBooleanOption("gui.witherstormmod.config.targettingDistractionsEnabled.title", WitherStormModConfig.SERVER.targettingDistractionsEnabled);
            this.distractionTimeMinutes = this.createIntSliderOption("gui.witherstormmod.config.distractionTimeMinutes.title", 1, 45, 1, WitherStormModConfig.SERVER.distractionTimeMinutes);
            this.maximumDistractionDistance = this.createIntSliderOption("gui.witherstormmod.config.maximumDistractionDistance.title", 100, 3000, 100, WitherStormModConfig.SERVER.maximumDistractionDistance);
            this.minimumDistractionDistance = this.createIntSliderOption("gui.witherstormmod.config.minimumDistractionDistance.title", 10, 500, 10, WitherStormModConfig.SERVER.minimumDistractionDistance);
            this.randomDistractionChances = this.createBooleanOption("gui.witherstormmod.config.randomDistractionChances.title", WitherStormModConfig.SERVER.randomDistractionChances);
            this.searchRangeMultiplier = this.createIntSliderOption("gui.witherstormmod.config.searchRangeMultiplier.title", 1, 8, 1, WitherStormModConfig.SERVER.searchRangeMultiplier);
            this.distractionWaitTime = this.createIntSliderOption("gui.witherstormmod.config.distractionWaitTime.title", 1, 20, 1, WitherStormModConfig.SERVER.distractionWaitTime);
            this.clustersRemoveItems = this.createBooleanOption("gui.witherstormmod.config.clustersRemoveItems.title", WitherStormModConfig.SERVER.clustersRemoveItems);
            this.squashHitbox = this.createBooleanOption("gui.witherstormmod.config.squashHitbox.title", WitherStormModConfig.SERVER.squashHitbox);
            this.hunchbackClusterPickupInterval = this.createIntSliderOption("gui.witherstormmod.config.hunchbackClusterPickupInterval.title", 10, 80, 1, WitherStormModConfig.SERVER.hunchbackClusterPickupInterval);
            this.clusterPickupInterval = this.createIntSliderOption("gui.witherstormmod.config.clusterPickupInterval.title", 10, 80, 1, WitherStormModConfig.SERVER.clusterPickupInterval);
            this.devourerClusterPickupInterval = this.createIntSliderOption("gui.witherstormmod.config.devourerClusterPickupInterval.title", 10, 80, 1, WitherStormModConfig.SERVER.devourerClusterPickupInterval);
            this.flyingHeight = this.createIntSliderOption("gui.witherstormmod.config.flyingHeight.title", 10, 150, 1, WitherStormModConfig.SERVER.flyingHeight);
            this.tillShouldShowHole = this.createIntSliderOption("gui.witherstormmod.config.tillShouldShowHole.title", 1, 30, 1, WitherStormModConfig.SERVER.tillShouldShowHole);
            this.ultimateTargetingType = this.createEnumOption("gui.witherstormmod.config.ultimateTargetingType.title", UltimateTargetManager.TargetingType.values(), WitherStormModConfig.SERVER.ultimateTargetingType);
            this.rotationSpeed = this.createDoubleSliderOption("gui.witherstormmod.config.rotationSpeed.title", 0.1, 1.0, 0.1f, 10, WitherStormModConfig.SERVER.rotationSpeed);
            this.canPickupMobClusters = this.createBooleanOption("gui.witherstormmod.config.canPickupMobClusters.title", WitherStormModConfig.SERVER.canPickupMobClusters);
            this.witherStormInvulnerability = this.createBooleanOption("gui.witherstormmod.config.witherStormInvulnerability.title", WitherStormModConfig.SERVER.witherStormInvulnerability);
            this.options.m_232528_(this.shouldAccelerateWhenTargetStationary);
            this.options.m_232528_(this.targetStationaryChunkRadius);
            this.options.m_232528_(this.playerPickupChance);
            this.options.m_232528_(this.evolutionAttributeModifier);
            this.options.m_232528_(this.targetStationaryMinutes);
            this.options.m_232528_(this.targetRunawayMinutes);
            this.options.m_232528_(this.invulnerabilityTime);
            this.options.m_232528_(this.targetStationaryFlyingSpeed);
            this.options.m_232528_(this.slowFlyingSpeed);
            this.options.m_232528_(this.usePhaseAsDistanceMultiplier);
            this.options.m_232528_(this.distanceMultiplier);
            this.options.m_232528_(this.accelerateOnPhaseChange);
            this.options.m_232528_(this.targetRunawayAttempts);
            this.options.m_232528_(this.targetRunawayAttemptMinutes);
            this.options.m_232528_(this.targetRunawayAttemptsRequired);
            this.options.m_232528_(this.minutesTillRunawayAttemptDiminish);
            this.options.m_232528_(this.targettingDistractionsEnabled);
            this.options.m_232528_(this.distractionTimeMinutes);
            this.options.m_232528_(this.maximumDistractionDistance);
            this.options.m_232528_(this.minimumDistractionDistance);
            this.options.m_232528_(this.randomDistractionChances);
            this.options.m_232528_(this.searchRangeMultiplier);
            this.options.m_232528_(this.distractionWaitTime);
            this.options.m_232528_(this.clustersRemoveItems);
            this.options.m_232528_(this.squashHitbox);
            this.options.m_232528_(this.hunchbackClusterPickupInterval);
            this.options.m_232528_(this.clusterPickupInterval);
            this.options.m_232528_(this.devourerClusterPickupInterval);
            this.options.m_232528_(this.flyingHeight);
            this.options.m_232528_(this.tillShouldShowHole);
            this.options.m_232528_(this.rotationSpeed);
            this.options.m_232528_(this.canPickupMobClusters);
            this.options.m_232528_(this.witherStormInvulnerability);
            this.options.m_232528_(this.ultimateTargetingType);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.moreOptions = new Button(10, 5, (int)Math.round((double)BUTTON_WIDTH / 1.5), BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.witherstormmod.screen.moreWorldOptions.title"), button -> {
                this.config.saveAllValues();
                this.f_96541_.m_91152_((Screen)new MoreWorldOptionsScreen());
            });
            this.m_142416_((GuiEventListener)this.moreOptions);
        }
    }
}

