/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import nonamecrackers2.witherstormmod.client.gui.WitherStormModConfigScreen;
import nonamecrackers2.witherstormmod.common.config.AbstractConfig;
import nonamecrackers2.witherstormmod.common.config.ConfigValue;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;

public abstract class AbstractConfigScreen
extends Screen {
    protected static int TITLE_HEIGHT = 12;
    protected static int BUTTON_WIDTH = 200;
    protected static int BUTTON_HEIGHT = 20;
    protected static int EXIT_BUTTON_OFFSET = 26;
    protected static int LIST_TOP_HEIGHT = 30;
    protected static int LIST_BOTTOM_OFFSET = 32;
    protected static int LIST_ITEM_HEIGHT = 25;
    protected final AbstractConfig config;
    protected OptionsList options;
    protected Button exit;
    protected Button changePreset;
    protected Button reset;
    protected int hoverTime;
    protected int presetIndex;
    protected boolean refreshing;

    public AbstractConfigScreen(Component component, AbstractConfig config) {
        super(component);
        this.config = config;
    }

    protected void m_7856_() {
        if (!this.refreshing) {
            this.config.resetAllValues();
        }
        this.options = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, LIST_TOP_HEIGHT, this.f_96544_ - LIST_BOTTOM_OFFSET, LIST_ITEM_HEIGHT);
        ConfigPreset preset = this.config.getCurrentPreset() == null ? this.config.findCurrentPreset() : this.config.getCurrentPreset();
        this.addOptions();
        this.m_142416_((GuiEventListener)this.options);
        this.exit = new Button((this.f_96543_ - BUTTON_WIDTH / 2) / 2, this.f_96544_ - EXIT_BUTTON_OFFSET, BUTTON_WIDTH / 2, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.witherstormmod.button.exitAndSave.title"), button -> this.closeMenu());
        this.changePreset = new Button(10, this.f_96544_ - EXIT_BUTTON_OFFSET, (int)Math.round((double)BUTTON_WIDTH / 1.5), BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + preset.getTranslationName().getString()), button -> this.changePreset(), (button, stack, mouseX, mouseY) -> this.m_96617_(stack, this.config.getCurrentPreset().getTooltip(AbstractConfigScreen.m_96638_()), mouseX, mouseY));
        this.reset = new Button(this.f_96543_ - (int)((double)BUTTON_WIDTH / 1.5) - 10, this.f_96544_ - EXIT_BUTTON_OFFSET, (int)Math.round((double)BUTTON_WIDTH / 1.5), BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.witherstormmod.button.reset.title"), button -> this.resetValues());
        this.presetIndex = this.config.getPresets().indexOf(this.config.getCurrentPreset());
        this.m_142416_((GuiEventListener)this.exit);
        this.m_142416_((GuiEventListener)this.changePreset);
        this.m_142416_((GuiEventListener)this.reset);
    }

    protected void closeMenu() {
        this.config.saveAllValues();
        Optional<ClientLevel> world = Optional.ofNullable(this.f_96541_.f_91073_);
        this.f_96541_.m_91152_((Screen)new WitherStormModConfigScreen(world));
    }

    protected abstract void addOptions();

    protected void changePreset() {
        ++this.presetIndex;
        if (this.presetIndex >= this.config.getPresets().size()) {
            this.presetIndex = 0;
        }
        this.config.setCurrentPreset(this.config.getPresets().get(this.presetIndex));
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.config.getCurrentPreset().getTranslationName().getString()));
        this.config.setValuesBasedOnPreset();
        this.refreshMenu();
    }

    protected void refreshMenu() {
        double scroll = this.options.m_93517_();
        this.setRefreshing();
        this.f_96541_.m_91152_((Screen)this);
        this.options.m_93410_(scroll);
    }

    protected void setRefreshing() {
        this.refreshing = true;
    }

    protected void resetValues() {
        this.config.resetAllValues();
        this.refreshMenu();
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.config.findCurrentPreset().getTranslationName().getString()));
        this.presetIndex = this.config.getPresets().indexOf(this.config.getCurrentPreset());
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        AbstractConfigScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)TITLE_HEIGHT, (int)0xFFFFFF);
        Optional optional = this.options.m_94480_((double)mouseX, (double)mouseY);
        this.reset.f_93623_ = !this.config.areValuesReset();
        optional.ifPresent(widget -> {
            ++this.hoverTime;
            if (this.hoverTime > 60 && widget instanceof TooltipAccessor) {
                TooltipAccessor tooltip = (TooltipAccessor)widget;
                this.m_96617_(stack, tooltip.m_141932_(), mouseX, mouseY);
            }
        });
        if (!optional.isPresent()) {
            this.hoverTime = 0;
        }
    }

    public <T> void set(ConfigValue<T> config, T value) {
        config.set(value);
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.config.findCurrentPreset().getTranslationName().getString()));
    }

    protected List<FormattedCharSequence> createConfigTooltip(ConfigValue<?> value) {
        ConfigPreset preset = this.config.getCurrentPreset();
        List<MutableComponent> comments = value.getComment();
        ConfigValue.ReloadType type = value.getReloadType();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        for (int i = 0; i < comments.size(); ++i) {
            tooltip.add(FormattedCharSequence.m_13714_((String)comments.get(i).getString(), (Style)Style.f_131099_));
        }
        tooltip.add(FormattedCharSequence.m_13714_((String)value.getDefinition(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        Object defaultName = "Default: ";
        Object object = preset.getPresetValue(value);
        if (!preset.getValues().isEmpty() && !preset.isDefault()) {
            defaultName = "Default (" + preset.getTranslationName().getString() + "): ";
        } else {
            object = value.getDefault();
        }
        tooltip.add(FormattedCharSequence.m_13714_((String)((String)defaultName + object), (Style)Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        if (type != ConfigValue.ReloadType.NONE) {
            tooltip.add(FormattedCharSequence.m_13714_((String)("Requires reload of " + type.toString()), (Style)Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
        }
        return tooltip;
    }

    public OptionInstance<Boolean> createBooleanOption(String title, ConfigValue<Boolean> value) {
        OptionInstance option = OptionInstance.m_231520_((String)title, mc -> unused -> this.createConfigTooltip(value), (boolean)value.get(), newValue -> this.set(value, newValue));
        return option;
    }

    public OptionInstance<Integer> createIntSliderOption(String title, int min, int max, int step, ConfigValue<Integer> value) {
        OptionInstance option = new OptionInstance(title, mc -> unused -> this.createConfigTooltip(value), (gs, optionValue) -> Component.m_237113_((String)(I18n.m_118938_((String)title, (Object[])new Object[0]) + ": " + optionValue)), (OptionInstance.ValueSet)new OptionInstance.IntRange(min / step, max / step).m_231657_(i -> i * step, i -> i / step), (Object)value.get(), newValue -> this.set(value, Integer.valueOf(newValue)));
        return option;
    }

    public OptionInstance<Double> createDoubleSliderOption(String title, double min, double max, float step, int decimalPlaces, ConfigValue<Double> value) {
        OptionInstance option = new OptionInstance(title, mc -> unused -> this.createConfigTooltip(value), (gs, optionValue) -> Component.m_237113_((String)(I18n.m_118938_((String)title, (Object[])new Object[0]) + ": " + Mth.m_14008_((double)((double)Math.round(optionValue * (double)decimalPlaces) / (double)decimalPlaces), (double)min, (double)max))), (OptionInstance.ValueSet)new OptionInstance.IntRange((int)(min / (double)step), (int)(max / (double)step)).m_231657_(i -> (double)i * (double)step, d -> (int)(d / (double)step)), Codec.doubleRange((double)min, (double)max), (Object)value.get(), newValue -> this.set(value, Math.max((double)step, (double)Math.round(newValue * (double)decimalPlaces) / (double)decimalPlaces)));
        return option;
    }

    public <T extends Enum<T>> OptionInstance<T> createEnumOption(String title, T[] values, ConfigValue<T> value) {
        return new OptionInstance(title, mc -> unused -> this.createConfigTooltip(value), (component, e) -> Component.m_237113_((String)e.name()), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(values), Codec.INT.xmap(ordinal -> values[ordinal], Enum::ordinal)), (Object)((Enum)value.get()), newValue -> this.set(value, newValue));
    }
}

