/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.client.renderer.entity.AbstractWitherStormRenderer;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.section.Section;

public class WitherStormModRenderEvents {
    @SubscribeEvent
    public static void renderStormHeadPositions(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES) && mc.m_91290_().m_114377_()) {
            PoseStack stack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110504_());
            ClientLevel world = mc.f_91073_;
            Iterable entities = world.m_104735_();
            double partialTicks = event.getPartialTick();
            for (Entity entity : entities) {
                if (!(entity instanceof WitherStormEntity)) continue;
                WitherStormEntity storm = (WitherStormEntity)entity;
                Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                Vec3 negativeProjectedView = new Vec3(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
                double size = storm.getPhase() < 4 ? 1.0 : 6.0;
                for (int i = 0; i < 3; ++i) {
                    boolean flag2;
                    stack.m_85836_();
                    Vec3 headPosition = negativeProjectedView.m_82549_(storm.getHeadPos(i));
                    Vec3 prevHeadPosition = negativeProjectedView.m_82549_(storm.getHeadPosO(i));
                    Vec3 pos = new Vec3(Mth.m_14139_((double)partialTicks, (double)prevHeadPosition.f_82479_, (double)headPosition.f_82479_), Mth.m_14139_((double)partialTicks, (double)prevHeadPosition.f_82480_, (double)headPosition.f_82480_), Mth.m_14139_((double)partialTicks, (double)prevHeadPosition.f_82481_, (double)headPosition.f_82481_));
                    AABB boundingBox = new AABB(0.0, 0.0, 0.0, size, size, size);
                    stack.m_85837_(pos.f_82479_ - size / 2.0, pos.f_82480_ - size / 2.0, pos.f_82481_ - size / 2.0);
                    float[] color = new float[]{1.0f, 1.0f, 0.0f};
                    if (i == 0) {
                        color = new float[]{1.0f, 0.6f, 0.0f};
                    }
                    boolean flag = i != 0 && storm.areOtherHeadsDisabled();
                    boolean bl = flag2 = i > 0 || storm.getPhase() > 1;
                    if (!flag && flag2) {
                        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)boundingBox, (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                    }
                    if (i > 0 && !storm.areOtherHeadsDisabled()) {
                        float x = (float)Mth.m_14139_((double)partialTicks, (double)storm.xRotOHeads[i - 1], (double)storm.getHeadXRot(i - 1));
                        float y = (float)Mth.m_14139_((double)partialTicks, (double)storm.yRotOHeads[i - 1], (double)storm.getHeadYRot(i - 1));
                        Vec3 eyePosition = storm.getViewVector(x, y, (float)(size + 1.0));
                        Matrix4f matrix4f = stack.m_85850_().m_85861_();
                        Matrix3f normal = stack.m_85850_().m_85864_();
                        builder.m_85982_(matrix4f, (float)(size / 2.0), (float)(size / 2.0), (float)(size / 2.0)).m_6122_(0, 0, 255, 255).m_85977_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
                        builder.m_85982_(matrix4f, (float)(size / 2.0) + (float)eyePosition.f_82479_, (float)(size / 2.0) + (float)eyePosition.f_82480_, (float)(size / 2.0) + (float)eyePosition.f_82481_).m_6122_(0, 0, 255, 255).m_85977_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
                    }
                    stack.m_85849_();
                }
            }
            buffer.m_109911_();
        }
    }

    @SubscribeEvent
    public static void renderStormParts(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES) && mc.m_91290_().m_114377_()) {
            PoseStack stack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110504_());
            ClientLevel world = mc.f_91073_;
            Iterable entities = world.m_104735_();
            for (Entity entity : entities) {
                WitherStormEntity storm;
                if (!(entity instanceof WitherStormEntity) || (storm = (WitherStormEntity)entity).getPhase() <= 4 || !storm.partsEnabled) continue;
                Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                Vec3 negativeProjectedView = new Vec3(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
                for (int i = 0; i < storm.getSections().length; ++i) {
                    Section part = storm.getSections()[i];
                    if (!part.isActive()) continue;
                    stack.m_85836_();
                    stack.m_85837_(negativeProjectedView.f_82479_, negativeProjectedView.f_82480_, negativeProjectedView.f_82481_);
                    LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)part.getBoundingBox(), (float)part.getColor()[0], (float)part.getColor()[1], (float)part.getColor()[2], (float)1.0f);
                    stack.m_85849_();
                }
            }
            buffer.m_109911_();
        }
    }

    @SubscribeEvent
    public static void renderExtraWitherStorm(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel world = mc.f_91073_;
            PoseStack stack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            Vec3 pos = mc.f_91063_.m_109153_().m_90583_();
            Vec3 negPos = new Vec3(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            float partialTicks = event.getPartialTick();
            EntityRenderDispatcher manager = mc.m_91290_();
            boolean flag = mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82480_)) || mc.f_91065_.m_93090_().m_93715_();
            FogRenderer.m_109018_((Camera)mc.f_91063_.m_109153_(), (float)partialTicks, (ClientLevel)world, (int)((Integer)mc.f_91066_.m_231984_().m_231551_()), (float)mc.f_91063_.m_109131_(partialTicks));
            FogRenderer.m_109036_();
            if ((Integer)mc.f_91066_.m_231984_().m_231551_() >= 4) {
                FogRenderer.m_234172_((Camera)mc.f_91063_.m_109153_(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(mc.f_91063_.m_109152_() - 16.0f, 32.0f), (boolean)flag, (float)partialTicks);
            }
            WitherStormModRenderEvents.doRenderAction(world, stack, partialTicks, negPos, (MultiBufferSource)buffer, (storm, buffer1) -> AbstractWitherStormRenderer.renderExtra(storm, manager, stack, buffer1, partialTicks));
            buffer.m_109911_();
            FogRenderer.m_109017_();
            buffer = mc.m_91269_().m_110104_();
            WitherStormModRenderEvents.doRenderAction(world, stack, partialTicks, negPos, (MultiBufferSource)buffer, (storm, buffer1) -> AbstractWitherStormRenderer.renderTractorBeams(storm, manager, stack, buffer1, partialTicks));
            buffer.m_109911_();
        }
    }

    private static void doRenderAction(ClientLevel world, PoseStack stack, float partialTicks, Vec3 negPos, MultiBufferSource buffer, BiConsumer<WitherStormEntity, MultiBufferSource> action) {
        for (Entity entity : world.m_104735_()) {
            if (!(entity instanceof WitherStormEntity)) continue;
            stack.m_85836_();
            WitherStormEntity storm = (WitherStormEntity)entity;
            double x = Mth.m_14139_((double)partialTicks, (double)storm.f_19790_, (double)storm.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)storm.f_19791_, (double)storm.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)storm.f_19792_, (double)storm.m_20189_());
            stack.m_85837_(negPos.f_82479_, negPos.f_82480_, negPos.f_82481_);
            stack.m_85837_(x, y, z);
            action.accept(storm, buffer);
            stack.m_85849_();
        }
    }
}

