/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.event;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.client.capability.WitherStormDistantRenderer;
import nonamecrackers2.witherstormmod.client.init.WitherStormModClientCapabilities;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class WitherStormAmbienceEffects {
    private final Minecraft mc;
    private float alpha = 1.0f;
    private float alphaO = 1.0f;

    public WitherStormAmbienceEffects(Minecraft mc) {
        this.mc = mc;
    }

    public void tick() {
        if (WitherStormModConfig.CLIENT.renderSkyAmbienceEffects.get().booleanValue()) {
            List<WitherStormEntity> storms = WitherStormAmbienceEffects.getApplicableEntities(this.mc.f_91073_);
            Vec3 cameraPos = this.mc.f_91063_.m_109153_().m_90583_();
            WitherStormEntity storm = WorldUtil.getNearest(storms, cameraPos, Entity::m_20182_);
            this.alphaO = this.alpha;
            if (storm != null && !storm.isDeadOrPlayingDead()) {
                float alpha = WitherStormAmbienceEffects.modifyEffectMagnitude(storm, Mth.m_14036_((float)((float)(cameraPos.m_82554_(storm.m_20182_()) - 200.0) * 0.005f), (float)0.0f, (float)1.0f));
                this.alpha += (alpha - this.alpha) / 25.0f;
            } else {
                this.alpha += (1.0f - this.alpha) / 100.0f;
            }
        }
    }

    public float lerpAlpha(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.alphaO, (float)this.alpha);
    }

    private static List<WitherStormEntity> getApplicableEntities(ClientLevel level) {
        return WitherStormDistantRenderer.getAllStorms(level).stream().filter(entity -> !(entity instanceof WitherStormSegmentEntity)).collect(Collectors.toList());
    }

    public static float modifyEffectMagnitude(WitherStormEntity storm, float alpha) {
        if (storm.getPhase() < 5) {
            return 1.0f;
        }
        if (storm.getPhase() == 5 && storm.getConsumptionAmountForPhase(5) >= storm.getConsumedEntities()) {
            return 1.0f;
        }
        if (storm.getPhase() == 5 && storm.getConsumptionAmountForPhase(5) <= storm.getConsumedEntities()) {
            return Math.min(alpha + 0.5f, 1.0f);
        }
        return Math.min(alpha + 0.15f, 1.0f);
    }

    public static Vec3 modifySkyColor(Minecraft mc, Vec3 original, Vec3 cameraPos, float partialTicks) {
        return WitherStormAmbienceEffects.transitionColor(mc, cameraPos, original, new int[]{20, 0, 19}, 200.0, partialTicks);
    }

    public static float modifySkyDarken(Minecraft mc, Vec3 cameraPos, float original, float partialTicks) {
        WitherStormAmbienceEffects effects = (WitherStormAmbienceEffects)mc.f_91073_.getCapability(WitherStormModClientCapabilities.AMBIENT_EFFECTS).orElse(null);
        if (effects != null) {
            return original * Math.min(effects.lerpAlpha(partialTicks) + 0.4f, 1.0f);
        }
        return original;
    }

    public static Vec3 modifyCloudColors(Minecraft mc, Vec3 cameraPos, Vec3 original, float partialTicks) {
        return WitherStormAmbienceEffects.transitionColor(mc, cameraPos, original, new int[]{28, 10, 27}, 200.0, partialTicks);
    }

    private static Vec3 transitionColor(Minecraft mc, Vec3 cameraPos, Vec3 original, int[] color, double distance, float partialTicks) {
        WitherStormAmbienceEffects effects = (WitherStormAmbienceEffects)mc.f_91073_.getCapability(WitherStormModClientCapabilities.AMBIENT_EFFECTS).orElse(null);
        if (effects != null) {
            float alpha = effects.lerpAlpha(partialTicks);
            double rDelta = original.f_82479_ * 255.0 - (double)color[0];
            double gDelta = original.f_82480_ * 255.0 - (double)color[1];
            double bDelta = original.f_82481_ * 255.0 - (double)color[2];
            color[0] = (int)((double)color[0] + rDelta * (double)alpha);
            color[1] = (int)((double)color[1] + gDelta * (double)alpha);
            color[2] = (int)((double)color[2] + bDelta * (double)alpha);
            return new Vec3((double)color[0] / 255.0, (double)color[1] / 255.0, (double)color[2] / 255.0);
        }
        return original;
    }

    public static class Events {
        @SubscribeEvent
        public static void onWorldTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel level = mc.f_91073_;
                if (level != null && !mc.m_91104_()) {
                    level.getCapability(WitherStormModClientCapabilities.AMBIENT_EFFECTS).ifPresent(WitherStormAmbienceEffects::tick);
                }
            }
        }

        @SubscribeEvent
        public static void fogColor(ViewportEvent.ComputeFogColor event) {
            if (WitherStormModConfig.CLIENT.renderSkyAmbienceEffects.get().booleanValue()) {
                Minecraft mc = Minecraft.m_91087_();
                mc.f_91073_.getCapability(WitherStormModClientCapabilities.AMBIENT_EFFECTS).ifPresent(effects -> {
                    float alpha = effects.lerpAlpha((float)event.getPartialTick());
                    int[] color = new int[]{133, 69, 62};
                    float rDelta = event.getRed() * 255.0f - (float)color[0];
                    float gDelta = event.getGreen() * 255.0f - (float)color[1];
                    float bDelta = event.getBlue() * 255.0f - (float)color[2];
                    color[0] = (int)((float)color[0] + rDelta * alpha);
                    color[1] = (int)((float)color[1] + gDelta * alpha);
                    color[2] = (int)((float)color[2] + bDelta * alpha);
                    event.setRed((float)color[0] / 255.0f);
                    event.setGreen((float)color[1] / 255.0f);
                    event.setBlue((float)color[2] / 255.0f);
                });
            }
        }
    }
}

