/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.capability;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.timings.TimeTracker;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.client.flywheel.FlywheelCompatHandler;
import nonamecrackers2.witherstormmod.client.init.WitherStormModClientCapabilities;
import nonamecrackers2.witherstormmod.client.renderer.entity.AbstractWitherStormRenderer;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.mixin.IMixinGameRenderer;

public class WitherStormDistantRenderer {
    private final Int2ObjectMap<WitherStormEntity> stormsToRender = new Int2ObjectOpenHashMap();
    private final Minecraft minecraft;
    private final EntityRenderDispatcher manager;

    public WitherStormDistantRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.manager = minecraft.m_91290_();
    }

    public WitherStormDistantRenderer() {
        this.minecraft = null;
        this.manager = null;
    }

    public void tick() {
        ClientLevel world = this.minecraft.f_91073_;
        if (world != null) {
            world.m_46473_().m_6180_("distantWitherStorms");
            this.stormsToRender.forEach((id, entity) -> {
                WitherStormEntity storm = entity;
                if (!storm.m_213877_() && !storm.m_20159_()) {
                    this.guardEntityTick(this::tickEntity, storm);
                }
            });
            this.removeAllPendingEntityRemovals();
            world.m_46473_().m_7238_();
        }
    }

    public void tickEntity(WitherStormEntity entity) {
        entity.m_146867_();
        ++entity.f_19797_;
        this.minecraft.f_91073_.m_46473_().m_6521_(() -> ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
        if (entity.canUpdate()) {
            if (entity.f_19853_.m_6815_(entity.m_19879_()) == null) {
                entity.m_8119_();
                WitherStormMod.runIf(WitherStormMod.flywheelLoaded() && WitherStormModConfig.CLIENT.distantRendererInstancing.get() != false, (Supplier<Runnable>)((Supplier)() -> () -> FlywheelCompatHandler.add(entity)));
            } else {
                WitherStormMod.runIf(WitherStormMod.flywheelLoaded() && WitherStormModConfig.CLIENT.distantRendererInstancing.get() != false, (Supplier<Runnable>)((Supplier)() -> () -> FlywheelCompatHandler.remove(entity)));
            }
        }
        this.minecraft.f_91073_.m_46473_().m_7238_();
    }

    public void guardEntityTick(Consumer<WitherStormEntity> consumer, WitherStormEntity entity) {
        try {
            TimeTracker.ENTITY_UPDATE.trackStart((Object)entity);
            consumer.accept(entity);
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.m_127521_((Throwable)t, (String)"Distant Ticking WitherStormEntity");
            CrashReportCategory category = report.m_127514_("Trying to tick distant WitherStormEntity on client");
            entity.m_7976_(category);
            throw new ReportedException(report);
        }
        finally {
            TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity);
        }
    }

    public void removeAllPendingEntityRemovals() {
        ObjectIterator iterator = this.stormsToRender.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            WitherStormEntity entity = (WitherStormEntity)entry.getValue();
            if (!entity.m_213877_()) continue;
            iterator.remove();
            WitherStormMod.runIf(WitherStormMod.flywheelLoaded() && WitherStormModConfig.CLIENT.distantRendererInstancing.get() != false, (Supplier<Runnable>)((Supplier)() -> () -> FlywheelCompatHandler.remove(entity)));
        }
    }

    public void renderTick(PoseStack stack, MultiBufferSource.BufferSource buffer, float partialTicks, Frustum clippinghelper) {
        if (this.minecraft.f_91073_ != null) {
            GameRenderer renderer = this.minecraft.f_91063_;
            Camera renderInfo = renderer.m_109153_();
            boolean distantFog = WitherStormModConfig.CLIENT.distantFog.get();
            Vec3 pos = renderInfo.m_90583_();
            if (distantFog) {
                boolean flag = this.minecraft.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82480_)) || this.minecraft.f_91065_.m_93090_().m_93715_();
                float f = renderer.m_109152_();
                FogRenderer.m_109018_((Camera)renderInfo, (float)partialTicks, (ClientLevel)this.minecraft.f_91073_, (int)((Integer)this.minecraft.f_91066_.m_231984_().m_231551_()), (float)1.0f);
                FogRenderer.m_109036_();
                FogRenderer.m_234172_((Camera)renderInfo, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(f - 16.0f, 32.0f), (boolean)flag, (float)partialTicks);
            }
            this.minecraft.f_91073_.m_46473_().m_6182_("distantWitherStorms");
            for (Int2ObjectMap.Entry entry : this.stormsToRender.int2ObjectEntrySet()) {
                WitherStormEntity entity2 = (WitherStormEntity)entry.getValue();
                if (!this.manager.m_114397_((Entity)entity2, clippinghelper, pos.f_82479_, pos.f_82480_, pos.f_82481_) || this.minecraft.f_91073_.m_6815_(entity2.m_19879_()) != null) continue;
                float f1 = Mth.m_14179_((float)partialTicks, (float)entity2.f_19859_, (float)entity2.m_146908_());
                double x = Mth.m_14139_((double)partialTicks, (double)entity2.f_19790_, (double)entity2.m_20185_());
                double y = Mth.m_14139_((double)partialTicks, (double)entity2.f_19791_, (double)entity2.m_20186_());
                double z = Mth.m_14139_((double)partialTicks, (double)entity2.f_19792_, (double)entity2.m_20189_());
                int packedLight = this.manager.m_114394_((Entity)entity2, partialTicks);
                this.manager.m_114384_((Entity)entity2, x - pos.f_82479_, y - pos.f_82480_, z - pos.f_82481_, f1, partialTicks, stack, (MultiBufferSource)buffer, packedLight);
            }
            this.doRenderAction(clippinghelper, pos, partialTicks, stack, (MultiBufferSource)buffer, (buffer1, entity) -> AbstractWitherStormRenderer.renderExtra(entity, this.manager, stack, buffer1, partialTicks));
            buffer.m_109911_();
            if (distantFog) {
                FogRenderer.m_109017_();
            }
            buffer = this.minecraft.m_91269_().m_110104_();
            this.doRenderAction(clippinghelper, pos, partialTicks, stack, (MultiBufferSource)buffer, (buffer1, entity) -> AbstractWitherStormRenderer.renderTractorBeams(entity, this.manager, stack, buffer1, partialTicks));
        }
    }

    private void doRenderAction(Frustum frustum, Vec3 cameraPos, float partialTicks, PoseStack stack, MultiBufferSource buffer, BiConsumer<MultiBufferSource, WitherStormEntity> action) {
        for (Int2ObjectMap.Entry entry : this.stormsToRender.int2ObjectEntrySet()) {
            WitherStormEntity entity = (WitherStormEntity)entry.getValue();
            if (!this.manager.m_114397_((Entity)entity, frustum, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_) || this.minecraft.f_91073_.m_6815_(entity.m_19879_()) != null) continue;
            double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
            stack.m_85836_();
            stack.m_85837_(x - cameraPos.f_82479_, y - cameraPos.f_82480_, z - cameraPos.f_82481_);
            action.accept(buffer, entity);
            stack.m_85849_();
        }
    }

    public void addWitherStorm(int id, WitherStormEntity entity) {
        this.stormsToRender.put(id, (Object)entity);
        WitherStormMod.runIf(WitherStormMod.flywheelLoaded() && WitherStormModConfig.CLIENT.distantRendererInstancing.get() != false, (Supplier<Runnable>)((Supplier)() -> () -> FlywheelCompatHandler.add(entity)));
    }

    public WitherStormEntity get(int id) {
        return (WitherStormEntity)this.stormsToRender.get(id);
    }

    public boolean contains(int id) {
        return this.stormsToRender.containsKey(id);
    }

    public Iterable<WitherStormEntity> getKnown() {
        return Iterables.unmodifiableIterable((Iterable)this.stormsToRender.values());
    }

    public static List<WitherStormEntity> getAllStorms(ClientLevel level) {
        ArrayList storms = Lists.newArrayList();
        level.m_104735_().forEach(entity -> {
            if (entity instanceof WitherStormEntity) {
                WitherStormEntity storm = (WitherStormEntity)entity;
                storms.add(storm);
            }
        });
        level.getCapability(WitherStormModClientCapabilities.DISTANT_RENDERER).ifPresent(renderer -> {
            List ids = storms.stream().collect(Collectors.mapping(Entity::m_19879_, Collectors.toList()));
            renderer.getKnown().forEach(storm -> {
                if (!ids.contains(storm.m_19879_())) {
                    storms.add(storm);
                }
            });
        });
        return storms;
    }

    public static class Events {
        @SubscribeEvent
        public static void renderTickDistantRenderer(RenderLevelStageEvent event) {
            if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
                Events.render(event.getPoseStack(), event.getPartialTick());
            }
        }

        @SubscribeEvent
        public static void clientTickDistantRenderer(TickEvent.ClientTickEvent event) {
            ClientLevel world;
            Minecraft mc = Minecraft.m_91087_();
            if (event.phase == TickEvent.Phase.START && (world = mc.f_91073_) != null) {
                world.getCapability(WitherStormModClientCapabilities.DISTANT_RENDERER).ifPresent(distantRenderer -> {
                    if (!(mc.m_91104_() && mc.m_91091_() || !WitherStormModConfig.CLIENT.distantRenderer.get().booleanValue())) {
                        distantRenderer.tick();
                    }
                });
            }
        }

        public static void render(PoseStack stack, float partialTicks) {
            if (WitherStormModConfig.CLIENT.distantRenderer.get().booleanValue()) {
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel world = mc.f_91073_;
                world.getCapability(WitherStormModClientCapabilities.DISTANT_RENDERER).ifPresent(distantRenderer -> {
                    Matrix4f originalMatrix = RenderSystem.m_157192_();
                    GameRenderer renderer = mc.f_91063_;
                    Camera renderInfo = renderer.m_109153_();
                    double fov = ((IMixinGameRenderer)renderer).callGetFov(renderInfo, partialTicks, true);
                    Matrix4f projection = Matrix4f.m_27625_((double)fov, (float)((float)mc.m_91268_().m_85441_() / (float)mc.m_91268_().m_85442_()), (float)0.05f, (float)(renderer.m_109152_() * 180.0f));
                    Matrix4f defaultProjection = renderer.m_172716_(fov);
                    Matrix4f invertedDefaultProjection = defaultProjection.m_27658_();
                    invertedDefaultProjection.m_27657_();
                    Matrix4f distortionMatrix = invertedDefaultProjection.m_27658_();
                    distortionMatrix.m_27644_(originalMatrix);
                    projection.m_27644_(distortionMatrix);
                    renderer.m_109111_(projection);
                    Vec3 pos = renderInfo.m_90583_();
                    MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
                    Frustum clippinghelper = new Frustum(stack.m_85850_().m_85861_(), projection);
                    clippinghelper.m_113002_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                    distantRenderer.renderTick(stack, buffer, partialTicks, clippinghelper);
                    buffer.m_109911_();
                    renderer.m_109111_(originalMatrix);
                });
            }
        }
    }
}

