/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.guns.common.Gun;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GunProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Gun> gunMap = new HashMap<ResourceLocation, Gun>();

    protected GunProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerGuns();

    protected final void addGun(ResourceLocation id, Gun gun) {
        this.gunMap.put(id, gun);
    }

    public void m_213708_(CachedOutput cache) {
        this.gunMap.clear();
        this.registerGuns();
        this.gunMap.forEach((id, gun) -> {
            Path path = this.generator.m_123916_().resolve("data/" + id.m_135827_() + "/guns/" + id.m_135815_() + ".json");
            try {
                JsonObject object = gun.toJsonObject();
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)object, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "Guns: cgm";
    }
}

