/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.annotation.Validator;
import com.mrcrayfish.guns.client.util.Easings;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.JsonDeserializers;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.S2CMessageUpdateGuns;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="cgm")
public class NetworkGunManager
extends SimplePreparableReloadListener<Map<GunItem, Gun>> {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        builder.registerTypeAdapter(GripType.class, JsonDeserializers.GRIP_TYPE);
        builder.registerTypeAdapter(Easings.class, JsonDeserializers.EASING);
        builder.excludeFieldsWithModifiers(new int[]{128});
        return builder.create();
    });
    private static List<GunItem> clientRegisteredGuns = new ArrayList<GunItem>();
    private static NetworkGunManager instance;
    private Map<ResourceLocation, Gun> registeredGuns = new HashMap<ResourceLocation, Gun>();

    protected Map<GunItem, Gun> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<GunItem, Gun> map = new HashMap<GunItem, Gun>();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).forEach(item -> {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            if (id != null) {
                ArrayList resources = new ArrayList(manager.m_214159_("guns", fileName -> fileName.m_135815_().endsWith(id.m_135815_() + ".json")).keySet());
                resources.sort((r1, r2) -> {
                    if (r1.m_135827_().equals(r2.m_135827_())) {
                        return 0;
                    }
                    return r2.m_135827_().equals("cgm") ? 1 : -1;
                });
                resources.forEach(resourceLocation -> {
                    String path = resourceLocation.m_135815_().substring(0, resourceLocation.m_135815_().length() - FILE_TYPE_LENGTH_VALUE);
                    String[] splitPath = path.split("/");
                    if (!id.m_135815_().equals(splitPath[splitPath.length - 1])) {
                        return;
                    }
                    if (!id.m_135827_().equals(resourceLocation.m_135827_())) {
                        return;
                    }
                    manager.m_213713_(resourceLocation).ifPresent(resource -> {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8));){
                            Gun gun = (Gun)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, Gun.class);
                            if (gun != null && Validator.isValidObject(gun)) {
                                map.put((GunItem)item, gun);
                            } else {
                                GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default gun data", resourceLocation);
                                map.putIfAbsent((GunItem)item, new Gun());
                            }
                        }
                        catch (InvalidObjectException e) {
                            GunMod.LOGGER.error("Missing required properties for {}", resourceLocation);
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            GunMod.LOGGER.error("Couldn't parse data file {}", resourceLocation);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
        });
        return map;
    }

    protected void apply(Map<GunItem, Gun> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, gun) -> {
            builder.put((Object)Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)), gun);
            item.setGun(new Supplier((Gun)gun));
        });
        this.registeredGuns = builder.build();
    }

    public void writeRegisteredGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredGuns.size());
        this.registeredGuns.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Gun> readRegisteredGuns(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Gun gun = Gun.create(buffer.m_130260_());
                builder.put((Object)id, (Object)gun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredGuns(S2CMessageUpdateGuns message) {
        return NetworkGunManager.updateRegisteredGuns(message.getRegisteredGuns());
    }

    private static boolean updateRegisteredGuns(Map<ResourceLocation, Gun> registeredGuns) {
        clientRegisteredGuns.clear();
        if (registeredGuns != null) {
            for (Map.Entry<ResourceLocation, Gun> entry : registeredGuns.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof GunItem)) {
                    return false;
                }
                ((GunItem)item).setGun(new Supplier(entry.getValue()));
                clientRegisteredGuns.add((GunItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public static List<GunItem> getClientRegisteredGuns() {
        return ImmutableList.copyOf(clientRegisteredGuns);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkGunManager networkGunManager = new NetworkGunManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.getPlayChannel().send(PacketDistributor.ALL.noArg(), (Object)new S2CMessageUpdateGuns());
        }
    }

    @Nullable
    public static NetworkGunManager get() {
        return instance;
    }

    public static class Supplier {
        private Gun gun;

        private Supplier(Gun gun) {
            this.gun = gun;
        }

        public Gun getGun() {
            return this.gun;
        }
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Gun> registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            NetworkGunManager.updateRegisteredGuns(registeredGuns);
            return Optional.empty();
        }
    }
}

