/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.render.crosshair.Crosshair;
import com.mrcrayfish.guns.client.render.crosshair.TechCrosshair;
import com.mrcrayfish.guns.client.render.crosshair.TexturedCrosshair;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.item.GunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class CrosshairHandler {
    private static CrosshairHandler instance;
    private final Map<ResourceLocation, Crosshair> idToCrosshair = new HashMap<ResourceLocation, Crosshair>();
    private final List<Crosshair> registeredCrosshairs = new ArrayList<Crosshair>();
    private Crosshair currentCrosshair = null;

    public static CrosshairHandler get() {
        if (instance == null) {
            instance = new CrosshairHandler();
        }
        return instance;
    }

    private CrosshairHandler() {
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "better_default")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "circle")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "filled_circle"), false));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "square")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "round")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "arrow")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "dot")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "box")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "hit_marker")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "line")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "t")));
        this.register(new TexturedCrosshair(new ResourceLocation("cgm", "smiley")));
        this.register(new TechCrosshair());
    }

    public void register(Crosshair crosshair) {
        if (!this.idToCrosshair.containsKey(crosshair.getLocation())) {
            this.idToCrosshair.put(crosshair.getLocation(), crosshair);
            this.registeredCrosshairs.add(crosshair);
        }
    }

    public void setCrosshair(ResourceLocation id) {
        this.currentCrosshair = this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT);
    }

    @Nullable
    public Crosshair getCurrentCrosshair() {
        if (this.currentCrosshair == null && this.registeredCrosshairs.size() > 0) {
            ResourceLocation id = ResourceLocation.m_135820_((String)((String)Config.CLIENT.display.crosshair.get()));
            this.currentCrosshair = id != null ? this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT) : Crosshair.DEFAULT;
        }
        return this.currentCrosshair;
    }

    public List<Crosshair> getRegisteredCrosshairs() {
        return ImmutableList.copyOf(this.registeredCrosshairs);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (AimingHandler.get().getNormalisedAdsProgress() > 0.5) {
            event.setCanceled(true);
            return;
        }
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        event.setCanceled(true);
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        if (mc.f_91074_.m_21211_().m_41720_() == Items.f_42740_) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        int scaledWidth = event.getWindow().m_85445_();
        int scaledHeight = event.getWindow().m_85446_();
        crosshair.render(mc, stack, scaledWidth, scaledHeight, event.getPartialTick());
        stack.m_85849_();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        crosshair.tick();
    }

    @SubscribeEvent
    public void onGunFired(GunFireEvent.Post event) {
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        crosshair.onGunFired();
    }

    public static void onConfigReload(ModConfigEvent.Reloading event) {
        ResourceLocation id;
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT && config.getModId().equals("cgm") && (id = ResourceLocation.m_135820_((String)((String)Config.CLIENT.display.crosshair.get()))) != null) {
            CrosshairHandler.get().setCrosshair(id);
        }
    }
}

