/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.netherdepthsupgrade.datagen.BlockTagsGenerator;
import com.scouter.netherdepthsupgrade.datagen.BlockstateGenerator;
import com.scouter.netherdepthsupgrade.datagen.EntityTags;
import com.scouter.netherdepthsupgrade.datagen.ItemModelGenerator;
import com.scouter.netherdepthsupgrade.datagen.ItemTagsGenerator;
import com.scouter.netherdepthsupgrade.datagen.LootGenerator;
import com.scouter.netherdepthsupgrade.datagen.NDUBiomeTagsProvider;
import com.scouter.netherdepthsupgrade.datagen.RecipeGenerator;
import com.scouter.netherdepthsupgrade.datagen.SoundsGenerator;
import com.scouter.netherdepthsupgrade.world.feature.NDUConfiguredFeatures;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="netherdepthsupgrade", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
        if (evt.includeClient()) {
            DataGenerators.registerClientProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new LootGenerator(generator));
        generator.m_236039_(true, (DataProvider)new BlockTagsGenerator(generator, helper));
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        BlockTagsGenerator blockTags = new BlockTagsGenerator(generator, helper);
        HashSet set = Sets.newHashSet();
        Consumer<BlockStateGenerator> consumer = set::add;
        generator.m_236039_(true, (DataProvider)new NDUBiomeTagsProvider(generator, helper));
        generator.m_236039_(true, (DataProvider)new EntityTags(generator, helper));
        generator.m_236039_(true, (DataProvider)new RecipeGenerator(generator));
        generator.m_236039_(true, (DataProvider)new BlockstateGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new SoundsGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new ItemTagsGenerator(generator, blockTags, helper));
        generator.m_236039_(true, (DataProvider)new ItemModelGenerator(generator, helper));
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registries);
        JsonCodecProvider configuredFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"netherdepthsupgrade", (RegistryOps)ops, (ResourceKey)Registry.f_122881_, DataGenerators.getConfiguredFeatures((RegistryAccess)registries));
        generator.m_236039_(true, (DataProvider)configuredFeatureProvider);
        JsonCodecProvider placedFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"netherdepthsupgrade", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, DataGenerators.getPlacedFeatures((RegistryAccess)registries));
        generator.m_236039_(true, (DataProvider)placedFeatureProvider);
    }

    public static Map<ResourceLocation, ConfiguredFeature<?, ?>> getConfiguredFeatures(RegistryAccess registries) {
        HashMap map = new HashMap();
        for (int i = 0; i < NDUConfiguredFeatures.configuredFeatureList.size(); ++i) {
            ResourceLocation RL = new ResourceLocation("netherdepthsupgrade", NDUConfiguredFeatures.configuredFeatureList.get(i));
            Registry configuredFeatures = registries.m_175515_(Registry.f_122881_);
            ConfiguredFeature PF = (ConfiguredFeature)configuredFeatures.m_7745_(RL);
            map.put(RL, PF);
        }
        return map;
    }

    public static Map<ResourceLocation, PlacedFeature> getPlacedFeatures(RegistryAccess registries) {
        HashMap<ResourceLocation, PlacedFeature> map = new HashMap<ResourceLocation, PlacedFeature>();
        for (int i = 0; i < NDUConfiguredFeatures.placedFeatureList.size(); ++i) {
            ResourceLocation RL = new ResourceLocation("netherdepthsupgrade", NDUConfiguredFeatures.placedFeatureList.get(i));
            Registry placedFeatures = registries.m_175515_(Registry.f_194567_);
            PlacedFeature PF = (PlacedFeature)placedFeatures.m_7745_(RL);
            map.put(RL, PF);
        }
        return map;
    }
}

