/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.google.common.collect.Lists;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;

public class LavaSpongeBlock
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;

    public LavaSpongeBlock(BlockBehaviour.Properties p_56796_) {
        super(p_56796_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.tryAbsorbLava(pLevel, pPos);
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.tryAbsorbLava(pLevel, pPos);
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    protected void tryAbsorbLava(Level pLevel, BlockPos pPos) {
        if (this.removeLavaBreadthFirstSearch(pLevel, pPos)) {
            pLevel.m_7731_(pPos, ((Block)NDUBlocks.WET_LAVA_SPONGE.get()).m_49966_(), 3);
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)Blocks.f_49991_.m_49966_()));
        }
    }

    private boolean removeLavaBreadthFirstSearch(Level pLevel, BlockPos pPos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pPos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = pLevel.m_8055_(blockpos1);
                FluidState fluidstate = pLevel.m_6425_(blockpos1);
                Material material = blockstate.m_60767_();
                if (!fluidstate.m_205070_(FluidTags.f_13132_)) continue;
                if (blockstate.m_60734_() instanceof BucketPickup && !((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)pLevel, blockpos1, blockstate).m_41619_()) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    pLevel.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.f_76301_ && material != Material.f_76304_) continue;
                BlockEntity blockentity = blockstate.m_155947_() ? pLevel.m_7702_(blockpos1) : null;
                LavaSpongeBlock.m_49892_((BlockState)blockstate, (LevelAccessor)pLevel, (BlockPos)blockpos1, (BlockEntity)blockentity);
                pLevel.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

