/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.registry;

import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import java.util.Locale;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class BrickBuilders {
    public static BlockBuilder<Block, ?> buildBrick(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf, Block::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf)))).tag(new TagKey[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix).defaultLoot().simpleItem();
    }

    public static BlockBuilder<StairBlock, ?> buildBrickStairs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_stairs", props -> new StairBlock(() -> ((Block)Blocks.f_50193_).m_49966_(), props));
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).tag(new TagKey[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Stairs").defaultLoot().simpleItem();
    }

    public static BlockBuilder<SlabBlock, ?> buildBrickSlabs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_slab", SlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + pre + name.toLowerCase(Locale.ROOT) + (String)(suf.equals("") ? "" : "_" + suf)), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new TagKey[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Slab").simpleItem();
    }

    public static BlockBuilder<VerticalSlabBlock, ?> buildBrickVerts(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_slab_vert", VerticalSlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> {
            String texLoc = "block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf;
            ResourceLocation tex = prov.modLoc(texLoc);
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", tex);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", tex);
            int y = 0;
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new TagKey[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Vertical Slab").simpleItem();
    }

    public static BlockBuilder<WallBlock, ?> buildBrickWalls(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String pre = prefix.replace(' ', '_').toLowerCase(Locale.ROOT) + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_wall", WallBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.f_76278_, dye);
        } else {
            ret.initialProperties(Material.f_76278_);
        }
        return (BlockBuilder)ret.properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).tag(new TagKey[]{BlockTags.f_144282_}).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Wall").defaultLoot().tag(new TagKey[]{BlockTags.f_13032_}).item().model((ctx, prov) -> prov.wallInventory("item/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf + "_wall", prov.modLoc("block/palettes/bricks/" + name.toLowerCase(Locale.ROOT) + "/" + pre + name.toLowerCase(Locale.ROOT) + "_" + suf))).build();
    }
}

