/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.covers1624.quack.util.Copyable;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ColUtils {
    public static <T> T[] slice(T[] arr, int from, int until) {
        int low = Math.max(from, 0);
        int high = Math.min(Math.max(until, 0), arr.length);
        int size = Math.max(high - low, 0);
        Object[] result = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        if (size > 0) {
            System.arraycopy(arr, low, result, 0, size);
        }
        return result;
    }

    @Nullable
    public static <T> T maxBy(T[] col, ToIntFunction<T> func) {
        return ColUtils.maxBy(Arrays.asList(col), func);
    }

    @Nullable
    public static <T> T maxBy(Iterable<T> col, ToIntFunction<T> func) {
        int max = Integer.MIN_VALUE;
        T maxT = null;
        for (T t : col) {
            int x = func.applyAsInt(t);
            if (x <= max) continue;
            maxT = t;
            max = x;
        }
        return maxT;
    }

    public static <T> boolean allMatch(T[] col, Predicate<T> func) {
        return ColUtils.allMatch(Arrays.asList(col), func);
    }

    public static <T> boolean allMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (func.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> findFirst(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> headOption(Iterable<T> col) {
        Iterator<T> itr = col.iterator();
        if (itr.hasNext()) {
            return Optional.of(itr.next());
        }
        return Optional.empty();
    }

    public static <T> T head(Iterable<T> col) {
        T head = ColUtils.headOrDefault(col);
        if (head == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return head;
    }

    @Nullable
    public static <T> T headOrDefault(Iterable<T> col) {
        return ColUtils.headOrDefault(col, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T headOrDefault(Iterable<T> col, @Nullable T _default) {
        Iterator<T> itr = col.iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        return _default;
    }

    public static <T> Optional<T> tailOption(Iterable<T> col) {
        Iterator<T> itr = col.iterator();
        Object last = null;
        while (itr.hasNext()) {
            last = itr.next();
        }
        return Optional.ofNullable(last);
    }

    public static <T> T tail(Iterable<T> col) {
        T tail = ColUtils.tailOrDefault(col);
        if (tail == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return tail;
    }

    @Nullable
    public static <T> T tailOrDefault(Iterable<T> col) {
        return ColUtils.tailOrDefault(col, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T tailOrDefault(Iterable<T> col, @Nullable T _default) {
        T last = _default;
        for (T e : col) {
            last = e;
        }
        return last;
    }

    @SafeVarargs
    public static <T> boolean containsKeys(Map<T, ?> map, T ... keys) {
        for (T object : keys) {
            if (map.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] addToArrayFirstNull(T[] array, T value) {
        int nullIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            T v = array[i];
            if (v != null) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == -1) {
            T[] copy = ColUtils.createNewArray(array, array.length + 1);
            System.arraycopy(array, 0, copy, 0, array.length);
            nullIndex = array.length;
            array = copy;
        }
        array[nullIndex] = value;
        return array;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value : array) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int countNonNull(T[] array) {
        return ColUtils.count(array, Objects::nonNull);
    }

    public static <T> int count(T[] array, Function<T, Boolean> check) {
        int counter = 0;
        for (T value : array) {
            if (!check.apply(value).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> T[] fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            T newValue = value;
            if (value instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value);
                newValue = copyable.copy();
            }
            array[i] = newValue;
        }
        return array;
    }

    public static <T> void fillArray(T[] array, T value, Function<T, Boolean> check) {
        for (int i = 0; i < array.length; ++i) {
            if (!check.apply(array[i]).booleanValue()) continue;
            T newValue = value;
            if (value instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value);
                newValue = copyable.copy();
            }
            array[i] = newValue;
        }
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])SneakyUtils.unsafeCast(dst);
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> int indexOf(T[] array, T object) {
        if (object == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!object.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOfRef(T[] array, T object) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] createNewArray(T[] array) {
        return ColUtils.createNewArray(array, array.length);
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        Class newType = (Class)SneakyUtils.unsafeCast(array.getClass());
        Object[] copy = newType.equals(Object[].class) ? (Object[])SneakyUtils.unsafeCast(new Object[length]) : (Object[])SneakyUtils.unsafeCast(ColUtils.newArray(newType.getComponentType(), length));
        return copy;
    }

    public static <T> T[] newArray(Class<T> arrayClass, int length) {
        return (Object[])SneakyUtils.unsafeCast(Array.newInstance(arrayClass, length));
    }

    public static <T> T[] rollArray(T[] input, int shift) {
        T[] newArray = ColUtils.createNewArray(input);
        for (int i = 0; i < input.length; ++i) {
            int newPos = (i + shift) % input.length;
            if (newPos < 0) {
                newPos += input.length;
            }
            newArray[newPos] = input[i];
        }
        return newArray;
    }

    public static <T> boolean contains(T[] input, T element) {
        for (T test : input) {
            if (!Objects.equals(test, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] inverse(T[] input, T[] allElements) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : allElements) {
            if (ColUtils.contains(input, e)) continue;
            list.add(e);
        }
        return list.toArray(ColUtils.createNewArray(input, list.size()));
    }

    public static <T> boolean isNullOrContainsNull(T @Nullable [] input) {
        if (input == null) {
            return true;
        }
        for (T t : input) {
            if (t != null) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> toList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <E> Iterable<E> iterable(Stream<E> stream) {
        return stream::iterator;
    }

    public static <E> Stream<E> stream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), false);
    }

    public static <E> Stream<E> parallelStream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), true);
    }

    @Nullable
    public static <T> T onlyOrDefault(Stream<T> stream) {
        return ColUtils.onlyOrDefault(stream, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T onlyOrDefault(Stream<T> stream, @Nullable T _default) {
        return ColUtils.onlyOrDefault(ColUtils.iterable(stream), _default);
    }

    @Nullable
    public static <T> T onlyOrDefault(Iterable<T> iterable) {
        return ColUtils.onlyOrDefault(iterable, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T onlyOrDefault(Iterable<T> iterable, @Nullable T _default) {
        T thing = _default;
        boolean found = false;
        for (T t : iterable) {
            if (found) {
                return _default;
            }
            found = true;
            thing = t;
        }
        return thing;
    }

    public static <T> T only(Stream<T> stream) {
        return ColUtils.only(ColUtils.iterable(stream));
    }

    public static <T> T only(Iterable<T> iterable) {
        T thing = null;
        boolean found = false;
        for (T t : iterable) {
            if (found) {
                throw new IllegalArgumentException("More than one element.");
            }
            found = true;
            thing = t;
        }
        if (!found) {
            throw new IllegalArgumentException("Not found.");
        }
        return thing;
    }
}

