/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedRecipeBuilder
extends AbstractItemStackRecipeBuilder<ShapedRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final List<String> patternLines = new ArrayList<String>();
    private final Char2ObjectMap<Ingredient> keys = new Char2ObjectOpenHashMap();

    protected ShapedRecipeBuilder(RecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static ShapedRecipeBuilder builder(ItemLike result) {
        return ShapedRecipeBuilder.builder(result, 1);
    }

    public static ShapedRecipeBuilder builder(ItemLike result, int count) {
        return ShapedRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static ShapedRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return ShapedRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static ShapedRecipeBuilder builder(ItemStack result) {
        return ShapedRecipeBuilder.builder(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static ShapedRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new ShapedRecipeBuilder(RecipeSerializer.f_44076_, id, result);
    }

    public ShapedRecipeBuilder key(char key, TagKey<Item> item) {
        this.addAutoCriteria(item);
        return this.keyInternal(key, Ingredient.m_204132_(item));
    }

    public ShapedRecipeBuilder key(char key, ItemLike item) {
        this.addAutoCriteria(item);
        return this.keyInternal(key, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedRecipeBuilder key(char key, Ingredient ingredient) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        return this.keyInternal(key, ingredient);
    }

    private ShapedRecipeBuilder keyInternal(char key, Ingredient ingredient) {
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.keys.put(key, (Object)ingredient);
        return this;
    }

    public ShapedRecipeBuilder patternLine(String patternIn) {
        if (!this.patternLines.isEmpty() && patternIn.length() != this.patternLines.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.patternLines.add(patternIn);
        return this;
    }

    @Override
    public AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe _build() {
        return new FinishedShapedRecipe();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.patternLines.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + this.id + "!", this.created);
        }
        if (this.patternLines.size() == 1 && this.patternLines.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + this.id + " only takes in a single item - should it be a shapeless recipe instead?", this.created);
        }
        CharOpenHashSet chars = new CharOpenHashSet((CharCollection)this.keys.keySet());
        chars.remove(' ');
        for (String line : this.patternLines) {
            for (char c : line.toCharArray()) {
                if (c == ' ') continue;
                if (!this.keys.containsKey(c)) {
                    throw new IllegalStateException("Pattern in recipe " + this.id + " uses undefined symbol '" + c + "'", this.created);
                }
                chars.remove(c);
            }
        }
        if (!chars.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + this.id, this.created);
        }
    }

    public class FinishedShapedRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray pattern = new JsonArray();
            ShapedRecipeBuilder.this.patternLines.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            for (Char2ObjectMap.Entry entry : ShapedRecipeBuilder.this.keys.char2ObjectEntrySet()) {
                key.add(String.valueOf(entry.getCharKey()), ((Ingredient)entry.getValue()).m_43942_());
            }
            json.add("key", (JsonElement)key);
        }
    }
}

