/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.mixin;

import com.google.gson.JsonElement;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerAdvancementManager.class})
public class ServerAdvancementManagerMixin {
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void removeAdvancements(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        HashSet<ResourceLocation> toRemove = new HashSet<ResourceLocation>();
        Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation identifier = iterator.next().getKey();
            if (!identifier.m_135827_().equals("additionaladditions")) continue;
            switch (identifier.m_135815_()) {
                case "obtain_adoghr_disc": {
                    if (Config.getBool(ConfigValues.MUSIC_DISCS)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_chicken_nugget": {
                    if (Config.getBool(ConfigValues.CHICKEN_NUGGET)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_glow_stick": {
                    if (Config.getBool(ConfigValues.GLOW_STICK)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_mysterious_bundle": {
                    if (Config.getBool(ConfigValues.MYSTERIOUS_BUNDLE)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_pocket_jukebox": {
                    if (Config.getBool(ConfigValues.POCKET_JUKEBOX)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_rose_gold": {
                    if (Config.getBool(ConfigValues.ROSE_GOLD)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "obtain_scoped_crossbow": 
                case "shot_self_scoped_crossbow": {
                    if (Config.getBool(ConfigValues.CROSSBOWS)) break;
                    toRemove.add(identifier);
                    break;
                }
                case "use_watering_can": {
                    if (Config.getBool(ConfigValues.WATERING_CAN)) break;
                    toRemove.add(identifier);
                }
            }
        }
        for (ResourceLocation identifier : toRemove) {
            map.remove(identifier);
        }
    }
}

