/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import dqu.additionaladditions.misc.PocketMusicSoundInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PocketJukeboxItem
extends Item {
    public PocketJukeboxItem(Item.Properties settings) {
        super(settings);
    }

    private static String nbtGetDisc(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("musicdisc")) {
            return tag.m_128423_("musicdisc").m_7916_();
        }
        return null;
    }

    private static void nbtRemoveDisc(ItemStack stack) {
        String disc = PocketJukeboxItem.nbtGetDisc(stack);
        if (disc == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("musicdisc");
        stack.m_41751_(tag);
    }

    private static void nbtPutDisc(ItemStack stack, String disc) {
        String currentDisc = PocketJukeboxItem.nbtGetDisc(stack);
        if (currentDisc != null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("musicdisc", disc);
        stack.m_41751_(tag);
    }

    public static boolean hasDisc(ItemStack stack) {
        return PocketJukeboxItem.nbtGetDisc(stack) != null;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (!Config.getBool(ConfigValues.POCKET_JUKEBOX)) {
            return false;
        }
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        Level world = player.f_19853_;
        if (PocketJukeboxItem.nbtGetDisc(stack) == null) {
            ItemStack cursor = cursorStackReference.m_142196_();
            if (cursor.m_41720_() instanceof RecordItem) {
                ResourceLocation id = Registry.f_122827_.m_7981_((Object)cursor.m_41720_());
                RecordItem discItem = (RecordItem)Registry.f_122827_.m_7745_(id);
                PocketJukeboxItem.nbtPutDisc(stack, id.toString());
                cursorStackReference.m_142104_(ItemStack.f_41583_);
                if (world.m_5776_()) {
                    if (PocketMusicSoundInstance.instance != null) {
                        PocketMusicSoundInstance.instance.finish();
                        PocketMusicSoundInstance.instance = null;
                    }
                    PocketMusicSoundInstance.instance = new PocketMusicSoundInstance(discItem.m_43051_(), player, stack, false, 0.8f);
                    PocketMusicSoundInstance.instance.play();
                }
            }
            return true;
        }
        ItemStack cursor = cursorStackReference.m_142196_();
        if (!cursor.m_41619_()) {
            return false;
        }
        String disc = PocketJukeboxItem.nbtGetDisc(stack);
        RecordItem discItem = (RecordItem)Registry.f_122827_.m_7745_(new ResourceLocation(disc));
        ItemStack discStack = new ItemStack((ItemLike)discItem, 1);
        cursorStackReference.m_142104_(discStack);
        if (world.m_5776_() && PocketMusicSoundInstance.instance != null) {
            PocketMusicSoundInstance.instance.finish();
            PocketMusicSoundInstance.instance = null;
        }
        PocketJukeboxItem.nbtRemoveDisc(stack);
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        String disc = PocketJukeboxItem.nbtGetDisc(stack);
        if (disc == null) {
            tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("additionaladditions.gui.pocket_jukebox.tooltip")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        } else {
            Item discItem = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(disc));
            String description = discItem.m_5524_() + ".desc";
            tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents(description)));
        }
    }
}

