/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dqu.additionaladditions.AdditionalRegistry;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class CopperPatinaBlock
extends Block
implements IForgeBlock {
    public static final EnumProperty<RedstoneSide> WIRE_CONNECTION_NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> WIRE_CONNECTION_EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> WIRE_CONNECTION_SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WIRE_CONNECTION_WEST = BlockStateProperties.f_61385_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final Map<Direction, EnumProperty<RedstoneSide>> DIRECTION_TO_WIRE_CONNECTION_PROPERTY = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, WIRE_CONNECTION_NORTH, (Object)Direction.EAST, WIRE_CONNECTION_EAST, (Object)Direction.SOUTH, WIRE_CONNECTION_SOUTH, (Object)Direction.WEST, WIRE_CONNECTION_WEST));
    protected static final int field_31222 = 1;
    protected static final int field_31223 = 3;
    protected static final int field_31224 = 13;
    protected static final int field_31225 = 3;
    protected static final int field_31226 = 13;
    private static final VoxelShape DOT_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> field_24414 = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> field_24415 = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83110_((VoxelShape)field_24414.get(Direction.NORTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.m_83110_((VoxelShape)field_24414.get(Direction.SOUTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.m_83110_((VoxelShape)field_24414.get(Direction.EAST), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.m_83110_((VoxelShape)field_24414.get(Direction.WEST), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES = Maps.newHashMap();
    private static final Vec3[] COLORS = (Vec3[])Util.m_137469_((Object)new Vec3[16], vec3ds -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float g = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float h = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float j = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            vec3ds[i] = new Vec3((double)g, (double)h, (double)j);
        }
    });
    private static final float field_31221 = 0.2f;
    private final BlockState dotState;
    private boolean wiresGivePower = true;

    public CopperPatinaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(WIRE_CONNECTION_NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(WIRE_CONNECTION_EAST, (Comparable)RedstoneSide.NONE)).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WIRE_CONNECTION_WEST, (Comparable)RedstoneSide.NONE)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.dotState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(WIRE_CONNECTION_NORTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WIRE_CONNECTION_EAST, (Comparable)RedstoneSide.SIDE)).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WIRE_CONNECTION_WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockState : this.m_49965_().m_61056_()) {
            if ((Integer)blockState.m_61143_((Property)POWER) != 0) continue;
            SHAPES.put(blockState, this.getShapeForState(blockState));
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return false;
    }

    private VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = DOT_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide wireConnection = (RedstoneSide)state.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
            if (wireConnection == RedstoneSide.SIDE) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)field_24414.get(direction));
                continue;
            }
            if (wireConnection != RedstoneSide.UP) continue;
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)field_24415.get(direction));
        }
        return voxelShape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getPlacementState((BlockGetter)ctx.m_43725_(), this.dotState, ctx.m_8083_());
    }

    private BlockState getPlacementState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean bl7;
        boolean bl = CopperPatinaBlock.isNotConnected(state);
        state = this.method_27843(world, (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)((Integer)state.m_61143_((Property)POWER))), pos);
        if (bl && CopperPatinaBlock.isNotConnected(state)) {
            return state;
        }
        boolean bl2 = ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)).m_61761_();
        boolean bl3 = ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)).m_61761_();
        boolean bl4 = ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)).m_61761_();
        boolean bl5 = ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)).m_61761_();
        boolean bl6 = !bl2 && !bl3;
        boolean bl8 = bl7 = !bl4 && !bl5;
        if (!bl5 && bl6) {
            state = (BlockState)state.m_61124_(WIRE_CONNECTION_WEST, (Comparable)RedstoneSide.SIDE);
        }
        if (!bl4 && bl6) {
            state = (BlockState)state.m_61124_(WIRE_CONNECTION_EAST, (Comparable)RedstoneSide.SIDE);
        }
        if (!bl2 && bl7) {
            state = (BlockState)state.m_61124_(WIRE_CONNECTION_NORTH, (Comparable)RedstoneSide.SIDE);
        }
        if (!bl3 && bl7) {
            state = (BlockState)state.m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)RedstoneSide.SIDE);
        }
        return state;
    }

    private BlockState method_27843(BlockGetter world, BlockState state, BlockPos pos) {
        boolean bl = !world.m_8055_(pos.m_7494_()).m_60796_(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).m_61761_()) continue;
            RedstoneSide wireConnection = this.getRenderConnectionType(world, pos, direction, bl);
            state = (BlockState)state.m_61124_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return state;
        }
        if (direction == Direction.UP) {
            return this.getPlacementState((BlockGetter)world, state, pos);
        }
        RedstoneSide wireConnection = this.getRenderConnectionType((BlockGetter)world, pos, direction);
        return wireConnection.m_61761_() == ((RedstoneSide)state.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).m_61761_() && !CopperPatinaBlock.isFullyConnected(state) ? (BlockState)state.m_61124_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection) : this.getPlacementState((BlockGetter)world, (BlockState)((BlockState)this.dotState.m_61124_((Property)POWER, (Comparable)((Integer)state.m_61143_((Property)POWER)))).m_61124_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection), pos);
    }

    private static boolean isFullyConnected(BlockState state) {
        return ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)).m_61761_() && ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)).m_61761_() && ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)).m_61761_() && ((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)).m_61761_();
    }

    private static boolean isNotConnected(BlockState state) {
        return !((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)).m_61761_() && !((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)).m_61761_() && !((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)).m_61761_() && !((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)).m_61761_();
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int maxUpdateDepth) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide wireConnection = (RedstoneSide)state.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
            if (wireConnection == RedstoneSide.NONE || world.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction)).m_60713_((Block)this)) continue;
            mutable.m_122173_(Direction.DOWN);
            BlockState blockState = world.m_8055_((BlockPos)mutable);
            if (!blockState.m_60713_(Blocks.f_50455_)) {
                BlockPos blockPos = mutable.m_121945_(direction.m_122424_());
                BlockState blockState2 = blockState.m_60728_(direction.m_122424_(), world.m_8055_(blockPos), world, (BlockPos)mutable, blockPos);
                CopperPatinaBlock.m_49908_((BlockState)blockState, (BlockState)blockState2, (LevelAccessor)world, (BlockPos)mutable, (int)flags, (int)maxUpdateDepth);
            }
            mutable.m_122159_((Vec3i)pos, direction).m_122173_(Direction.UP);
            BlockState blockState3 = world.m_8055_((BlockPos)mutable);
            if (blockState3.m_60713_(Blocks.f_50455_)) continue;
            BlockPos blockPos2 = mutable.m_121945_(direction.m_122424_());
            BlockState blockState4 = blockState3.m_60728_(direction.m_122424_(), world.m_8055_(blockPos2), world, (BlockPos)mutable, blockPos2);
            CopperPatinaBlock.m_49908_((BlockState)blockState3, (BlockState)blockState4, (LevelAccessor)world, (BlockPos)mutable, (int)flags, (int)maxUpdateDepth);
        }
    }

    private RedstoneSide getRenderConnectionType(BlockGetter world, BlockPos pos, Direction direction) {
        return this.getRenderConnectionType(world, pos, direction, !world.m_8055_(pos.m_7494_()).m_60796_(world, pos));
    }

    private RedstoneSide getRenderConnectionType(BlockGetter world, BlockPos pos, Direction direction, boolean bl) {
        boolean bl2;
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = world.m_8055_(blockPos);
        if (bl && (bl2 = this.canRunOnTop(world, blockPos, blockState)) && CopperPatinaBlock.connectsTo(world.m_8055_(blockPos.m_7494_()))) {
            if (blockState.m_60783_(world, blockPos, direction.m_122424_())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !CopperPatinaBlock.connectsTo(blockState, direction) && (blockState.m_60796_(world, blockPos) || !CopperPatinaBlock.connectsTo(world.m_8055_(blockPos.m_7495_()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (!Config.getBool(ConfigValues.COPPER_PATINA)) {
            return false;
        }
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        return this.canRunOnTop((BlockGetter)world, blockPos, blockState);
    }

    private boolean canRunOnTop(BlockGetter world, BlockPos pos, BlockState floor) {
        return floor.m_60783_(world, pos, Direction.UP) || floor.m_60713_(Blocks.f_50332_);
    }

    private void update(Level world, BlockPos pos, BlockState state) {
        int i = this.getReceivedRedstonePower(world, pos);
        if (!Config.getBool(ConfigValues.COPPER_PATINA)) {
            i = 0;
        }
        if ((Integer)state.m_61143_((Property)POWER) != i) {
            if (world.m_8055_(pos) == state) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.m_121945_(direction));
            }
            for (BlockPos blockPos : set) {
                world.m_46672_(blockPos, (Block)this);
            }
        }
    }

    private int getReceivedRedstonePower(Level world, BlockPos pos) {
        this.wiresGivePower = false;
        int i = 0;
        for (Direction dir : f_60441_) {
            BlockPos posi = pos.m_121945_(dir);
            BlockState state = world.m_8055_(posi);
            int j = 0;
            if (!state.m_60713_(Blocks.f_50088_)) {
                j = world.m_46681_(posi, dir);
            }
            if (j >= 15) {
                i = 15;
                break;
            }
            if (j <= i) continue;
            i = j;
        }
        this.wiresGivePower = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos = pos.m_121945_(direction);
                BlockState blockState = world.m_8055_(blockPos);
                j = Math.max(j, this.increasePower(blockState));
                BlockPos blockPos2 = pos.m_7494_();
                if (blockState.m_60796_((BlockGetter)world, blockPos) && !world.m_8055_(blockPos2).m_60796_((BlockGetter)world, blockPos2)) {
                    j = Math.max(j, this.increasePower(world.m_8055_(blockPos.m_7494_())));
                    continue;
                }
                if (blockState.m_60796_((BlockGetter)world, blockPos)) continue;
                j = Math.max(j, this.increasePower(world.m_8055_(blockPos.m_7495_())));
            }
            return Math.max(i, j - 2);
        }
        return Math.max(i, j - 2);
    }

    private int increasePower(BlockState state) {
        return state.m_60713_((Block)AdditionalRegistry.COPPER_PATINA.get()) ? (Integer)state.m_61143_((Property)POWER) : 0;
    }

    private void updateNeighbors(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60713_((Block)this)) {
            world.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                world.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.m_60713_(state.m_60734_()) && !world.f_46443_) {
            this.update(world, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            this.updateOffsetNeighbors(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, moved);
            if (!world.f_46443_) {
                for (Direction direction : Direction.values()) {
                    world.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.update(world, pos, state);
                this.updateOffsetNeighbors(world, pos);
            }
        }
    }

    private void updateOffsetNeighbors(Level world, BlockPos pos) {
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            this.updateNeighbors(world, pos.m_121945_(direction2));
        }
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.m_121945_(direction2);
            if (world.m_8055_(blockPos).m_60796_((BlockGetter)world, blockPos)) {
                this.updateNeighbors(world, blockPos.m_7494_());
                continue;
            }
            this.updateNeighbors(world, blockPos.m_7495_());
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.f_46443_) {
            if (state.m_60710_((LevelReader)world, pos)) {
                this.update(world, pos, state);
            } else {
                CopperPatinaBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_7471_(pos, false);
            }
        }
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.wiresGivePower && !state.m_60713_(Blocks.f_50088_) ? state.m_60746_(world, pos, direction) : 0;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (this.wiresGivePower && direction != Direction.DOWN) {
            int i = (Integer)state.m_61143_((Property)POWER);
            if (i == 0 || state.m_60713_(Blocks.f_50088_)) {
                return 0;
            }
            return direction != Direction.UP && !((RedstoneSide)this.getPlacementState(world, state, pos).m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction.m_122424_()))).m_61761_() ? 0 : i;
        }
        return 0;
    }

    protected static boolean connectsTo(BlockState state) {
        return CopperPatinaBlock.connectsTo(state, null);
    }

    protected static boolean connectsTo(BlockState state, @Nullable Direction dir) {
        if (state.m_60713_((Block)AdditionalRegistry.COPPER_PATINA.get())) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50088_)) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50146_)) {
            Direction direction = (Direction)state.m_61143_((Property)RepeaterBlock.f_54117_);
            return direction == dir || direction.m_122424_() == dir;
        }
        if (state.m_60713_(Blocks.f_50455_)) {
            return dir == state.m_61143_((Property)ObserverBlock.f_52588_);
        }
        return state.m_60803_() && dir != null;
    }

    public boolean m_7899_(BlockState state) {
        return this.wiresGivePower;
    }

    public static int getWireColor(int powerLevel) {
        Vec3 vec3d = COLORS[powerLevel];
        return Mth.m_14159_((float)((float)vec3d.m_7096_()), (float)((float)vec3d.m_7098_()), (float)((float)vec3d.m_7094_()));
    }

    private void addPoweredParticles(Level world, Random random, BlockPos pos, Vec3 color, Direction direction, Direction direction2, float f, float g) {
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide wireConnection = (RedstoneSide)state.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
                switch (wireConnection) {
                    case UP: {
                        this.addPoweredParticles(world, random, pos, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.addPoweredParticles(world, random, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.addPoweredParticles(world, random, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WIRE_CONNECTION_NORTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)))).m_61124_(WIRE_CONNECTION_EAST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)))).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)))).m_61124_(WIRE_CONNECTION_WEST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WIRE_CONNECTION_NORTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)))).m_61124_(WIRE_CONNECTION_EAST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)))).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)))).m_61124_(WIRE_CONNECTION_WEST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WIRE_CONNECTION_NORTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)))).m_61124_(WIRE_CONNECTION_EAST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)))).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)))).m_61124_(WIRE_CONNECTION_WEST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(WIRE_CONNECTION_NORTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_SOUTH)))).m_61124_(WIRE_CONNECTION_SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(WIRE_CONNECTION_EAST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_WEST)))).m_61124_(WIRE_CONNECTION_WEST, (Comparable)((RedstoneSide)state.m_61143_(WIRE_CONNECTION_EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WIRE_CONNECTION_NORTH, WIRE_CONNECTION_EAST, WIRE_CONNECTION_SOUTH, WIRE_CONNECTION_WEST, POWER});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        if (CopperPatinaBlock.isFullyConnected(state) || CopperPatinaBlock.isNotConnected(state)) {
            BlockState blockState = CopperPatinaBlock.isFullyConnected(state) ? this.m_49966_() : this.dotState;
            blockState = (BlockState)blockState.m_61124_((Property)POWER, (Comparable)((Integer)state.m_61143_((Property)POWER)));
            if ((blockState = this.getPlacementState((BlockGetter)world, blockState, pos)) != state) {
                world.m_7731_(pos, blockState, 3);
                this.updateForNewState(world, pos, state, blockState);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updateForNewState(Level world, BlockPos pos, BlockState oldState, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.m_121945_(direction);
            if (((RedstoneSide)oldState.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).m_61761_() == ((RedstoneSide)newState.m_61143_((Property)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).m_61761_() || !world.m_8055_(blockPos).m_60796_((BlockGetter)world, blockPos)) continue;
            world.m_46590_(blockPos, newState.m_60734_(), direction.m_122424_());
        }
    }
}

