/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.client.ClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;

public class ToolBeltLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private static final ResourceLocation TEXTURE_BELT_DYED = ToolBelt.location("textures/entity/dyed_belt.png");
    private final BeltModel<T> beltModel = new BeltModel(Minecraft.m_91087_().m_167973_().m_171103_(ClientEvents.BELT_LAYER));

    public ToolBeltLayer(RenderLayerParent<T, M> owner) {
        super(owner);
    }

    private void translateToBody(LivingEntity entity, PoseStack poseStack) {
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        if (entity.m_6162_() && !(entity instanceof Villager)) {
            poseStack.m_85841_(0.52f, 0.52f, 0.52f);
            poseStack.m_85837_(0.0, 1.4, 0.0);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        BeltFinder.findBelt(entity, true).ifPresent(getter -> {
            if (getter.isHidden()) {
                return;
            }
            ItemStack stack = getter.getBelt();
            matrixStack.m_85836_();
            this.translateToBody((LivingEntity)entity, matrixStack);
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(cap -> {
                ItemStack rightItem;
                boolean rightHanded = entity.m_5737_() == HumanoidArm.RIGHT;
                ItemStack firstItem = cap.getStackInSlot(0);
                ItemStack secondItem = cap.getStackInSlot(1);
                ItemStack leftItem = rightHanded ? firstItem : secondItem;
                ItemStack itemStack = rightItem = rightHanded ? secondItem : firstItem;
                if (!leftItem.m_41619_() || !rightItem.m_41619_()) {
                    matrixStack.m_85836_();
                    if (((HumanoidModel)this.m_117386_()).f_102610_) {
                        matrixStack.m_85837_(0.0, 0.75, 0.0);
                        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                    }
                    ToolBeltLayer.renderHeldItem(entity, rightItem, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStack, buffer, lightness);
                    ToolBeltLayer.renderHeldItem(entity, leftItem, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStack, buffer, lightness);
                    matrixStack.m_85849_();
                }
            });
            matrixStack.m_85837_(0.0, (double)0.19f, 0.0);
            matrixStack.m_85841_(0.85f, 0.6f, 0.78f);
            Item patt4451$temp = stack.m_41720_();
            if (patt4451$temp instanceof ToolBeltItem) {
                ToolBeltItem beltItem = (ToolBeltItem)patt4451$temp;
                this.beltModel.hasColor = beltItem.m_41113_(stack);
                if (this.beltModel.hasColor) {
                    int dyeColor = beltItem.m_41121_(stack);
                    this.beltModel.dyeRed = (float)FastColor.ARGB32.m_13665_((int)dyeColor) / 255.0f;
                    this.beltModel.dyeGreen = (float)FastColor.ARGB32.m_13667_((int)dyeColor) / 255.0f;
                    this.beltModel.dyeBlue = (float)FastColor.ARGB32.m_13669_((int)dyeColor) / 255.0f;
                }
            }
            ToolBeltLayer.m_117376_(this.beltModel, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85849_();
        });
    }

    private static void renderHeldItem(LivingEntity player, ItemStack stack, ItemTransforms.TransformType transformType, HumanoidArm handSide, PoseStack matrixStack, MultiBufferSource buffer, int lightness) {
        if (stack.m_41619_()) {
            return;
        }
        matrixStack.m_85836_();
        if (handSide == HumanoidArm.LEFT) {
            matrixStack.m_85837_((double)-0.271875f, (double)0.7f, (double)-0.1f);
        } else {
            matrixStack.m_85837_((double)0.271875f, (double)0.7f, (double)-0.1f);
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(40.0f));
        float scale = ConfigData.beltItemScale;
        matrixStack.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91290_().m_234586_().m_109322_(player, stack, transformType, handSide == HumanoidArm.LEFT, matrixStack, buffer, lightness);
        matrixStack.m_85849_();
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return BeltFinder.findBelt(pEntity, true).map(getter -> {
            ToolBeltItem beltItem;
            ItemStack stack = getter.getBelt();
            Item patt6346$temp = stack.m_41720_();
            return patt6346$temp instanceof ToolBeltItem && (beltItem = (ToolBeltItem)patt6346$temp).m_41113_(stack) ? TEXTURE_BELT_DYED : TEXTURE_BELT;
        }).orElse(TEXTURE_BELT);
    }

    public static class BeltModel<T extends LivingEntity>
    extends EntityModel<T> {
        private static final String BELT = "belt";
        private static final String BUCKLE = "buckle";
        private static final String LEFT_POCKET = "left_pocket";
        private static final String RIGHT_POCKET = "right_pocket";
        private final ModelPart belt;
        private final ModelPart buckle;
        private final ModelPart left_pocket;
        private final ModelPart right_pocket;
        public boolean hasColor;
        public float dyeRed;
        public float dyeGreen;
        public float dyeBlue;

        public BeltModel(ModelPart part) {
            super(RenderType::m_110458_);
            this.belt = part.m_171324_(BELT);
            this.buckle = part.m_171324_(BUCKLE);
            this.left_pocket = part.m_171324_(LEFT_POCKET);
            this.right_pocket = part.m_171324_(RIGHT_POCKET);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            partdefinition.m_171599_(BELT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, 10.0f, -3.0f, 10.0f, 4.0f, 6.0f), PartPose.f_171404_);
            partdefinition.m_171599_(BUCKLE, CubeListBuilder.m_171558_().m_171514_(10, 10).m_171481_(-2.5f, 9.5f, -3.5f, 5.0f, 5.0f, 1.0f), PartPose.f_171404_);
            partdefinition.m_171599_(LEFT_POCKET, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)-90.0f, (float)0.0f));
            partdefinition.m_171599_(RIGHT_POCKET, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)90.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void m_7695_(PoseStack matrixStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            float cRed = red;
            float cGreen = green;
            float cBlue = blue;
            if (this.hasColor) {
                cRed *= this.dyeRed;
                cGreen *= this.dyeGreen;
                cBlue *= this.dyeBlue;
            }
            this.belt.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            this.left_pocket.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            this.right_pocket.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, cRed, cGreen, cBlue, alpha);
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.8f, 1.0f, 1.0f);
            this.buckle.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }

        public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        }
    }
}

