/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.knightquest.entity;

import javax.annotation.Nullable;
import net.mcreator.knightquest.init.KnightQuestModEntities;
import net.mcreator.knightquest.init.KnightQuestModItems;
import net.mcreator.knightquest.procedures.KqFishmanConvertProcedure;
import net.mcreator.knightquest.procedures.KqFishmanOnInitialEntitySpawnProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KqFishmanEntity
extends Monster
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private long lastSwing;
    public String animationprocedure = "empty";

    public KqFishmanEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KqFishmanEntity>)((EntityType)KnightQuestModEntities.KQ_FISHMAN.get()), world);
    }

    public KqFishmanEntity(EntityType<KqFishmanEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)KnightQuestModItems.KQ_FISHBONES.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)KnightQuestModItems.KQ_FISHBONES.get()));
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (KqFishmanEntity.this.m_20069_()) {
                    KqFishmanEntity.this.m_20256_(KqFishmanEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !KqFishmanEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - KqFishmanEntity.this.m_20185_();
                    double dy = this.f_24976_ - KqFishmanEntity.this.m_20186_();
                    double dz = this.f_24977_ - KqFishmanEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * KqFishmanEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    KqFishmanEntity.this.m_146922_(this.m_24991_(KqFishmanEntity.this.m_146908_(), f, 10.0f));
                    KqFishmanEntity.this.f_20883_ = KqFishmanEntity.this.m_146908_();
                    KqFishmanEntity.this.f_20885_ = KqFishmanEntity.this.m_146908_();
                    if (KqFishmanEntity.this.m_20069_()) {
                        KqFishmanEntity.this.m_7910_((float)KqFishmanEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        KqFishmanEntity.this.m_146926_(this.m_24991_(KqFishmanEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(KqFishmanEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        KqFishmanEntity.this.m_21564_(f3 * f1);
                        KqFishmanEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        KqFishmanEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    KqFishmanEntity.this.m_7910_(0.0f);
                    KqFishmanEntity.this.m_21567_(0.0f);
                    KqFishmanEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 10.0, false){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 6.0, 40));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)KnightQuestModItems.KQ_FISHBONES.get()));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.drowned.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.drowned.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.drowned.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        KqFishmanOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.m_20185_(), this.m_20186_(), this.m_20189_());
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        KqFishmanConvertProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
        return builder;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure == "empty") {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_21224_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            if (this.m_20072_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_6144_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sneak", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_20142_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sprint", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState attackingPredicate(AnimationEvent<E> event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.f_19853_.m_46467_();
        }
        if (this.swinging && this.lastSwing + 15L <= this.f_19853_.m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        if (this.animationprocedure != "empty" && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                this.animationprocedure = "empty";
                event.getController().markNeedsReload();
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attacking", 4.0f, this::attackingPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

