/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public abstract class DelayedBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    public DelayedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final DelayedBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    @Override
    protected final void m_6735_(ServerLevel level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.m_6735_(level, entity, gameTime);
        } else {
            super.m_6735_(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
    }

    @Override
    protected final void m_6732_(ServerLevel level, E entity, long gameTime) {
        super.m_6732_(level, entity, gameTime);
        this.delayFinishedAt = 0L;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= ((LivingEntity)entity).f_19853_.m_46467_();
    }

    @Override
    protected final void m_6725_(ServerLevel level, E entity, long gameTime) {
        super.m_6725_(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

