/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.network;

import io.netty.channel.ChannelHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.magistu.siegemachines.entity.machine.Machine;

@ChannelHandler.Sharable
public class PacketMachineUseRealise {
    private final int entityid;

    public PacketMachineUseRealise(int entityid) {
        this.entityid = entityid;
    }

    public static PacketMachineUseRealise read(FriendlyByteBuf buf) {
        return new PacketMachineUseRealise(buf.readInt());
    }

    public static void write(PacketMachineUseRealise message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(PacketMachineUseRealise packet) {
        PacketMachineUseRealise.handleEachSide(packet, (Player)Minecraft.m_91087_().f_91074_);
    }

    public static void handleEachSide(PacketMachineUseRealise packet, Player player) {
        if (packet == null || player == null || player.f_19853_ == null) {
            return;
        }
        Entity entity = player.f_19853_.m_6815_(packet.entityid);
        if (!(entity instanceof Machine)) {
            return;
        }
        Machine machine = (Machine)entity;
        machine.useRealise();
    }

    public static class Handler {
        public static void handle(PacketMachineUseRealise packet, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                context.enqueueWork(() -> PacketMachineUseRealise.handleEachSide(packet, (Player)context.getSender()));
            } else if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                context.enqueueWork(() -> PacketMachineUseRealise.handleClientSide(packet));
            }
            context.setPacketHandled(true);
        }
    }
}

