/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.ProjectileBuilder;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class MachineItem
extends Item
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final String entitykey;
    private final String typekey;

    public MachineItem(Item.Properties prop, String entitykey, String typekey) {
        super(prop.m_41487_(1));
        this.entitykey = entitykey;
        this.typekey = typekey;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        ProjectileBuilder[] ammo = MachineType.valueOf((String)this.typekey).ammo;
        if (ammo.length > 0) {
            tooltip.add((Component)Component.m_237115_((String)"siegemachines.ammo").m_130940_(ChatFormatting.BLUE));
            for (ProjectileBuilder builder : ammo) {
                if (MachineType.valueOf((String)this.typekey).usesgunpowder) {
                    tooltip.add((Component)Component.m_237115_((String)"siegemachines.uses_gunpowder").m_130940_(ChatFormatting.BLUE));
                }
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)builder.item.m_5524_())).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext p_195939_1_) {
        BlockEntity tileentity;
        Level world = p_195939_1_.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = p_195939_1_.m_43722_();
        BlockPos blockpos = p_195939_1_.m_8083_();
        Direction direction = p_195939_1_.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (tileentity = world.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            BaseSpawner abstractspawner = ((SpawnerBlockEntity)tileentity).m_59801_();
            EntityType<?> entitytype1 = this.getType(itemstack.m_41783_());
            abstractspawner.m_45462_(entitytype1);
            tileentity.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType<?> entitytype = this.getType(itemstack.m_41783_());
        Entity entity = this.spawn(entitytype, (ServerLevel)world, itemstack, p_195939_1_.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP, p_195939_1_.m_7074_());
        if (entity instanceof Machine) {
            ((Machine)entity).deploymentticks = 200;
        }
        if (entity != null) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    protected static double getYOffset(LevelReader p_208051_0_, BlockPos p_208051_1_, boolean p_208051_2_, AABB p_208051_3_) {
        AABB axisalignedbb = new AABB(p_208051_1_);
        if (p_208051_2_) {
            axisalignedbb = axisalignedbb.m_82363_(0.0, -1.0, 0.0);
        }
        Iterable iterable = p_208051_0_.m_186431_(null, axisalignedbb);
        return 1.0 + Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)p_208051_3_, (Iterable)iterable, (double)(p_208051_2_ ? -2.0 : -1.0));
    }

    @Nullable
    public Entity spawn(EntityType<?> entitytype, ServerLevel p_220331_1_, @Nullable ItemStack p_220331_2_, @Nullable Player p_220331_3_, BlockPos p_220331_4_, MobSpawnType p_220331_5_, boolean p_220331_6_, boolean p_220331_7_, float yaw) {
        return this.spawn(entitytype, p_220331_1_, p_220331_2_ == null ? null : p_220331_2_.m_41783_(), p_220331_2_ != null && p_220331_2_.m_41788_() ? p_220331_2_.m_41786_() : null, p_220331_3_, p_220331_4_, p_220331_5_, p_220331_6_, p_220331_7_, yaw);
    }

    @Nullable
    public Entity spawn(EntityType<?> entitytype, ServerLevel p_20601_, @Nullable CompoundTag p_20602_, @Nullable Component p_20603_, @Nullable Player p_20604_, BlockPos p_20605_, MobSpawnType p_20606_, boolean p_20607_, boolean p_20608_, float yaw) {
        Entity t = this.create(entitytype, p_20601_, p_20602_, p_20603_, p_20604_, p_20605_, p_20606_, p_20607_, p_20608_, yaw);
        if (t != null) {
            if (t instanceof Mob && ForgeEventFactory.doSpecialSpawn((Mob)((Mob)t), (LevelAccessor)p_20601_, (float)p_20605_.m_123341_(), (float)p_20605_.m_123342_(), (float)p_20605_.m_123343_(), null, (MobSpawnType)p_20606_)) {
                return null;
            }
            p_20601_.m_47205_(t);
        }
        return t;
    }

    @Nullable
    public Entity create(EntityType<?> entitytype, ServerLevel p_20656_, @Nullable CompoundTag p_20657_, @Nullable Component p_20658_, @Nullable Player p_20659_, BlockPos p_20660_, MobSpawnType p_20661_, boolean p_20662_, boolean p_20663_, float yaw) {
        double d0;
        Entity t = entitytype.m_20615_((Level)p_20656_);
        if (t == null) {
            return null;
        }
        if (p_20662_) {
            t.m_6034_((double)p_20660_.m_123341_() + 0.5, (double)(p_20660_.m_123342_() + 1), (double)p_20660_.m_123343_() + 0.5);
            d0 = MachineItem.getYOffset((LevelReader)p_20656_, p_20660_, p_20663_, t.m_20191_());
        } else {
            d0 = 0.0;
        }
        t.m_7678_((double)p_20660_.m_123341_() + 0.5, (double)p_20660_.m_123342_() + d0, (double)p_20660_.m_123343_() + 0.5, Mth.m_14177_((float)yaw), 0.0f);
        if (t instanceof Mob) {
            Mob mobentity = (Mob)t;
            mobentity.f_20885_ = mobentity.m_146908_();
            mobentity.f_20883_ = mobentity.m_146908_();
            mobentity.m_6518_((ServerLevelAccessor)p_20656_, p_20656_.m_6436_(mobentity.m_20183_()), p_20661_, (SpawnGroupData)null, p_20657_);
            mobentity.m_8032_();
        }
        return t;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult raytraceresult = MachineItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.m_82425_();
        if (!(level.m_8055_(blockpos).m_60734_() instanceof IFluidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.m_41783_());
            Entity entity = this.spawn(entitytype, (ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false, player.m_146908_());
            if (entity instanceof Machine) {
                ((Machine)entity).deploymentticks = 200;
            }
            if (entity != null) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public abstract EntityType<?> getType();

    public EntityType<?> getType(@Nullable CompoundTag nbt) {
        CompoundTag compoundnbt;
        EntityType<?> defaulttype = this.getType();
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (compoundnbt = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)compoundnbt.m_128461_("id")).orElse(defaulttype);
        }
        return defaulttype;
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

