/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import com.mojang.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.item.ModItems;

public abstract class Missile
extends ThrowableItemProjectile {
    public MissileType f_19847_ = MissileType.STONE;
    public Item item = (Item)ModItems.STONE.get();

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity entity, MissileType type, Item item) {
        super(entitytype, entity, level);
        this.f_19847_ = type;
        this.item = item;
        this.m_6034_(pos.f_86214_, pos.f_86215_, pos.f_86216_);
    }

    @NotNull
    public Item m_7881_() {
        return this.item;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6532_(HitResult result) {
        float f = 2.0f;
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityRTR = (EntityHitResult)result;
            Vec3 pos = entityRTR.m_82450_();
            Entity entity = entityRTR.m_82443_();
            float damage = this.f_19847_.mass * (float)this.m_20184_().m_82553_();
            DamageSource damagesource = DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_());
            if (this.f_19847_.armorpiercing >= 1.0f) {
                damagesource = damagesource.m_19380_();
            } else if (this.f_19847_.armorpiercing > 0.0f && entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingentity = (LivingEntity)entity;
                if (livingentity instanceof Player && (player = (Player)livingentity).m_21254_() && (this.item == ModItems.GIANT_ARROW.get() || this.item == Items.f_42412_) && (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ShieldItem || player.m_21254_() && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem)) {
                    return;
                }
                damage -= (1.0f - this.f_19847_.armorpiercing) * (damage - CombatRules.m_19272_((float)damage, (float)0.0f, (float)0.0f));
                damagesource = damagesource.m_19380_();
            }
            if (!this.f_19853_.m_5776_() && this.f_19847_.explosive) {
                this.f_19853_.m_46511_(this.m_37282_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 3.0f, Explosion.BlockInteraction.NONE);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            entity.m_6469_(damagesource, damage);
            Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_19847_.knockback * 0.6);
            if (vector3d.m_82556_() > 0.0) {
                entity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            boolean smoothimpact;
            BlockHitResult blockRTR = (BlockHitResult)result;
            BlockPos blockpos = blockRTR.m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            boolean bl = smoothimpact = (blockstate == Blocks.f_49992_.m_49966_() || blockstate == Blocks.f_49993_.m_49966_() || blockstate == Blocks.f_50493_.m_49966_() || blockstate == Blocks.f_50440_.m_49966_() || blockstate == Blocks.f_152481_.m_49966_() || blockstate == Blocks.f_50546_.m_49966_() || blockstate == Blocks.f_50127_.m_49966_()) && blockRTR.m_82434_() == Direction.UP;
            if (blockRTR.m_82434_() == Direction.UP) {
                if (this.f_19847_.explosive) {
                    int r = 0;
                    while ((float)r < this.f_19847_.explosionradius) {
                        float a = 0.0f;
                        while ((double)a < Math.PI * 2) {
                            BlockPos pos = blockRTR.m_82425_().m_7637_((double)r * Math.cos(a), 0.0, (double)(-r) * Math.sin(a));
                            if (this.f_19853_.m_8055_(pos) == Blocks.f_50440_.m_49966_()) {
                                this.f_19853_.m_46597_(pos, Blocks.f_50493_.m_49966_());
                            }
                            a = (float)((double)a + 0.7853981633974483);
                        }
                        ++r;
                    }
                }
                if (!this.f_19853_.m_5776_()) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    if (smoothimpact && this.f_19847_.explosive) {
                        this.f_19853_.m_46511_(this.m_37282_(), (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.f_19847_.explosionradius * f, Explosion.BlockInteraction.NONE);
                    }
                } else if (smoothimpact) {
                    this.dustExplosion((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), blockpos, this.f_19847_.explosionradius / 2.0f, 50);
                }
            }
            if (!this.f_19853_.m_5776_() && !smoothimpact && this.f_19847_.explosive) {
                this.f_19853_.m_46511_(this.m_37282_(), (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.f_19847_.explosionradius * f, Explosion.BlockInteraction.BREAK);
            }
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            this.f_19853_.m_5594_((Player)this.m_37282_(), this.m_20097_(), SoundEvents.f_11664_, SoundSource.AMBIENT, 1.0f, 1.0f);
            if (!this.f_19853_.m_5776_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void dustExplosion(ParticleOptions particle, BlockPos blockpos, double speed, int amount) {
        this.dustExplosion(particle, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), speed, amount);
    }

    private void dustExplosion(ParticleOptions particle, double x, double y, double z, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 movement = this.m_20184_();
            double d0 = x - 0.05 + this.f_19853_.f_46441_.m_188500_() * 0.3;
            double d1 = y + 1.0;
            double d2 = z - 0.05 + this.f_19853_.f_46441_.m_188500_() * 0.3;
            double d3 = movement.f_82479_ * this.f_19853_.f_46441_.m_188500_() * speed;
            double d4 = -movement.f_82480_ * this.f_19853_.f_46441_.m_188500_() * speed * 10.0;
            double d5 = movement.f_82481_ * this.f_19853_.f_46441_.m_188500_() * speed;
            this.f_19853_.m_7106_(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_8119_() {
        if (this.f_19847_.flighttype == FlightType.SPINNING) {
            this.m_146926_(this.m_146909_() + 0.5f);
        }
        super.m_8119_();
    }
}

