/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import ru.magistu.siegemachines.client.SoundTypes;
import ru.magistu.siegemachines.entity.machine.MachinePartEntity;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.ShootingMachine;
import ru.magistu.siegemachines.gui.machine.crosshair.Crosshair;
import ru.magistu.siegemachines.gui.machine.crosshair.ReloadingCrosshair;
import ru.magistu.siegemachines.item.ModItems;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Trebuchet
extends ShootingMachine
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    static AnimationBuilder SHOOTING_ANIM = new AnimationBuilder().addAnimation("Shooting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    static AnimationBuilder RELOADING_ANIM = new AnimationBuilder().addAnimation("Reloading", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    static AnimationBuilder IDLE_RELOADED_ANIM = new AnimationBuilder().addAnimation("IdleReloaded", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    static AnimationBuilder IDLE_NOT_RELOADED_ANIM = new AnimationBuilder().addAnimation("IdleNotReloaded", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final MachinePartEntity[] subentities;
    private final MachinePartEntity backside;
    private final Vec3 backsidepos;
    public State state = State.RELOADING;

    public Trebuchet(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.TREBUCHET);
        this.backside = new MachinePartEntity(this, "backside", 5.0f, 2.0f);
        this.backsidepos = new Vec3(0.0, 0.0, -85.0).m_82490_(0.0625);
        this.subentities = new MachinePartEntity[]{this.backside};
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        switch (this.state) {
            case SHOOTING: {
                event.getController().setAnimation(SHOOTING_ANIM);
                return PlayState.CONTINUE;
            }
            case IDLE_RELOADED: {
                event.getController().setAnimation(IDLE_RELOADED_ANIM);
                return PlayState.CONTINUE;
            }
            case RELOADING: {
                event.getController().setAnimation(RELOADING_ANIM);
                return PlayState.CONTINUE;
            }
            case IDLE_NOT_RELOADED: {
                event.getController().setAnimation(IDLE_NOT_RELOADED_ANIM);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    private void tickPart(MachinePartEntity subentity, double p_226526_2_, double p_226526_4_, double p_226526_6_) {
        subentity.m_6034_(this.m_20185_() + p_226526_2_, this.m_20186_() + p_226526_4_, this.m_20189_() + p_226526_6_);
    }

    public void m_8107_() {
        int i;
        Vec3[] avector3d = new Vec3[this.subentities.length];
        Vec3 pos = this.m_20182_().m_82549_(Trebuchet.applyRotations(this.backsidepos, 0.0, this.getYaw()));
        this.tickPart(this.backside, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        for (i = 0; i < this.subentities.length; ++i) {
            avector3d[i] = new Vec3(this.subentities[i].m_20185_(), this.subentities[i].m_20186_(), this.subentities[i].m_20189_());
        }
        for (i = 0; i < this.subentities.length; ++i) {
            this.subentities[i].f_19854_ = avector3d[i].f_82479_;
            this.subentities[i].f_19855_ = avector3d[i].f_82480_;
            this.subentities[i].f_19856_ = avector3d[i].f_82481_;
            this.subentities[i].f_19790_ = avector3d[i].f_82479_;
            this.subentities[i].f_19791_ = avector3d[i].f_82480_;
            this.subentities[i].f_19792_ = avector3d[i].f_82481_;
        }
        super.m_8107_();
    }

    public MachinePartEntity[] getSubEntities() {
        return this.subentities;
    }

    public PartEntity<?>[] getParts() {
        return this.subentities;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 1.0f, t -> {
            if (this.state.equals((Object)State.RELOADING)) {
                return (double)(this.f_19847_.delaytime - this.delayticks) / (double)this.f_19847_.delaytime;
            }
            return t;
        }, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (super.m_6071_(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void startShooting(Player player) {
        if (this.delayticks <= 0 && this.useticks <= 0 && this.shootingticks <= 0) {
            this.state = State.SHOOTING;
            this.useticks = this.f_19847_.usetime;
            this.shootingticks = this.f_19847_.userealisetime;
            Vec3 pos = this.m_20182_();
            this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.TREBUCHET_SHOOTING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    public void shoot() {
        if (!this.f_19853_.m_5776_()) {
            super.shoot();
        }
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.useticks <= 0 && this.delayticks <= 0) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.setTurretRotations(livingentity.m_146909_(), this.getTurretYaw());
                this.updateTurretRotations();
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        if (this.useticks != 0 && --this.useticks <= 0) {
            this.state = State.RELOADING;
            this.useticks = 0;
            this.delayticks = this.f_19847_.delaytime;
        }
        if (this.shootingticks != 0 && --this.shootingticks <= 0) {
            this.useRealise();
            this.shootingticks = 0;
        }
        if (!this.f_19853_.m_5776_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        if (this.delayticks > 0 && this.m_20160_()) {
            if (this.delayticks % 40 == 0) {
                Vec3 pos = this.m_20182_();
                this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.TREBUCHET_RELOADING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (--this.delayticks <= 0) {
                this.state = State.IDLE_RELOADED;
            }
        }
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        super.m_8119_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Crosshair createCrosshair() {
        return new ReloadingCrosshair();
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.TREBUCHET.get();
    }

    public static enum State {
        SHOOTING,
        RELOADING,
        IDLE_RELOADED,
        IDLE_NOT_RELOADED;

    }
}

