/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import com.mojang.math.Vector3d;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.entity.IReloading;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.Missile;
import ru.magistu.siegemachines.entity.projectile.ProjectileBuilder;
import ru.magistu.siegemachines.network.PacketHandler;
import ru.magistu.siegemachines.network.PacketMachineInventorySlot;
import ru.magistu.siegemachines.network.PacketMachineUse;
import ru.magistu.siegemachines.network.PacketMachineUseRealise;

public abstract class ShootingMachine
extends Machine
implements IReloading {
    public int shootingticks = 0;

    protected ShootingMachine(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level, type);
    }

    public abstract void startShooting(Player var1);

    public void shoot() {
        if (this.f_19847_.ammo.length == 0) {
            return;
        }
        ProjectileBuilder projectilebuilder = this.getProjectileBuilder();
        if (projectilebuilder.equals(ProjectileBuilder.NONE)) {
            Entity passenger = this.m_6688_();
            if (passenger instanceof Player) {
                passenger.m_213846_((Component)Component.m_237115_((String)"siegemachines.no_ammo").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        LivingEntity livingentity = (LivingEntity)this.m_6688_();
        Object projectile = projectilebuilder.factory.create(projectilebuilder.entitytype, this.f_19853_, new Vector3d(this.getShotPos().f_82479_, this.getShotPos().f_82480_, this.getShotPos().f_82481_), (LivingEntity)(livingentity == null ? this : livingentity), projectilebuilder.projectilitem);
        if (projectile instanceof Missile) {
            Missile missile = (Missile)((Object)projectile);
            missile.m_37446_(new ItemStack((ItemLike)missile.m_7881_()));
        }
        projectile.m_37251_((Entity)this, this.getTurretPitch(), this.getGlobalTurretYaw(), 0.0f, this.f_19847_.projectilespeed, this.f_19847_.inaccuracy);
        this.f_19853_.m_7967_(projectile);
        this.inventory.shrinkItem(projectilebuilder.item);
    }

    @Override
    public void use(Player player) {
        if (!this.f_19853_.m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUse(this.m_19879_()), this.m_20183_(), 16384);
        }
        this.startShooting(player);
    }

    @Override
    public void useRealise() {
        if (!this.f_19853_.m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUseRealise(this.m_19879_()), this.m_20183_(), 16384);
        }
        this.shoot();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isValidAmmo(stack)) {
            if (!this.hasAmmo()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.inventory.putItem(stack.m_41720_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected Vec3 getShotPos() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.m_5675_(0.5f) + this.getTurretYaw()) * Math.PI / 180.0;
        return this.m_20182_().m_82549_(ShootingMachine.applyRotations(this.f_19847_.turretpivot, 0.0, yaw).m_82549_(ShootingMachine.applyRotations(this.f_19847_.turretvector, pitch, yaw)));
    }

    protected Vec3 getShotView() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
        double d0 = -Math.sin(yaw) * Math.cos(pitch);
        double d1 = -Math.sin(pitch);
        double d2 = Math.cos(yaw) * Math.cos(pitch);
        return new Vec3(d0, d1, d2).m_82541_();
    }

    protected void blowParticles(ParticleOptions particle, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 pos = this.getShotPos();
            Vec3 inaccuracy = new Vec3(new Random().nextGaussian() * 0.2, new Random().nextGaussian() * 0.2, new Random().nextGaussian() * 0.2);
            Vec3 velocity = this.getShotView().m_82549_(inaccuracy).m_82490_(speed);
            this.f_19853_.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public void updateMachineRender() {
        super.updateMachineRender();
        if (!this.f_19853_.m_5776_()) {
            for (int i = 0; i < rows * 9; ++i) {
                if (!this.isValidAmmo(this.inventory.m_8020_(i))) continue;
                PacketHandler.sendPacketToAllInArea(new PacketMachineInventorySlot(this.m_19879_(), i, this.inventory.m_8020_(i)), this.m_20183_(), 16384);
            }
        }
    }

    public boolean isValidAmmo(ItemStack stack) {
        return this.isValidAmmo(stack.m_41720_());
    }

    public boolean isValidAmmo(Item entry) {
        return Arrays.stream(this.f_19847_.ammo).anyMatch(builder -> builder.item.equals(entry));
    }

    public ItemStack getAmmo() {
        return this.inventory.items.stream().filter(this::isValidAmmo).findFirst().orElse(ItemStack.f_41583_);
    }

    public boolean hasAmmo() {
        return this.inventory.items.stream().anyMatch(this::isValidAmmo);
    }

    public ProjectileBuilder getProjectileBuilder() {
        ItemStack ammo = this.getAmmo();
        if (ammo.equals(ItemStack.f_41583_)) {
            return ProjectileBuilder.NONE;
        }
        return Arrays.stream(this.f_19847_.ammo).filter(builder -> builder.item.equals(ammo.m_41720_())).findFirst().orElse(ProjectileBuilder.NONE);
    }
}

