/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.gui.machine.MachineContainer;
import ru.magistu.siegemachines.network.PacketHandler;
import ru.magistu.siegemachines.network.PacketMachine;

public abstract class Machine
extends Mob
implements MenuProvider {
    public MachineInventory inventory = new MachineInventory();
    public static int rows = 1;
    public final MachineType f_19847_;
    private float turretpitch;
    private float turretpitchprev = this.turretpitch = -25.0f;
    protected float turretpitchdest = this.turretpitch;
    private float turretyaw;
    private float turretyawprev = this.turretyaw = 0.0f;
    protected float turretyawdest = this.turretyaw;
    protected float yawdest = this.m_146908_();
    public int useticks = -1;
    public int delayticks;
    protected int renderupdateticks = 0;
    public int deploymentticks = 0;

    protected Machine(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level);
        this.f_19847_ = type;
        this.delayticks = this.f_19847_.delaytime;
        rows = this.f_19847_.rows;
    }

    public static AttributeSupplier.Builder setEntityAttributes(MachineType type) {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)type.health).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 0.0);
    }

    public ItemStack getMachineItemWithData() {
        ItemStack stack = new ItemStack((ItemLike)this.getMachineItem());
        CompoundTag nbt = this.m_20240_(new CompoundTag());
        nbt.m_128473_("Pos");
        nbt.m_128473_("Motion");
        nbt.m_128473_("FallDistance");
        nbt.m_128473_("Fire");
        nbt.m_128473_("Air");
        nbt.m_128473_("OnGround");
        nbt.m_128473_("Invulnerable");
        nbt.m_128473_("PortalCooldown");
        nbt.m_128473_("UUID");
        nbt.m_128473_("Passengers");
        nbt.m_128473_("DelayTicks");
        nbt.m_128473_("UseTicks");
        stack.m_41700_("EntityTag", (Tag)nbt);
        return stack;
    }

    public boolean m_6673_(DamageSource damagesource) {
        return damagesource == DamageSource.f_19314_ || damagesource == DamageSource.f_19320_ || damagesource == DamageSource.f_19319_ || damagesource == DamageSource.f_19312_ || damagesource == DamageSource.f_19313_ || super.m_6673_(damagesource);
    }

    public float adjustDamage(DamageSource damagesource, float f) {
        if (damagesource.m_19384_()) {
            f *= 1.5f;
        }
        if (damagesource.m_19372_()) {
            f *= 1.25f;
        }
        if (damagesource.m_19390_()) {
            f *= 2.0f;
        }
        if (damagesource.m_7639_() instanceof AbstractArrow) {
            f *= 0.5f;
        }
        return f;
    }

    public abstract Item getMachineItem();

    public void m_8119_() {
        if (this.deploymentticks > 0) {
            --this.deploymentticks;
        }
        super.m_8119_();
    }

    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)damagesource, (float)f)) {
            return false;
        }
        if (damagesource.m_7639_() instanceof Player && !damagesource.m_19360_() && !damagesource.m_19372_() && !damagesource.m_19387_() && this.m_20197_().isEmpty()) {
            this.m_19983_(this.getMachineItemWithData());
            this.remove();
            return false;
        }
        if (this.m_6673_(damagesource)) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (this.m_21224_()) {
            return false;
        }
        if (damagesource.m_19384_() && this.m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        f = this.adjustDamage(damagesource, f);
        this.f_20891_ = 0;
        this.f_20924_ = 1.5f;
        boolean flag1 = true;
        if ((float)this.f_19802_ > 10.0f) {
            if (f <= this.f_20898_) {
                return false;
            }
            this.m_6475_(damagesource, f - this.f_20898_);
            this.f_20898_ = f;
            flag1 = false;
        } else {
            this.f_20898_ = f;
            this.f_19802_ = 20;
            this.m_6475_(damagesource, f);
            this.f_20916_ = this.f_20917_ = 10;
        }
        this.f_20918_ = 0.0f;
        Entity entity1 = damagesource.m_7639_();
        if (entity1 != null) {
            TamableAnimal wolfEntity;
            if (entity1 instanceof LivingEntity) {
                this.m_6703_((LivingEntity)entity1);
            }
            if (entity1 instanceof Player) {
                this.f_20889_ = 1;
                this.f_20888_ = (Player)entity1;
            } else if (entity1 instanceof TamableAnimal && (wolfEntity = (TamableAnimal)entity1).m_21824_()) {
                this.f_20889_ = 100;
                LivingEntity livingentity = wolfEntity.m_21826_();
                this.f_20888_ = livingentity != null && livingentity.m_6095_() == EntityType.f_20532_ ? (Player)livingentity : null;
            }
        }
        if (flag1) {
            if (damagesource instanceof EntityDamageSource && ((EntityDamageSource)damagesource).m_19403_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)33);
            } else {
                byte b0 = damagesource.m_19384_() ? (byte)37 : (damagesource == DamageSource.f_19325_ ? (byte)44 : 2);
                this.f_19853_.m_7605_((Entity)this, b0);
            }
            this.m_5834_();
            if (entity1 != null) {
                double d1 = entity1.m_20185_() - this.m_20185_();
                double d0 = entity1.m_20189_() - this.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.f_20918_ = (float)(Mth.m_14136_((double)d0, (double)d1) * 57.2957763671875 - (double)this.m_146908_());
            } else {
                this.f_20918_ = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.m_21224_()) {
            SoundEvent soundevent = this.m_5592_();
            if (flag1 && soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
            this.m_6667_(damagesource);
        } else if (flag1) {
            this.m_6677_(damagesource);
        }
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)entity1, (Entity)this, damagesource, f, f, false);
        }
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_184601_1_) {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.inventory.items) {
            CompoundTag compoundnbt = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        nbt.m_128365_("Items", (Tag)listnbt);
        nbt.m_128365_("TurretRotations", (Tag)this.m_20065_(new float[]{this.turretpitch, this.turretyaw}));
        nbt.m_128405_("DealyTicks", this.delayticks);
        nbt.m_128405_("UseTicks", this.useticks);
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
        this.inventory.items.forEach(arg_0 -> ((Machine)this).m_19983_(arg_0));
        this.inventory.m_6211_();
    }

    public void remove() {
        if (!this.f_20890_) {
            this.f_20890_ = true;
            this.f_19853_.m_7605_((Entity)this, (byte)3);
        }
        super.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte b) {
        switch (b) {
            case 2: 
            case 33: 
            case 36: 
            case 37: 
            case 44: {
                DamageSource damagesource;
                SoundEvent soundevent1;
                boolean flag1 = b == 33;
                boolean flag2 = b == 36;
                boolean flag3 = b == 37;
                boolean flag = b == 44;
                this.f_20924_ = 1.5f;
                this.f_19802_ = 20;
                this.f_20916_ = this.f_20917_ = 10;
                this.f_20918_ = 0.0f;
                if (flag1) {
                    this.m_5496_(SoundEvents.f_12511_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                if ((soundevent1 = this.m_7975_(damagesource = flag3 ? DamageSource.f_19307_ : (flag2 ? DamageSource.f_19312_ : (flag ? DamageSource.f_19325_ : DamageSource.f_19318_)))) != null) {
                    this.m_5496_(soundevent1, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                this.m_6469_(DamageSource.f_19318_, 0.0f);
                break;
            }
            case 3: {
                SoundEvent soundevent = this.m_5592_();
                if (soundevent != null) {
                    this.m_5496_(soundevent, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                this.m_21153_(0.0f);
                this.remove();
                break;
            }
            case 29: 
            case 30: 
            case 46: {
                for (int j = 0; j < 128; ++j) {
                    double d0 = (double)j / 127.0;
                    float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                    float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                    float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                    double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                    double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                    double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
                }
                break;
            }
            case 54: {
                HoneyBlock.m_54010_((Entity)this);
                break;
            }
            default: {
                super.m_7822_(b);
            }
        }
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Items", 9)) {
            ListTag listnbt = nbt.m_128437_("Items", 10);
            for (int i = 0; i < this.inventory.items.size(); ++i) {
                this.inventory.items.set(i, (Object)ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i)));
            }
        }
        if (nbt.m_128425_("TurretRotations", 5)) {
            ListTag turretrotations = nbt.m_128437_("TurretRotations", 5);
            this.setTurretRotations(turretrotations.m_128775_(0), turretrotations.m_128775_(1));
        }
        if (nbt.m_128441_("DealyTicks")) {
            this.delayticks = nbt.m_128451_("DealyTicks");
        }
        if (nbt.m_128441_("UseTicks")) {
            this.useticks = nbt.m_128451_("UseTicks");
        }
    }

    public float getGlobalTurretYaw() {
        return Mth.m_14179_((float)0.5f, (float)this.f_19859_, (float)this.m_146908_()) + Mth.m_14179_((float)0.5f, (float)this.turretyawprev, (float)this.turretyaw);
    }

    public float getYaw() {
        return this.m_146908_();
    }

    public void setYaw(float yaw) {
        this.m_146922_(yaw);
        this.f_19859_ = this.m_146908_();
        this.f_20885_ = this.f_20883_ = this.m_146908_();
    }

    public float getYawDest() {
        return this.yawdest;
    }

    public void setYawDest(float yaw) {
        this.yawdest = yaw;
    }

    public float getTurretPitch(float f) {
        return Mth.m_14179_((float)f, (float)this.turretpitchprev, (float)this.turretpitch);
    }

    public float getTurretYaw(float f) {
        return Mth.m_14179_((float)f, (float)this.turretyawprev, (float)this.turretyaw);
    }

    public float getTurretPitch() {
        return this.getTurretPitch(0.5f);
    }

    public float getTurretYaw() {
        return this.getTurretYaw(0.5f);
    }

    public void setTurretRotations(float pitch, float yaw) {
        this.turretpitchprev = this.turretpitch;
        this.turretyawprev = this.turretyaw;
        this.turretpitch = pitch;
        this.turretyaw = yaw;
    }

    public float getTurretPitchDest() {
        return this.turretpitchdest;
    }

    public float getTurretYawDest() {
        return this.turretyawdest;
    }

    public void setTurretRotationsDest(float pitch, float yaw) {
        this.turretpitchdest = pitch;
        this.turretyawdest = yaw;
    }

    public void updateMachineRender() {
        if (!this.f_19853_.m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachine(this.m_19879_(), this.delayticks, this.useticks, this.turretpitch, this.turretyaw), this.m_20183_(), 16384);
        }
    }

    public void updateYaw() {
        float newyaw = this.turn(this.getYaw(), this.getYawDest(), this.f_19847_.rotationspeed);
        if (this.getYaw() != newyaw) {
            this.setYaw(newyaw);
        }
    }

    public void updateTurretRotations() {
        float newpitch;
        float newyaw = this.turn(this.getTurretYaw(), this.getTurretYawDest(), this.f_19847_.turretspeed, this.f_19847_.turretminyaw, this.f_19847_.turretmaxyaw);
        boolean shouldrotate = this.checkYaw(newyaw, this.getTurretYaw(), this.f_19847_.turretspeed);
        float f = newpitch = shouldrotate ? this.turn(this.getTurretPitch(), this.getTurretPitchDest(), this.f_19847_.turretspeed, this.f_19847_.turretminpitch, this.f_19847_.turretmaxpitch) : this.getTurretPitch();
        if (this.turretpitch != newpitch || this.turretyaw != newyaw) {
            this.setTurretRotations(newpitch, newyaw);
        }
    }

    public boolean checkYaw(float yaw, float currentYaw, float speed) {
        return !this.f_19847_.yawfirst || Math.abs(yaw - currentYaw) <= speed / 2.0f || yaw <= this.f_19847_.turretminyaw || yaw >= this.f_19847_.turretmaxyaw;
    }

    public float turn(float rotation, float rotationDest, float speed) {
        return this.turn(rotation, rotationDest, speed, -180.0f, 180.0f);
    }

    public float turn(float rotation, float rotationDest, float speed, float minRotation, float maxRotation) {
        boolean hasLimit = maxRotation - minRotation < 360.0f;
        float deltaRotation = rotationDest - rotation;
        float newRotation = (deltaRotation = Mth.m_14177_((float)deltaRotation)) > speed / 2.0f ? rotation + speed : (deltaRotation < -speed / 2.0f ? rotation - speed : rotation + deltaRotation / 2.0f);
        if (hasLimit) {
            if (newRotation > -minRotation) {
                newRotation = -minRotation;
            }
            if (newRotation < -maxRotation) {
                newRotation = -maxRotation;
            }
        }
        return newRotation;
    }

    protected static Vec3 applyRotations(Vec3 vec, double pitch, double yaw) {
        double d0 = vec.f_82479_ * Math.cos(yaw) - vec.f_82480_ * Math.sin(pitch) * Math.sin(yaw) - vec.f_82481_ * Math.sin(yaw) * Math.cos(pitch);
        double d1 = vec.f_82480_ * Math.cos(pitch) - vec.f_82481_ * Math.sin(pitch);
        double d2 = vec.f_82479_ * Math.sin(yaw) + vec.f_82480_ * Math.sin(pitch) * Math.cos(yaw) + vec.f_82481_ * Math.cos(yaw) * Math.cos(pitch);
        return new Vec3(d0, d1, d2);
    }

    protected float getVolumeFromDist(float dist) {
        return 0.5f * Math.max(6.0f - dist, 0.0f) / 6.0f;
    }

    public abstract void use(Player var1);

    public abstract void useRealise();

    public MachineContainer createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new MachineContainer(id, inv, this);
    }

    public void openInventoryGui() {
        Entity passenger = this.m_6688_();
        if (passenger instanceof ServerPlayer) {
            this.m_8127_();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)passenger), (MenuProvider)this, (BlockPos)this.m_20183_());
        }
    }

    public Vec3 m_7688_(LivingEntity entity) {
        double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
        return this.m_20182_().m_82549_(Machine.applyRotations(this.f_19847_.passengerpos, 0.0, yaw));
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7332_(@NotNull Entity entity) {
        Entity.MoveFunction setPos = Entity::m_6034_;
        if (this.m_20363_(entity)) {
            double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
            Vec3 pos = this.m_20182_().m_82549_(Machine.applyRotations(this.f_19847_.passengerpos, 0.0, yaw));
            setPos.m_20372_(entity, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static class MachineInventory
    implements Container,
    Nameable {
        public NonNullList<ItemStack> items = NonNullList.m_122780_((int)(9 * rows), (Object)ItemStack.f_41583_);

        public int m_6643_() {
            return 9 * rows;
        }

        public boolean m_7983_() {
            return false;
        }

        @NotNull
        public ItemStack m_8020_(int id) {
            return (ItemStack)this.items.get(id);
        }

        @NotNull
        public ItemStack m_7407_(int id, int p_70298_2_) {
            return (ItemStack)this.items.set(id, (Object)ItemStack.f_41583_);
        }

        @NotNull
        public ItemStack m_8016_(int id) {
            return (ItemStack)this.items.remove(id);
        }

        public void m_6836_(int id, @NotNull ItemStack item) {
            this.items.set(id, (Object)item);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@NotNull Player player) {
            return true;
        }

        public void m_6211_() {
            this.items = NonNullList.m_122780_((int)(9 * rows), (Object)ItemStack.f_41583_);
        }

        public boolean containsItem(Item item) {
            return this.items.stream().anyMatch(itemStack -> itemStack.m_41720_().equals(item));
        }

        public void putItem(Item item) {
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack itemstack = (ItemStack)this.items.get(i);
                if (itemstack.m_41619_()) {
                    this.items.set(i, (Object)new ItemStack((ItemLike)item));
                    break;
                }
                if (!itemstack.m_41720_().equals(item) || itemstack.m_41613_() >= itemstack.m_41741_()) continue;
                itemstack.m_41764_(itemstack.m_41613_() + 1);
                break;
            }
        }

        public void shrinkItem(Item item) {
            for (ItemStack itemstack : this.items) {
                if (!itemstack.m_41720_().equals(item)) continue;
                itemstack.m_41774_(1);
                break;
            }
        }

        public Component m_7755_() {
            return this.m_7755_();
        }
    }
}

