/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.client.SoundTypes;
import ru.magistu.siegemachines.entity.Breakdown;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.item.ModItems;
import ru.magistu.siegemachines.network.PacketHandler;
import ru.magistu.siegemachines.network.PacketMachineUse;
import ru.magistu.siegemachines.network.PacketMachineUseRealise;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BatteringRam
extends Machine
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    static AnimationBuilder MOVING_ANIM = new AnimationBuilder().addAnimation("Moving", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    static AnimationBuilder HITTING_ANIM = new AnimationBuilder().addAnimation("Hitting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    static AnimationBuilder RELOADING_ANIM = new AnimationBuilder().addAnimation("Reloading", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public int hittingticks = 0;
    private int wheelssoundticks = 10;
    public State state = State.RELOADING;
    private double wheelspitch = 0.0;
    private double wheelsspeed = 0.0;

    public BatteringRam(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.BATTERING_RAM);
    }

    private <E extends IAnimatable> PlayState wheels_predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(MOVING_ANIM);
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState reloading_predicate(AnimationEvent<E> event) {
        switch (this.state) {
            case HITTING: {
                event.getController().setAnimation(HITTING_ANIM);
                return PlayState.CONTINUE;
            }
            case RELOADING: {
                event.getController().setAnimation(RELOADING_ANIM);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController wheels_controller = new AnimationController((IAnimatable)this, "wheels_controller", 1.0f, t -> {
            double d = this.getWheelsSpeed();
            this.wheelsspeed = d > 0.0 ? Math.min(d, 1.0) : Math.max(d, -1.0);
            return this.wheelspitch += 0.015 * this.wheelsspeed;
        }, this::wheels_predicate);
        data.addAnimationController(wheels_controller);
        AnimationController reloading_controller = new AnimationController((IAnimatable)this, "controller", 1.0f, t -> {
            if (this.state.equals((Object)State.RELOADING)) {
                return (double)(this.f_19847_.delaytime - this.delayticks) / (double)this.f_19847_.delaytime;
            }
            return t;
        }, this::reloading_predicate);
        data.addAnimationController(reloading_controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.f_19853_.m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.04f);
                pos = new Vec3(0.0, pos.f_82480_, (double)f1);
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        if (this.useticks != 0 && --this.useticks <= 0) {
            this.state = State.RELOADING;
            this.useticks = 0;
            this.delayticks = this.f_19847_.delaytime;
        }
        if (this.hittingticks != 0 && --this.hittingticks <= 0) {
            this.useRealise();
            this.hittingticks = 0;
        }
        if (!this.f_19853_.m_5776_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        if (this.delayticks > 0 && this.m_20160_()) {
            --this.delayticks;
        }
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        super.m_8119_();
    }

    @Override
    public void use(Player player) {
        if (!this.f_19853_.m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUse(this.m_19879_()), this.m_20183_(), 16384);
        }
        if (this.delayticks <= 0 && this.useticks <= 0 && this.hittingticks <= 0) {
            this.state = State.HITTING;
            this.useticks = this.f_19847_.usetime;
            this.hittingticks = this.f_19847_.userealisetime;
            Vec3 pos = this.m_20182_();
            this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.RAM_HITTING.get(), SoundSource.BLOCKS, 0.5f, 0.9f, false);
        }
    }

    public void ramHit(BlockPos blockpos) {
        if (!this.f_19853_.m_5776_()) {
            Breakdown breakdown = new Breakdown(this.f_19853_, (Entity)this, this.m_6688_(), blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), 2.0f, false, 3.0f, Explosion.BlockInteraction.BREAK);
            breakdown.explode();
            breakdown.finalizeExplosion(true);
        }
    }

    @Override
    public void useRealise() {
        if (!this.f_19853_.m_5776_()) {
            PacketHandler.sendPacketToAllInArea(new PacketMachineUseRealise(this.m_19879_()), this.m_20183_(), 16384);
            BlockPos blockpos = new BlockPos(this.getHitPos());
            this.ramHit(blockpos);
        }
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.BATTERING_RAM.get();
    }

    protected Vec3 getHitPos() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.m_5675_(0.5f) + this.getTurretYaw()) * Math.PI / 180.0;
        return this.m_20182_().m_82549_(BatteringRam.applyRotations(this.f_19847_.turretpivot, 0.0, yaw).m_82549_(BatteringRam.applyRotations(this.f_19847_.turretvector, pitch, yaw)));
    }

    public static enum State {
        HITTING,
        RELOADING;

    }
}

