/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Breakdown {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.m_216327_();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Vec3 position;
    private final Explosion explosion;
    private final Entity machine;
    private final float power;

    public Breakdown(Level p_i50007_1_, @Nullable Entity machine, @Nullable Entity p_i50007_2_, double p_i50007_3_, double p_i50007_5_, double p_i50007_7_, float p_i50007_9_, boolean p_i50007_10_, float power, Explosion.BlockInteraction p_i50007_11_) {
        this(p_i50007_1_, p_i50007_2_, machine, null, null, p_i50007_3_, p_i50007_5_, p_i50007_7_, p_i50007_9_, p_i50007_10_, power, p_i50007_11_);
    }

    public Breakdown(Level p_i231610_1_, @Nullable Entity machine, @Nullable Entity p_i231610_2_, @Nullable DamageSource p_i231610_3_, @Nullable ExplosionDamageCalculator p_i231610_4_, double p_i231610_5_, double p_i231610_7_, double p_i231610_9_, float p_i231610_11_, boolean p_i231610_12_, float power, Explosion.BlockInteraction p_i231610_13_) {
        this.explosion = new Explosion(p_i231610_1_, p_i231610_2_, p_i231610_3_, p_i231610_4_, p_i231610_5_, p_i231610_7_, p_i231610_9_, p_i231610_11_, p_i231610_12_, p_i231610_13_);
        this.level = p_i231610_1_;
        this.machine = machine;
        this.source = p_i231610_2_;
        this.radius = p_i231610_11_;
        this.x = p_i231610_5_;
        this.y = p_i231610_7_;
        this.z = p_i231610_9_;
        this.fire = p_i231610_12_;
        this.power = power;
        this.blockInteraction = p_i231610_13_;
        this.damageSource = p_i231610_3_ == null && p_i231610_2_ instanceof LivingEntity ? DamageSource.m_19373_((LivingEntity)((LivingEntity)p_i231610_2_)) : p_i231610_3_;
        this.damageCalculator = p_i231610_4_ == null ? this.makeDamageCalculator(p_i231610_2_) : p_i231610_4_;
        this.position = new Vec3(this.x, this.y, this.z);
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity p_234894_1_) {
        return p_234894_1_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(p_234894_1_);
    }

    public static float getSeenPercent(Vec3 p_222259_0_, Entity p_222259_1_) {
        AABB axisalignedbb = p_222259_1_.m_20191_();
        double d0 = 1.0 / ((axisalignedbb.f_82291_ - axisalignedbb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.f_82292_ - axisalignedbb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f_82293_ - axisalignedbb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = Mth.m_14139_((double)f, (double)axisalignedbb.f_82288_, (double)axisalignedbb.f_82291_);
                        Vec3 vector3d = new Vec3(d5 + d3, d6 = Mth.m_14139_((double)f1, (double)axisalignedbb.f_82289_, (double)axisalignedbb.f_82292_), (d7 = Mth.m_14139_((double)f2, (double)axisalignedbb.f_82290_, (double)axisalignedbb.f_82293_)) + d4);
                        if (p_222259_1_.f_19853_.m_45547_(new ClipContext(vector3d, p_222259_0_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_222259_1_)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void explode() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.power * this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= this.power * 0.5f) {
                        FluidState fluidstate;
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        Optional optional = this.damageCalculator.m_6617_(this.explosion, (BlockGetter)this.level, blockpos, blockstate, fluidstate = this.level.m_6425_(blockpos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_(this.explosion, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = 1.5f * this.radius;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || entity.equals((Object)this.machine) || entity.equals((Object)this.source) || !((d12 = (double)(Mth.m_14116_((float)((float)entity.m_20238_(vector3d))) / f2)) <= 1.0) || (d13 = (double)Mth.m_14116_((float)((float)((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Breakdown.getSeenPercent(vector3d, entity);
            double d10 = (1.0 - d12) * d14;
            if (!(entity instanceof ItemEntity)) {
                entity.m_6469_(this.getDamageSource(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            }
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
            this.hitPlayers.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void finalizeExplosion(boolean p_77279_1_) {
        boolean flag;
        if (this.level.f_46443_) {
            // empty if block
        }
        boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.NONE;
        if (p_77279_1_) {
            if (!(this.radius < 2.0f) && flag) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Util.m_214673_(this.toBlow, (RandomSource)this.random);
            for (BlockPos blockpos : this.toBlow) {
                BlockState blockstate = this.level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (this.level instanceof ServerLevel) {
                    BlockEntity tileentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.level).m_230911_(this.level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity).m_78984_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY) {
                        lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_60724_(lootcontext$builder).forEach(p_229977_2_ -> Breakdown.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos1));
                }
                this.level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.m_188503_(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, FireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int i = p_46068_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_46068_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_46069_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_46069_, (int)16);
            p_46068_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity getSourceMob() {
        Entity entity;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof PrimedTnt) {
            return ((PrimedTnt)this.source).m_32099_();
        }
        if (this.source instanceof LivingEntity) {
            return (LivingEntity)this.source;
        }
        if (this.source instanceof Projectile && (entity = ((Projectile)this.source).m_37282_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPos> getToBlow() {
        return this.toBlow;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.source;
    }
}

