/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.Validate;

public class CountIngredient {
    private final int count;
    private final Lazy<Ingredient> ingredient;

    private CountIngredient(Lazy<Ingredient> ingredient, int count) {
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"count must be greater than 0 for CountIngredients.", (Object[])new Object[0]);
        this.count = count;
        this.ingredient = ingredient;
    }

    public boolean test(ItemStack stack) {
        return this.test(stack, false);
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        if (stack == null) {
            return false;
        }
        if (this.get().m_43908_().length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : this.get().m_43908_()) {
            if (itemstack.m_41720_() != stack.m_41720_() || this.getCount() != stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return ((Ingredient)this.ingredient.get()).m_43947_();
    }

    public List<ItemStack> getCountModifiedItemStacks() {
        return Arrays.asList(((Ingredient)this.ingredient.get()).m_43908_()).stream().map(is -> {
            ItemStack cs = is.m_41777_();
            cs.m_41764_(this.count);
            return cs;
        }).collect(Collectors.toList());
    }

    public static CountIngredient fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int count = buffer.readInt();
        return new CountIngredient((Lazy<Ingredient>)Lazy.of(() -> ingredient), count);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        ((Ingredient)this.ingredient.get()).m_43923_(buffer);
        buffer.writeInt(this.count);
    }

    public static CountIngredient fromJson(JsonObject json) {
        Lazy ingredient = Lazy.of(() -> Ingredient.m_43917_((JsonElement)json));
        int count = GsonHelper.m_13900_((JsonObject)json, (String)"count") ? GsonHelper.m_13927_((JsonObject)json, (String)"count") : 1;
        return new CountIngredient((Lazy<Ingredient>)ingredient, count);
    }

    public JsonObject toJson() {
        JsonObject ingJson = ((Ingredient)this.ingredient.get()).m_43942_().getAsJsonObject();
        if (this.count > 1) {
            ingJson.addProperty("count", (Number)this.count);
        }
        return ingJson;
    }

    public static CountIngredient of(Ingredient ingredient) {
        return CountIngredient.of(ingredient, 1);
    }

    public static CountIngredient of(Ingredient ingredient, int count) {
        return new CountIngredient((Lazy<Ingredient>)Lazy.of(() -> ingredient), count);
    }

    public Ingredient get() {
        return (Ingredient)this.ingredient.get();
    }
}

