/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.magistu.siegemachines.client.renderer.MachineGeoRenderer;
import ru.magistu.siegemachines.client.renderer.model.MachineModel;
import ru.magistu.siegemachines.entity.machine.Ballista;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;

public class BallistaGeoRenderer
extends MachineGeoRenderer<Ballista> {
    public BallistaGeoRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new MachineModel("ballista"));
    }

    public RenderType getRenderType(Ballista animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void renderEarly(Ballista animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        GeoModelProvider modelProvider = this.getGeoModelProvider();
        GeoModel model = modelProvider.getModel(modelProvider.getModelResource((Object)animatable));
        Optional turret = model.getBone("Balliste");
        turret.ifPresent(bone -> bone.setRotationX(-animatable.getTurretPitch() * (float)Math.PI / 180.0f));
        turret.ifPresent(bone -> bone.setRotationY(-animatable.getTurretYaw() * (float)Math.PI / 180.0f));
        Optional projectile = model.getBone("BallistaArrow");
        projectile.ifPresent(bone -> bone.setRotationX(-animatable.getTurretPitch() * (float)Math.PI / 180.0f));
        projectile.ifPresent(bone -> bone.setRotationY(-animatable.getTurretYaw() * (float)Math.PI / 180.0f));
        boolean shouldrender = (animatable.useticks <= 0 && animatable.shootingticks <= 0 || animatable.useticks > 0 && animatable.shootingticks > 0) && animatable.delayticks <= 0;
        int projectilesize = shouldrender && animatable.hasAmmo() ? 1 : 0;
        projectile.ifPresent(bone -> bone.setScaleX((float)projectilesize));
        projectile.ifPresent(bone -> bone.setScaleY((float)projectilesize));
        projectile.ifPresent(bone -> bone.setScaleZ((float)projectilesize));
        super.renderEarly((LivingEntity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }
}

