/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.SerializableNbt;
import immersive_paintings.util.Utils;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RegisterPaintingRequest
implements Message {
    private static final long serialVersionUID = -8024453179740575548L;
    private final String name;
    private final SerializableNbt painting;

    public RegisterPaintingRequest(String name, Painting painting) {
        this.name = name;
        this.painting = new SerializableNbt(painting.toNbt());
    }

    @Override
    public void receive(Player e) {
        ByteImage image = UploadPaintingRequest.uploadedImages.get(e.m_20149_());
        if (image.getWidth() > Config.getInstance().maxUserImageWidth || image.getHeight() > Config.getInstance().maxUserImageHeight) {
            this.error("too_large", e, null);
            return;
        }
        long count = ServerPaintingManager.get().getCustomServerPaintings().values().stream().filter(p -> p.author.equals(e.m_36316_().getName())).count();
        if (count > (long)Config.getInstance().maxUserImages) {
            this.error("limit_reached", e, null);
            return;
        }
        String id = Utils.escapeString(e.m_36316_().getName()) + "/" + Utils.escapeString(this.name);
        ResourceLocation identifier = Main.locate(id);
        CompoundTag nbt = this.painting.getNbt();
        nbt.m_128359_("author", e.m_36316_().getName());
        nbt.m_128359_("name", this.name);
        Painting painting = Painting.fromNbt(nbt);
        painting.texture.image = image;
        ServerPaintingManager.registerPainting(identifier, painting);
        for (ServerPlayer player : Objects.requireNonNull(e.m_20194_()).m_6846_().m_11314_()) {
            NetworkHandler.sendToPlayer(new PaintingListMessage(identifier, painting), player);
        }
        this.error(null, e, identifier);
    }

    private void error(String error, Player e, ResourceLocation i) {
        NetworkHandler.sendToPlayer(new RegisterPaintingResponse(error, i), (ServerPlayer)e);
    }
}

