/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.ByteImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.player.Player;

public abstract class SegmentedPaintingMessage
implements Message {
    private static final long serialVersionUID = -6584975870115489847L;
    private final byte[] data;
    private final int segment;
    private final int totalSegments;
    private static final Map<String, List<byte[]>> buffer = new HashMap<String, List<byte[]>>();

    public SegmentedPaintingMessage(byte[] data, int segment, int totalSegments) {
        this.data = data;
        this.segment = segment;
        this.totalSegments = totalSegments;
    }

    protected abstract String getIdentifier(Player var1);

    protected abstract void process(Player var1, ByteImage var2);

    @Override
    public void receive(Player e) {
        String i = this.getIdentifier(e);
        List byteBuffer = buffer.computeIfAbsent(i, k -> new LinkedList());
        byteBuffer.add(this.data);
        if (this.segment + 1 == this.totalSegments) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (byte[] b : byteBuffer) {
                try {
                    outputStream.write(b);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                ByteImage image = ByteImage.read(outputStream.toByteArray());
                this.process(e, image);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            buffer.remove(i);
        }
    }
}

