/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 9132405079466337851L;
    private static final Config INSTANCE = Config.loadOrCreate();
    public String README = "https://github.com/Luke100000/ImmersivePaintings/wiki/Config";
    public static final int VERSION = 1;
    public int thumbnailSize = 128;
    public int lodResolutionMinimum = 32;
    public float halfResolutionThreshold = 2.0f;
    public float quarterResolutionThreshold = 4.0f;
    public float eighthResolutionThreshold = 8.0f;
    public int maxPacketsPerSecond = 20;
    public int packetSize = 16384;
    public boolean testIfSpaceEmpty = false;
    public boolean paintingsHaveCollision = false;
    public int maxUserImageWidth = 4096;
    public int maxUserImageHeight = 4096;
    public int maxUserImages = 1000;
    public int minPaintingResolution = 8;
    public int maxPaintingResolution = 256;
    public boolean showOtherPlayersPaintings = true;
    public int version = 0;

    public static Config getInstance() {
        return INSTANCE;
    }

    public static File getConfigFile() {
        return new File("./config/immersive_paintings.json");
    }

    public void save() {
        new File("./config").mkdirs();
        try (FileWriter writer = new FileWriter(Config.getConfigFile());){
            this.version = 1;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config loadOrCreate() {
        Config config;
        FileReader reader = new FileReader(Config.getConfigFile());
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Config config2 = (Config)gson.fromJson((Reader)reader, Config.class);
            if (config2.version != 1) {
                config2 = new Config();
            }
            config2.save();
            config = config2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                Config config3 = new Config();
                config3.save();
                return config3;
            }
        }
        reader.close();
        return config;
    }
}

