/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.processors;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.infernalstudios.infernalexp.init.IEProcessors;

public class LootChestProcessor
extends StructureProcessor {
    public static final LootChestProcessor INSTANCE = new LootChestProcessor();
    public static final Codec<LootChestProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @ParametersAreNonnullByDefault
    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoRelative, StructureTemplate.StructureBlockInfo structureBlockInfoGlobal, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        String[] nbtData;
        BlockState blockState = structureBlockInfoGlobal.f_74676_;
        if (blockState.m_60713_(Blocks.f_50677_) && (nbtData = structureBlockInfoGlobal.f_74677_.m_128461_("metadata").split("-"))[0].equals("chest")) {
            BlockState state = (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Objects.requireNonNull(Direction.m_122402_((String)nbtData[1])));
            ChestBlockEntity blockEntity = new ChestBlockEntity(structureBlockInfoGlobal.f_74675_, state);
            blockEntity.m_59626_(new ResourceLocation(nbtData[2]), new Random().nextLong());
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoGlobal.f_74675_, state, blockEntity.serializeNBT());
        }
        return structureBlockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return IEProcessors.LOOT_CHEST;
    }
}

