/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;

public class SinkHoleFeature
extends IEFeature<NoneFeatureConfiguration> {
    private static final int minRadius = 2;
    private static final int maxRadius = 4;

    public SinkHoleFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int y;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)context.m_159777_());
        if (!context.m_159774_().m_46859_((BlockPos)mutableBlockPos) || context.m_159774_().m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN)).m_60734_() != IEBlocks.GLOWDUST_SAND.get()) {
            return false;
        }
        int radius = 2 + context.m_225041_().m_188503_(2);
        int depth = 10 + context.m_225041_().m_188503_(6);
        mutableBlockPos.m_122190_((Vec3i)context.m_159777_());
        for (int y2 = 1; y2 < depth; ++y2) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            if (!context.m_159774_().m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50016_)) continue;
            return false;
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle(radius + 1)) {
            mutableBlockPos.m_122190_((Vec3i)context.m_159777_());
            mutableBlockPos.m_122184_(point.m_123341_(), point.m_123342_(), point.m_123343_());
            for (y = 0; y < 3; ++y) {
                context.m_159774_().m_7731_((BlockPos)mutableBlockPos.m_122173_(Direction.DOWN), ((Block)IEBlocks.GLOWDUST_SAND.get()).m_49966_(), 2);
            }
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle(radius)) {
            mutableBlockPos.m_122190_((Vec3i)context.m_159777_());
            mutableBlockPos.m_122184_(point.m_123341_(), point.m_123342_(), point.m_123343_());
            mutableBlockPos.m_122173_(Direction.DOWN);
            context.m_159774_().m_7731_((BlockPos)mutableBlockPos, ((Block)IEBlocks.TRAPPED_GLOWDUST_SAND.get()).m_49966_(), 2);
            for (y = 2; y < depth; ++y) {
                mutableBlockPos.m_122173_(Direction.DOWN);
                this.carveSpot(context.m_159774_(), context.m_159775_(), mutableBlockPos);
            }
        }
        for (BlockPos point : ShapeUtil.generateSolidSphere(radius)) {
            mutableBlockPos.m_122190_((Vec3i)context.m_159777_());
            mutableBlockPos.m_122184_(point.m_123341_(), point.m_123342_(), point.m_123343_());
            mutableBlockPos.m_122175_(Direction.DOWN, depth + 1);
            this.carveSpot(context.m_159774_(), context.m_159775_(), mutableBlockPos);
        }
        return true;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return false;
    }

    private void carveSpot(WorldGenLevel world, ChunkGenerator generator, BlockPos.MutableBlockPos mutableBlockPos) {
        if (world.m_8055_((BlockPos)mutableBlockPos).m_60819_().m_76178_()) {
            if (mutableBlockPos.m_123342_() < generator.m_6337_()) {
                world.m_7731_((BlockPos)mutableBlockPos, Blocks.f_49991_.m_49966_(), 3);
            } else {
                world.m_7731_((BlockPos)mutableBlockPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }
}

