/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;
import org.infernalstudios.infernalexp.world.gen.features.config.GlowSpikeFeatureConfig;

public class GlowSpikeFeature
extends IEFeature<GlowSpikeFeatureConfig> {
    public GlowSpikeFeature(Codec<GlowSpikeFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<GlowSpikeFeatureConfig> context) {
        if (context.m_159774_().m_46859_(context.m_159777_()) || context.m_159774_().m_8055_(context.m_159777_().m_7495_()).m_60734_() == IEBlocks.GLOWDUST_SAND.get() || context.m_159774_().m_8055_(context.m_159777_()).m_60734_() == Blocks.f_49991_ && context.m_159774_().m_8055_(context.m_159777_().m_7495_()).m_60734_() != Blocks.f_49991_) {
            int height = ((GlowSpikeFeatureConfig)context.m_159778_()).minHeight + context.m_225041_().m_188503_(((GlowSpikeFeatureConfig)context.m_159778_()).maxHeight - ((GlowSpikeFeatureConfig)context.m_159778_()).minHeight);
            int diameter = ((GlowSpikeFeatureConfig)context.m_159778_()).minDiameter + context.m_225041_().m_188503_(((GlowSpikeFeatureConfig)context.m_159778_()).maxDiameter - ((GlowSpikeFeatureConfig)context.m_159778_()).minDiameter);
            int xOffset = -((GlowSpikeFeatureConfig)context.m_159778_()).maxXOffset + context.m_225041_().m_188503_(((GlowSpikeFeatureConfig)context.m_159778_()).maxXOffset * 2);
            int zOffset = -((GlowSpikeFeatureConfig)context.m_159778_()).maxZOffset + context.m_225041_().m_188503_(((GlowSpikeFeatureConfig)context.m_159778_()).maxZOffset * 2);
            List<BlockPos> points = ShapeUtil.generateSolidCircle((float)diameter / 2.0f);
            for (BlockPos point : points) {
                BlockPos pointPos = new BlockPos(context.m_159777_().m_123341_() + point.m_123341_(), context.m_159777_().m_123342_(), context.m_159777_().m_123343_() + point.m_123343_());
                if (context.m_159774_().m_8055_(pointPos.m_7495_()).m_60795_()) {
                    if (context.m_225041_().m_188499_() && context.m_225041_().m_188499_()) {
                        return this.m_142674_(new FeaturePlaceContext(context.m_190935_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_().m_7495_(), (FeatureConfiguration)((GlowSpikeFeatureConfig)context.m_159778_())));
                    }
                    return false;
                }
                if (context.m_159774_().m_8055_(pointPos.m_7495_()).m_60734_() != Blocks.f_49991_) continue;
                return this.m_142674_(new FeaturePlaceContext(context.m_190935_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_().m_7495_(), (FeatureConfiguration)((GlowSpikeFeatureConfig)context.m_159778_())));
            }
            for (BlockPos point : points) {
                this.placeGlowSpikeLine(context.m_159774_(), context.m_159777_().m_7918_(point.m_123341_(), 0, point.m_123343_()), context.m_159777_().m_7918_(xOffset, height, zOffset), context.m_225041_(), (GlowSpikeFeatureConfig)context.m_159778_());
            }
            return true;
        }
        return false;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return false;
    }

    private void placeGlowSpikeLine(WorldGenLevel world, BlockPos startPos, BlockPos endPos, RandomSource random, GlowSpikeFeatureConfig config) {
        List<BlockPos> line = ShapeUtil.generateLine(startPos, endPos);
        for (int i = 0; i < line.size(); ++i) {
            BlockPos pos = line.get(i);
            if (pos.m_123342_() >= 128 || world.m_8055_(pos).equals(Blocks.f_50752_.m_49966_())) continue;
            float percentage = (float)i / (float)line.size() - config.blockDitheringAmount / 2.0f + random.m_188501_() * config.blockDitheringAmount;
            if ((double)percentage <= 0.33) {
                if (config.darkAtTop) {
                    world.m_7731_(pos, Blocks.f_50141_.m_49966_(), 2);
                    continue;
                }
                world.m_7731_(new BlockPos((Vec3i)pos), ((Block)IEBlocks.DULLSTONE.get()).m_49966_(), 2);
                continue;
            }
            if ((double)percentage > 0.33 && (double)percentage <= 0.66) {
                world.m_7731_(new BlockPos((Vec3i)pos), ((Block)IEBlocks.DIMSTONE.get()).m_49966_(), 2);
                continue;
            }
            if (config.darkAtTop) {
                world.m_7731_(new BlockPos((Vec3i)pos), ((Block)IEBlocks.DULLSTONE.get()).m_49966_(), 2);
                continue;
            }
            world.m_7731_(new BlockPos((Vec3i)pos), Blocks.f_50141_.m_49966_(), 2);
        }
    }
}

