/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.infernalstudios.infernalexp.blocks.GlowdustBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;

public class GlowLayerFeature
extends IEFeature<NoneFeatureConfiguration> {
    public GlowLayerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (context.m_159774_().m_5776_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)context.m_159777_());
        BlockPos.MutableBlockPos mutableBlockPosNeighbors = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutableBlockPos);
        boolean doExpandedPlacing = this.isMultipleBiomesInChunk(context.m_159774_(), context.m_159777_(), mutableBlockPos);
        ChunkAccess cachedChunk = context.m_159774_().m_46865_((BlockPos)mutableBlockPos);
        int minimumRange = doExpandedPlacing ? -12 : 0;
        int maxRange = doExpandedPlacing ? 28 : 16;
        for (int x = minimumRange; x < maxRange; ++x) {
            for (int z = minimumRange; z < maxRange; ++z) {
                int maxY;
                for (int y = maxY = context.m_159775_().m_214096_(context.m_159777_().m_123341_() + x, context.m_159777_().m_123343_() + z, Heightmap.Types.MOTION_BLOCKING, (LevelHeightAccessor)cachedChunk, context.m_159774_().m_6018_().m_7726_().m_214994_()); y > context.m_159775_().m_6337_(); --y) {
                    int glowdustLayerHeight;
                    BlockState currentBlock;
                    mutableBlockPos.m_122190_((Vec3i)context.m_159777_()).m_122184_(x, y, z);
                    if (cachedChunk.m_7697_().f_45578_ != x >> 4 || cachedChunk.m_7697_().f_45579_ != z >> 4) {
                        cachedChunk = context.m_159774_().m_46865_((BlockPos)mutableBlockPos);
                    }
                    if (!(currentBlock = cachedChunk.m_8055_((BlockPos)mutableBlockPos)).m_60713_((Block)IEBlocks.GLOWDUST_SAND.get()) || !cachedChunk.m_8055_((BlockPos)mutableBlockPos.m_122173_(Direction.UP)).m_60795_() || (glowdustLayerHeight = this.numberOfGlowdustSandNearby(context.m_159774_(), mutableBlockPos, mutableBlockPosNeighbors)) <= 0) continue;
                    context.m_159774_().m_7731_((BlockPos)mutableBlockPos, (BlockState)((Block)IEBlocks.GLOWDUST.get()).m_49966_().m_61124_((Property)GlowdustBlock.f_56581_, (Comparable)Integer.valueOf(glowdustLayerHeight)), 3);
                }
            }
        }
        return true;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return true;
    }

    private boolean isMultipleBiomesInChunk(WorldGenLevel world, BlockPos pos, BlockPos.MutableBlockPos mutableBlockPos) {
        Holder centerBiome = world.m_204166_((BlockPos)mutableBlockPos.m_122190_((Vec3i)pos).m_122184_(8, 0, 8));
        for (int x = 0; x <= 16; x += 8) {
            for (int z = 0; z <= 16; z += 8) {
                if (x == 8 || z == 8) continue;
                mutableBlockPos.m_122190_((Vec3i)pos);
                mutableBlockPos.m_122184_(x, 0, z);
                if (x == 16) {
                    mutableBlockPos.m_122184_(-1, 0, 0);
                }
                if (z == 16) {
                    mutableBlockPos.m_122184_(0, 0, -1);
                }
                if (centerBiome == world.m_204166_((BlockPos)mutableBlockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private int numberOfGlowdustSandNearby(WorldGenLevel world, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPosNeighbors) {
        int glowdustSandCount = 0;
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                mutableBlockPosNeighbors.m_122190_((Vec3i)mutableBlockPos).m_122184_(x, 0, z);
                BlockState neighborBlock = world.m_8055_((BlockPos)mutableBlockPosNeighbors);
                if (!neighborBlock.m_60713_((Block)IEBlocks.GLOWDUST_SAND.get())) continue;
                ++glowdustSandCount;
            }
        }
        return Math.min((int)Math.ceil((double)glowdustSandCount / 6.0), 8);
    }
}

