/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.tuple.Pair;

public class ShroomloinType {
    private static final Map<ResourceLocation, ShroomloinType> SHROOMLOIN_TYPES = new LinkedHashMap<ResourceLocation, ShroomloinType>();
    private Supplier<Item> conversionItem;
    private ResourceLocation id;
    private Pair<ResourceLocation, ResourceLocation> textures;

    public ShroomloinType(@Nullable Item conversionItem, ResourceLocation id, ResourceLocation texture, @Nullable ResourceLocation glowTexture) {
        this(() -> conversionItem, id, texture, glowTexture);
    }

    public ShroomloinType(@Nullable Supplier<Item> conversionItem, ResourceLocation id, ResourceLocation texture, @Nullable ResourceLocation glowTexture) {
        this(conversionItem, id, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)texture, (Object)glowTexture));
    }

    public ShroomloinType(@Nullable Supplier<Item> conversionItem, ResourceLocation id, Pair<ResourceLocation, ResourceLocation> textures) {
        this.conversionItem = conversionItem;
        this.id = id;
        this.textures = textures;
    }

    @CheckForNull
    public Item getConversionItem() {
        Item item = this.conversionItem.get();
        if (item == null || item.equals(Items.f_41852_)) {
            return null;
        }
        return item;
    }

    public void setConversionItem(@Nullable Item conversionItem) {
        this.conversionItem = () -> conversionItem;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textures.getLeft();
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textures = Pair.of((Object)textureLocation, (Object)((ResourceLocation)this.textures.getRight()));
    }

    public ResourceLocation getGlowTextureLocation() {
        return (ResourceLocation)this.textures.getRight();
    }

    public void setGlowTextureLocation(ResourceLocation textureLocation) {
        this.textures = Pair.of((Object)((ResourceLocation)this.textures.getLeft()), (Object)textureLocation);
    }

    public static ShroomloinType registerShroomloinType(ShroomloinType shroomloinType) {
        ResourceLocation id = shroomloinType.getId();
        if (SHROOMLOIN_TYPES.containsKey(id)) {
            throw new IllegalStateException(String.format("%s already exists in the ShroomloinType registry.", id.toString()));
        }
        SHROOMLOIN_TYPES.put(id, shroomloinType);
        return shroomloinType;
    }

    @Nullable
    public static ShroomloinType getById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return ShroomloinType.getById(ResourceLocation.m_135820_((String)id));
    }

    @Nullable
    public static ShroomloinType getById(@Nullable ResourceLocation id) {
        return SHROOMLOIN_TYPES.get(id);
    }

    @Nullable
    public static ShroomloinType getByItem(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        for (Map.Entry<ResourceLocation, ShroomloinType> entry : SHROOMLOIN_TYPES.entrySet()) {
            ShroomloinType shroomloinType = entry.getValue();
            Item conversionItem = shroomloinType.getConversionItem();
            if (conversionItem == null || !conversionItem.equals(item)) continue;
            return shroomloinType;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShroomloinType) {
            ShroomloinType type = (ShroomloinType)obj;
            return type.getId().equals((Object)this.getId()) && type.getConversionItem().equals(this.getConversionItem()) && type.getTextureLocation().equals((Object)this.getTextureLocation()) && type.getGlowTextureLocation().equals((Object)this.getGlowTextureLocation());
        }
        return false;
    }
}

