/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.entities.InfernalPaintingEntity;

public class SpawnInfernalPaintingPacket {
    private final int entityID;
    private final UUID uniqueID;
    private final BlockPos pos;
    private final Direction facing;
    private final String title;

    public SpawnInfernalPaintingPacket(InfernalPaintingEntity painting) {
        this.entityID = painting.m_19879_();
        this.uniqueID = painting.m_20148_();
        this.pos = painting.m_31748_();
        this.facing = painting.m_6350_();
        this.title = ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)painting.m_218901_().m_203334_())).toString();
    }

    public SpawnInfernalPaintingPacket(int entityID, UUID uniqueID, BlockPos pos, Direction facing, String title) {
        this.entityID = entityID;
        this.uniqueID = uniqueID;
        this.pos = pos;
        this.facing = facing;
        this.title = title;
    }

    public static void encode(SpawnInfernalPaintingPacket message, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130130_(message.entityID);
        packetBuffer.m_130077_(message.uniqueID);
        packetBuffer.m_130064_(message.pos);
        packetBuffer.writeByte(message.facing.m_122416_());
        packetBuffer.m_130070_(message.title);
    }

    public static SpawnInfernalPaintingPacket decode(FriendlyByteBuf packetBuffer) {
        return new SpawnInfernalPaintingPacket(packetBuffer.m_130242_(), packetBuffer.m_130259_(), packetBuffer.m_130135_(), Direction.m_122407_((int)packetBuffer.readByte()), packetBuffer.m_130277_());
    }

    public static void handle(SpawnInfernalPaintingPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
            InfernalPaintingEntity paintingEntity = new InfernalPaintingEntity(world.orElse(null), message.pos, message.facing, (PaintingVariant)ForgeRegistries.PAINTING_VARIANTS.getValue(new ResourceLocation(message.title)));
            paintingEntity.m_20234_(message.entityID);
            paintingEntity.m_20084_(message.uniqueID);
            world.filter(ClientLevel.class::isInstance).ifPresent(w -> ((ClientLevel)w).m_104627_(message.entityID, (Entity)paintingEntity));
        });
        ctx.get().setPacketHandled(true);
    }
}

