/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.access.FireTypeAccess;
import org.infernalstudios.infernalexp.api.FireType;
import org.infernalstudios.infernalexp.blocks.GlowFireBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEFireTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseFireBlock.class})
public abstract class MixinAbstractFireBlock
extends Block {
    private MixinAbstractFireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"getState"}, at={@At(value="HEAD")}, cancellable=true)
    private static void IE_getFireForPlacement(BlockGetter reader, BlockPos pos, CallbackInfoReturnable<BlockState> info) {
        if (GlowFireBlock.isGlowFireBase(reader.m_8055_(pos.m_7495_()))) {
            info.setReturnValue((Object)((Block)IEBlocks.GLOW_FIRE.get()).m_49966_());
        }
    }

    @Inject(method={"entityInside"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private void IE_setCustomFires(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, CallbackInfo info) {
        FireType.getFireTypes().forEach(fireType -> {
            if (fireType != IEFireTypes.FIRE && ModList.get().isLoaded(fireType.getName().m_135827_()) && ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).equals((Object)fireType.getBlock()) && state.m_60734_() instanceof BaseFireBlock) {
                ((FireTypeAccess)entityIn).setFireType((FireType)fireType);
            }
        });
    }
}

