/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.infernalstudios.infernalexp.init.IEStructurePools;
import org.infernalstudios.infernalexp.init.IETags;
import org.infernalstudios.infernalexp.world.gen.structures.SizeCheckingNetherStructure;
import org.infernalstudios.infernalexp.world.gen.structures.StriderAltarStructure;

public class IEStructures {
    public static final Holder<Structure> GLOWSTONE_CANYON_RUIN = IEStructures.registerStructure("glowstone_canyon_ruin", new SizeCheckingNetherStructure(IEStructures.settings(IETags.Biomes.HAS_GLOWSTONE_CANYON_RUIN, TerrainAdjustment.BEARD_THIN), IEStructurePools.GLOWSTONE_CANYON_RUIN, 5));
    public static final Holder<Structure> SOUL_SAND_VALLEY_RUIN = IEStructures.registerStructure("soul_sand_valley_ruin", new SizeCheckingNetherStructure(IEStructures.settings(IETags.Biomes.HAS_SOUL_SAND_VALLEY_RUIN, TerrainAdjustment.BEARD_THIN), IEStructurePools.SOUL_SAND_VALLEY_RUIN, 4));
    public static final Holder<Structure> BASTION_OUTPOST = IEStructures.registerStructure("bastion_outpost", new SizeCheckingNetherStructure(IEStructures.settings(IETags.Biomes.HAS_BASTION_OUTPOST, TerrainAdjustment.BEARD_BOX), IEStructurePools.BASTION_OUTPOST, 8));
    public static final Holder<Structure> STRIDER_ALTAR = IEStructures.registerStructure("strider_altar", new StriderAltarStructure(IEStructures.settings(IETags.Biomes.HAS_STRIDER_ALTAR, TerrainAdjustment.NONE), IEStructurePools.STRIDER_ALTAR));

    private static Holder<Structure> registerStructure(String name, Structure structure) {
        ResourceLocation resourceLocation = new ResourceLocation("infernalexp", name);
        if (BuiltinRegistries.f_235988_.m_6566_().contains(resourceLocation)) {
            throw new IllegalStateException("Configured Structure ID: \"" + resourceLocation + "\" is already in the registry!");
        }
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_235988_, (ResourceLocation)resourceLocation, (Object)structure);
    }

    private static Structure.StructureSettings settings(TagKey<Biome> biomes, TerrainAdjustment terrainAdjustment) {
        return new Structure.StructureSettings(IEStructures.biomes(biomes), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, terrainAdjustment);
    }

    private static HolderSet<Biome> biomes(TagKey<Biome> tag) {
        return BuiltinRegistries.f_123865_.m_203561_(tag);
    }

    public static void register() {
    }
}

