/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEItems;
import org.jetbrains.annotations.NotNull;

public class IELootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"infernalexp");
    public static final RegistryObject<Codec<HoglinLootModifier>> HOGLIN_LOOT_MODIFIER = LOOT_MODIFIERS.register("hoglin_loot_modifier", () -> HoglinLootModifier.CODEC);

    public static void register(IEventBus eventBus) {
        LOOT_MODIFIERS.register(eventBus);
        InfernalExpansion.LOGGER.info("Infernal Expansion: Loot Modifiers Registered!");
    }

    private static class HoglinLootModifier
    extends LootModifier {
        public static final Codec<HoglinLootModifier> CODEC = RecordCodecBuilder.create(builder -> HoglinLootModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, HoglinLootModifier::new));

        protected HoglinLootModifier(LootItemCondition[] conditions) {
            super(conditions);
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (!InfernalExpansionConfig.MobInteractions.USE_HOGCHOPS.getBoolean()) {
                return generatedLoot;
            }
            int numChops = 0;
            int numCookedChops = 0;
            for (ItemStack loot : generatedLoot) {
                if (loot.m_41656_(Items.f_42485_.m_7968_())) {
                    numChops = loot.m_41613_();
                    continue;
                }
                if (!loot.m_41656_(Items.f_42486_.m_7968_())) continue;
                numCookedChops = loot.m_41613_();
            }
            generatedLoot.removeIf(stack -> stack.m_150930_(Items.f_42485_));
            generatedLoot.removeIf(stack -> stack.m_150930_(Items.f_42486_));
            if ((double)context.m_230907_().m_188501_() < 0.4) {
                return generatedLoot;
            }
            generatedLoot.add((Object)new ItemStack((ItemLike)IEItems.COOKED_HOGCHOP.get(), Math.max(numCookedChops, 0)));
            generatedLoot.add((Object)new ItemStack((ItemLike)IEItems.RAW_HOGCHOP.get(), Math.max(numChops, 1)));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }
}

