/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.events;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.infernalstudios.infernalexp.blocks.BuriedBoneBlock;
import org.infernalstudios.infernalexp.blocks.DullthornsBlock;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.blocks.PlantedQuartzBlock;
import org.infernalstudios.infernalexp.config.ConfigHelper;
import org.infernalstudios.infernalexp.config.ConfigHolder;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.data.VolineEatTable;
import org.infernalstudios.infernalexp.entities.ShroomloinEntity;
import org.infernalstudios.infernalexp.entities.ThrowableBrickEntity;
import org.infernalstudios.infernalexp.entities.ThrowableFireChargeEntity;
import org.infernalstudios.infernalexp.entities.ThrowableMagmaCreamEntity;
import org.infernalstudios.infernalexp.entities.ThrowableNetherBrickEntity;
import org.infernalstudios.infernalexp.events.PostRightClickBlockEvent;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEParticleTypes;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.init.IETags;
import org.infernalstudios.infernalexp.items.IFuel;

@Mod.EventBusSubscriber(modid="infernalexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEvents {
    private static VolineEatTable volineEatTable;
    private static SpawnrateManager spawnrateManager;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        } else if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
            ConfigHelper.bakeCommon(config);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        int cost = event.getCost();
        if (left.m_41763_() && right.m_41720_() == IEItems.GLOWSILK.get() && !left.m_204117_(IETags.Items.GLOWSILK_REPAIR_BLACKLIST)) {
            if (left.m_41773_() == 0) {
                return;
            }
            ItemStack output = left.m_41777_();
            output.m_41721_(left.m_41773_() - 200);
            cost += 5;
            if (event.getName().equals("")) {
                if (left.m_41788_()) {
                    ++cost;
                    output.m_41787_();
                }
            } else if (!left.m_41786_().getString().equals(event.getName())) {
                ++cost;
                output.m_41714_((Component)Component.m_237113_((String)event.getName()));
            }
            event.setMaterialCost(1);
            event.setCost(cost);
            event.setOutput(output);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_5833_() || event.getPlayer().m_7500_()) {
            return;
        }
        BlockState state = event.getState();
        for (ShroomloinEntity shroomloin : event.getPlayer().f_19853_.m_45976_(ShroomloinEntity.class, event.getPlayer().m_20191_().m_82400_(32.0))) {
            if (shroomloin.getShroomloinType() == IEShroomloinTypes.CRIMSON && state.m_204336_(IETags.Blocks.ANGER_CRIMSON_SHROOMLOIN_BLOCKS)) {
                shroomloin.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloin.getShroomloinType() == IEShroomloinTypes.WARPED && state.m_204336_(IETags.Blocks.ANGER_WARPED_SHROOMLOIN_BLOCKS)) {
                shroomloin.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloin.getShroomloinType() == IEShroomloinTypes.LUMINOUS && state.m_204336_(IETags.Blocks.ANGER_LUMINOUS_SHROOMLOIN_BLOCKS)) {
                shroomloin.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloin.getShroomloinType() == IEShroomloinTypes.RED && state.m_204336_(IETags.Blocks.ANGER_RED_SHROOMLOIN_BLOCKS)) {
                shroomloin.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloin.getShroomloinType() != IEShroomloinTypes.BROWN || !state.m_204336_(IETags.Blocks.ANGER_BROWN_SHROOMLOIN_BLOCKS)) continue;
            shroomloin.becomeAngryAt((LivingEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PostRightClickBlockEvent event) {
        ItemStack heldItemStack = event.getItemStack();
        Level world = event.getEntity().m_9236_();
        BlockPos pos = event.getPos();
        Direction face = event.getDirection();
        Player player = event.getEntity();
        if (heldItemStack.m_41720_() == Items.f_42500_) {
            pos = pos.m_121945_(face);
            BlockState blockstate = ((BuriedBoneBlock)((Object)IEBlocks.BURIED_BONE.get())).getPlaceableState(world, pos, face);
            if (blockstate != null) {
                player.m_6674_(event.getHand());
                if (!world.m_46859_(pos) && !world.m_5776_() && world.m_8055_(pos).m_60819_().m_76178_()) {
                    world.m_46961_(pos, true);
                }
                world.m_7731_(pos, blockstate, 3);
                world.m_5594_(player, pos, blockstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
                ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos), (Direction)face);
            }
        } else if (heldItemStack.m_41720_() == Items.f_42692_) {
            pos = pos.m_121945_(face);
            BlockState blockstate = ((PlantedQuartzBlock)((Object)IEBlocks.PLANTED_QUARTZ.get())).getPlaceableState(world, pos, face);
            if (blockstate != null) {
                player.m_6674_(event.getHand());
                if (!world.m_46859_(pos) && !world.m_5776_() && world.m_8055_(pos).m_60819_().m_76178_()) {
                    world.m_46961_(pos, true);
                }
                world.m_7731_(pos, blockstate, 3);
                world.m_5594_(player, pos, blockstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
                ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos), (Direction)face);
            }
        } else if (heldItemStack.m_41720_() == Items.f_42525_) {
            if (heldItemStack.m_41613_() >= 2) {
                if (world.m_8055_(pos).m_60734_() == IEBlocks.DIMSTONE.get()) {
                    player.m_6674_(event.getHand());
                    for (int i = 0; i < 20; ++i) {
                        world.m_7106_((ParticleOptions)IEParticleTypes.GLOWSTONE_SPARKLE.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
                    }
                    world.m_5594_(null, event.getPos(), (SoundEvent)IESoundEvents.GLOWSTONE_RECHARGE.get(), SoundSource.BLOCKS, 1.0f, (float)(0.75 + event.getEntity().m_9236_().m_213780_().m_188500_() / 2.0));
                    world.m_46597_(pos, Blocks.f_50141_.m_49966_());
                    if (!player.m_7500_()) {
                        heldItemStack.m_41774_(2);
                    }
                } else if (world.m_8055_(pos).m_60734_() == IEBlocks.DULLSTONE.get()) {
                    player.m_6674_(event.getHand());
                    for (int i = 0; i < 20; ++i) {
                        world.m_7106_((ParticleOptions)IEParticleTypes.GLOWSTONE_SPARKLE.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
                    }
                    world.m_5594_(null, event.getPos(), (SoundEvent)IESoundEvents.GLOWSTONE_RECHARGE.get(), SoundSource.BLOCKS, 1.0f, (float)(0.5 + event.getEntity().m_9236_().m_213780_().m_188500_() / 3.0));
                    world.m_46597_(pos, ((Block)IEBlocks.DIMSTONE.get()).m_49966_());
                    if (!player.m_7500_()) {
                        heldItemStack.m_41774_(2);
                    }
                }
            }
            if (world.m_8055_(pos).m_60734_() == IEBlocks.DULLTHORNS.get()) {
                player.m_6674_(event.getHand());
                ((DullthornsBlock)world.m_8055_(pos).m_60734_()).bonemealGrow(world.m_8055_(pos), world, pos);
                world.m_46796_(2005, pos, 0);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Level world = event.getLevel();
        Player player = event.getEntity();
        ItemStack heldItemStack = player.m_21120_(event.getHand());
        if (heldItemStack.m_41720_() == Items.f_42542_) {
            player.m_6674_(event.getHand());
            if (!world.f_46443_) {
                ThrowableMagmaCreamEntity throwableMagmaCreamEntity = new ThrowableMagmaCreamEntity(world, (LivingEntity)player);
                throwableMagmaCreamEntity.m_37446_(heldItemStack);
                throwableMagmaCreamEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
                world.m_7967_((Entity)throwableMagmaCreamEntity);
                world.m_5594_(null, event.getPos(), SoundEvents.f_12473_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItemStack.m_41720_()));
            if (!player.m_150110_().f_35937_) {
                heldItemStack.m_41774_(1);
            }
        } else if (heldItemStack.m_41720_() == Items.f_42613_) {
            player.m_6674_(event.getHand());
            if (!world.f_46443_) {
                ThrowableFireChargeEntity throwableFireChargeEntity = new ThrowableFireChargeEntity(world, (LivingEntity)player, player.m_20154_().m_7096_(), player.m_20154_().m_7098_(), player.m_20154_().m_7094_());
                world.m_7967_((Entity)throwableFireChargeEntity);
                world.m_5594_(null, event.getPos(), SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItemStack.m_41720_()));
            if (!player.m_150110_().f_35937_) {
                heldItemStack.m_41774_(1);
            }
        }
        if (InfernalExpansionConfig.Miscellaneous.USE_THROWABLE_BRICKS.getBool()) {
            if (heldItemStack.m_41720_() == Items.f_42460_) {
                player.m_6674_(event.getHand());
                if (!world.f_46443_) {
                    ThrowableBrickEntity throwableBrickEntity = new ThrowableBrickEntity(world, (LivingEntity)player);
                    throwableBrickEntity.m_37446_(heldItemStack);
                    throwableBrickEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
                    world.m_7967_((Entity)throwableBrickEntity);
                    world.m_5594_(null, event.getPos(), SoundEvents.f_12473_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItemStack.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    heldItemStack.m_41774_(1);
                }
            }
            if (heldItemStack.m_41720_() == Items.f_42691_) {
                player.m_6674_(event.getHand());
                if (!world.f_46443_) {
                    ThrowableNetherBrickEntity throwableNetherBrickEntity = new ThrowableNetherBrickEntity(world, (LivingEntity)player);
                    throwableNetherBrickEntity.m_37446_(heldItemStack);
                    throwableNetherBrickEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.3f, 1.0f);
                    world.m_7967_((Entity)throwableNetherBrickEntity);
                    world.m_5594_(null, event.getPos(), SoundEvents.f_12473_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItemStack.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    heldItemStack.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        Block block = event.getBlock().m_60734_();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        if (block == Blocks.f_50701_ && InfernalExpansionConfig.Miscellaneous.SHROOMLIGHT_GROWABLE.getBool()) {
            if (world.m_46859_(pos = pos.m_7495_())) {
                event.setResult(Event.Result.ALLOW);
                if (world.m_213780_().m_188500_() < InfernalExpansionConfig.Miscellaneous.SHROOMLIGHT_GROW_CHANCE.getDouble() && !world.m_5776_()) {
                    world.m_7731_(pos, (BlockState)((Block)IEBlocks.SHROOMLIGHT_FUNGUS.get()).m_49966_().m_61124_((Property)HorizontalBushBlock.f_53179_, (Comparable)AttachFace.CEILING), 3);
                }
            }
        } else if (block == IEBlocks.DULLTHORNS.get() && ((DullthornsBlock)world.m_8055_(pos).m_60734_()).bonemealGrow(world.m_8055_(pos), world, pos)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPotionColorCalculate(PotionColorCalculationEvent event) {
        ArrayList effects = new ArrayList(event.getEffects());
        int customEffects = 0;
        for (MobEffectInstance effectInstance : effects) {
            if (effectInstance.m_19544_() != IEEffects.INFECTION.get() && effectInstance.m_19544_() != IEEffects.LUMINOUS.get()) continue;
            ++customEffects;
        }
        if (customEffects == effects.size()) {
            event.shouldHideParticles(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityUpdate(LivingEvent.LivingTickEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (entity.m_6142_() && (level = entity.m_20193_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (entity.m_21023_((MobEffect)IEEffects.INFECTION.get()) && (entity.m_21124_((MobEffect)IEEffects.INFECTION.get()).m_19557_() & 0xA) == 0 && entity.m_21124_((MobEffect)IEEffects.INFECTION.get()).m_19572_()) {
                world.m_8767_((ParticleOptions)((SimpleParticleType)IEParticleTypes.INFECTION.get()), entity.m_20208_(entity.m_20191_().m_82362_()), entity.m_20187_(), entity.m_20262_(entity.m_20191_().m_82385_()), 0, 0.0, 0.0, 0.0, 1.0);
            }
            if (entity.m_21023_((MobEffect)IEEffects.LUMINOUS.get())) {
                if ((entity.m_21124_((MobEffect)IEEffects.LUMINOUS.get()).m_19557_() & 0x32) == 0 && entity.m_21124_((MobEffect)IEEffects.LUMINOUS.get()).m_19572_()) {
                    world.m_8767_((ParticleOptions)((SimpleParticleType)IEParticleTypes.GLOWSTONE_SPARKLE.get()), entity.m_20208_(entity.m_20191_().m_82362_()), entity.m_20187_(), entity.m_20262_(entity.m_20191_().m_82385_()), 0, 0.0, 0.0, 0.0, 0.2);
                }
                if (entity instanceof Zombie && !(entity instanceof ZombifiedPiglin) || entity instanceof Skeleton) {
                    entity.m_20254_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFinishUse(LivingEntityUseItemEvent.Finish event) {
        ItemStack item = event.getItem();
        LivingEntity entity = event.getEntity();
        if (item.m_41720_() == IEItems.CURED_JERKY.get() && item.m_41780_() == UseAnim.EAT) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20 * InfernalExpansionConfig.Miscellaneous.JERKY_EFFECT_DURATION.getInt(), InfernalExpansionConfig.Miscellaneous.JERKY_EFFECT_AMPLIFIER.getInt()));
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AreaEffectCloud) {
            AreaEffectCloud entity2 = (AreaEffectCloud)entity;
            for (MobEffectInstance effect : entity2.f_19701_.m_43488_()) {
                if (effect.m_19544_() == IEEffects.INFECTION.get()) {
                    entity2.m_19724_((ParticleOptions)IEParticleTypes.INFECTION.get());
                    continue;
                }
                if (effect.m_19544_() != IEEffects.LUMINOUS.get()) continue;
                entity2.m_19724_((ParticleOptions)IEParticleTypes.GLOWSTONE_SPARKLE.get());
            }
        }
    }

    @SubscribeEvent
    public void onLivingEntityAttack(LivingAttackEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (entity.m_6142_() && (level = entity.m_20193_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (entity.m_21023_((MobEffect)IEEffects.INFECTION.get()) && event.getSource() != DamageSource.f_19319_) {
                for (int i = 0; i < 32; ++i) {
                    world.m_8767_((ParticleOptions)((SimpleParticleType)IEParticleTypes.INFECTION.get()), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        volineEatTable = new VolineEatTable();
        spawnrateManager = new SpawnrateManager();
        event.addListener((PreparableReloadListener)volineEatTable);
        spawnrateManager.loadResources();
    }

    public static Map<Item, Map<Item, Integer>> getVolineEatTable() {
        if (volineEatTable == null) {
            throw new IllegalStateException("Can not retrieve VolineEatTable until resources have loaded once.");
        }
        return volineEatTable.getVolineEatTable();
    }

    public static Map<String, Map<String, SpawnrateManager.SpawnInfo>> getSpawnrateManager() {
        if (spawnrateManager == null) {
            spawnrateManager = new SpawnrateManager();
        }
        return spawnrateManager.getSpawnrates();
    }

    @SubscribeEvent
    public void onCheckFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof IFuel) {
            IFuel fuel = (IFuel)item;
            event.setBurnTime(fuel.getBurnTime());
        }
    }
}

