/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.BlackstoneDwarfEntity;
import org.infernalstudios.infernalexp.entities.ai.TargetWithEffectGoal;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class GlowsquitoEntity
extends Animal
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> BRED = SynchedEntityData.m_135353_(GlowsquitoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)IEBlocks.SHROOMLIGHT_FUNGUS.get()).m_5456_()});
    private EatBlockGoal eatGrassGoal;
    private int hogTimer;

    public GlowsquitoEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22279_, 0.5);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        GlowsquitoEntity glowsquitoEntity = (GlowsquitoEntity)((EntityType)IEEntityTypes.GLOWSQUITO.get()).m_20615_((Level)world);
        glowsquitoEntity.setBred(true);
        return glowsquitoEntity;
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BRED, (Object)false);
    }

    public boolean getBred() {
        return (Boolean)this.f_19804_.m_135370_(BRED);
    }

    public void setBred(boolean isBred) {
        this.f_19804_.m_135381_(BRED, (Object)isBred);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Bred", this.getBred());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBred(compound.m_128471_("Bred"));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.35f : sizeIn.f_20378_ * 0.72f;
    }

    protected void m_7324_(Entity entityIn) {
        super.m_7324_(entityIn);
        if (!this.m_6162_() && entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (!(entityIn instanceof GlowsquitoEntity)) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 200));
            }
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.8, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.8, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(8, (Goal)new WanderGoal());
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_LUMINOUS.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new TargetWithEffectGoal((Mob)this, LivingEntity.class, true, false, (MobEffect)IEEffects.LUMINOUS.get(), GlowsquitoEntity.class));
        }
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_DWARF.getBoolean()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, BlackstoneDwarfEntity.class, true));
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_213860_() {
        return 1 + this.f_19853_.f_46441_.m_188503_(4);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.GLOWSQUITO_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.GLOWSQUITO_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean m_7327_(Entity entityIn) {
        if (!super.m_7327_(entityIn)) {
            return false;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 600, 0, true, true));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
        }
        return true;
    }

    protected void m_8024_() {
        this.hogTimer = this.eatGrassGoal.m_25213_();
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.hogTimer = Math.max(0, this.hogTimer - 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 10) {
            this.hogTimer = 40;
        } else {
            super.m_7822_(id);
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return GlowsquitoEntity.this.f_21344_.m_26571_() && GlowsquitoEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return GlowsquitoEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vector3d = this.getRandomLocation();
            if (vector3d != null) {
                GlowsquitoEntity.this.f_21344_.m_26536_(GlowsquitoEntity.this.f_21344_.m_7864_(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vector3d = GlowsquitoEntity.this.m_20252_(0.0f);
            Vec3 vector3d2 = AirRandomPos.m_148387_((PathfinderMob)GlowsquitoEntity.this, (int)8, (int)7, (int)2, (Vec3)vector3d, (double)1.5707963705062866);
            return vector3d2 != null ? vector3d2 : LandRandomPos.m_148492_((PathfinderMob)GlowsquitoEntity.this, (int)8, (int)4, (Vec3)vector3d);
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final GlowsquitoEntity parentEntity;

        public RandomFlyGoal(GlowsquitoEntity glowsquito) {
            this.parentEntity = glowsquito;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.parentEntity.m_217043_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final GlowsquitoEntity parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(GlowsquitoEntity ghast) {
            super((Mob)ghast);
            this.parentEntity = ghast;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.f_19853_.m_45756_((Entity)this.parentEntity, axisalignedbb = axisalignedbb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GlowsquitoEntity parentEntity;

        public LookAroundGoal(GlowsquitoEntity ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            Vec3 vector3d = this.parentEntity.m_20184_();
            this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
            this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
        }
    }
}

